# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl).

from odoo import fields, models


class MrpWorkcenter(models.Model):
    _inherit = "mrp.workcenter"

    pending_order_ids = fields.One2many(
        "mrp.workorder",
        "workcenter_id",
        domain=[("state", "in", ("pending", "waiting", "ready", "progress"))],
        string="Work Orders",
    )

    def _get_workcenter_line_domain(self):
        return [
            ("state", "in", ("pending", "waiting", "ready", "progress")),
            ("workcenter_id", "in", self.ids),
        ]

    def button_workcenter_line(self):
        self.ensure_one()
        domain = self._get_workcenter_line_domain()
        return {
            "view_mode": "tree,form",
            "name": "'%s' Workorders" % self.name,
            "res_model": "mrp.workorder",
            "type": "ir.actions.act_window",
            "domain": domain,
            "target": "current",
        }
