import logging

import nfelib
import pkg_resources
from nfelib.v4_00 import leiauteNFe_sub as nfe_sub

from odoo.models import NewId
from odoo.tests import SavepointCase

from odoo.addons.spec_driven_model import hooks

_logger = logging.getLogger(__name__)


class NFeImportTest(SavepointCase):
    def test_import_in_nfe_dry_run(self):
        hooks.register_hook(
            self.env,
            "l10n_br_nfe",
            "odoo.addons.l10n_br_nfe_spec.models.v4_0.leiaute_nfe_v4_00",
        )
        res_items = (
            "nfe",
            "samples",
            "v4_0",
            "leiauteNFe",
            "35180834128745000152550010000474281920007498-nfe.xml",
        )

        resource_path = "/".join(res_items)
        nfe_stream = pkg_resources.resource_stream(nfelib.__name__, resource_path)
        nfe_binding = nfe_sub.parse(nfe_stream, silence=True)
        nfe = (
            self.env["nfe.40.infnfe"]
            .with_context(tracking_disable=True, edoc_type="in", lang="pt_BR")
            .build_from_binding(nfe_binding.infNFe, dry_run=True)
        )
        assert isinstance(nfe.id, NewId)
        self._check_nfe(nfe)

    def test_import_in_nfe(self):
        hooks.register_hook(
            self.env,
            "l10n_br_nfe",
            "odoo.addons.l10n_br_nfe_spec.models.v4_0.leiaute_nfe_v4_00",
        )
        res_items = (
            "nfe",
            "samples",
            "v4_0",
            "leiauteNFe",
            "35180834128745000152550010000474281920007498-nfe.xml",
        )
        resource_path = "/".join(res_items)
        nfe_stream = pkg_resources.resource_stream(nfelib.__name__, resource_path)

        nfe_binding = nfe_sub.parse(nfe_stream, silence=True)
        nfe = (
            self.env["nfe.40.infnfe"]
            .with_context(tracking_disable=True, edoc_type="in", lang="pt_BR")
            .build_from_binding(nfe_binding.infNFe)
        )
        assert isinstance(nfe.id, int)
        self._check_nfe(nfe)

    def _check_nfe(self, nfe):
        self.assertEqual(type(nfe)._name, "l10n_br_fiscal.document")

        # here we check that emit and enderEmit
        # are now the supplier data (partner_id)
        self.assertEqual(nfe.partner_id.name, "Alimentos Saudaveis")
        # (CNPJ is not formated yet in dry run)
        self.assertTrue(
            nfe.partner_id.cnpj_cpf in ("34.128.745/0001-52", "34128745000152")
        )
        # this tests the _extract_related_values method for related values:
        self.assertEqual(nfe.partner_id.legal_name, "Alimentos Ltda.")

        # enderDest
        self.assertEqual(nfe.partner_id.street_name, "Rua Fonseca")  # related xLgr
        self.assertEqual(nfe.partner_id.zip, "13877-123")
        self.assertEqual(nfe.partner_id.nfe40_CEP, "13877123")
        self.assertEqual(nfe.partner_id.city_id.name, "São João da Boa Vista")

        # now we check that company_id is unchanged
        self.assertEqual(nfe.company_id.name, "Sua Empresa")

        # this tests that value is not overrident by stacked default vals
        self.assertEqual(nfe.nfe40_modFrete, "0")  # (default is 9)

        # lines data
        self.assertEqual(len(nfe.line_ids), 6)
        self.assertEqual(nfe.line_ids[0].quantity, 6)
        # NOTE / FIXME price unit is rounded to 7.16 if create and 7.155 if dry run
        self.assertTrue(abs(nfe.line_ids[0].price_unit - 7.16) < 0.01)
        self.assertTrue(abs(nfe.line_ids[0].fiscal_price - 7.16) < 0.01)

        # impostos
        self.assertEqual(nfe.line_ids[0].icms_base_type, "0")
        self.assertEqual(nfe.line_ids[0].icms_cst_id.code, "00")
        self.assertEqual(nfe.line_ids[0].icms_base, 50.60)
        self.assertEqual(nfe.line_ids[0].icms_value, 6.07)
        self.assertEqual(nfe.line_ids[0].ipi_value, 0)

        # products
        self.assertEqual(nfe.line_ids[0].nfe40_nItem, "1")
        if not isinstance(nfe.line_ids[0].product_id.id, NewId):
            self.assertEqual(nfe.line_ids[0].product_id.name, "QUINOA 100G (2X50G)")
            self.assertEqual(nfe.line_ids[0].product_id.barcode, "7897846902086")
            self.assertEqual(
                nfe.line_ids[0].product_id.ncm_id.name[0:14], "Trigo mourisco"
            )
            self.assertEqual(nfe.line_ids[0].product_id.ncm_id.code, "1008.50.90")

        if not isinstance(nfe.line_ids[1].product_id.id, NewId):
            self.assertEqual(
                nfe.line_ids[1].product_id.name, "QUINOA VEGETAIS 100G (2X50G)"
            )

        if not isinstance(nfe.line_ids[2].product_id.id, NewId):
            self.assertEqual(
                nfe.line_ids[2].product_id.name, "QUINOA PICANTE 100G (2X50G)"
            )

        # ds_object = nfe._build_generateds()
        # ds_object.export(
        #   sys.stdout,
        #   0,
        #   pretty_print=True,
        # )

    def test_import_out_nfe(self):
        "(can be useful after an ERP migration)"
