# Copyright 2018 Eficent Business and IT Consulting Services S.L.
#   (http://www.eficent.com)
# License AGPL-3.0 or later (https://www.gnu.org/licenses/agpl.html).

from dateutil.relativedelta import relativedelta
from odoo import api, fields, models


class ActivityStatementWizard(models.TransientModel):
    """Activity Statement wizard."""

    _inherit = 'statement.common.wizard'
    _name = 'activity.statement.wizard'
    _description = 'Activity Statement Wizard'

    @api.model
    def _get_date_start(self):
        return (
            fields.Date.context_today(self).replace(day=1) -
            relativedelta(days=1)
        ).replace(day=1)

    date_start = fields.Date(required=True, default=_get_date_start)

    @api.onchange('aging_type')
    def onchange_aging_type(self):
        super().onchange_aging_type()
        if self.aging_type == 'months':
            self.date_start = self.date_end.replace(day=1)
        else:
            self.date_start = self.date_end - relativedelta(days=30)

    def _export(self):
        """Export to PDF."""
        data = self._prepare_statement()
        return self.env.ref(
            'partner_statement'
            '.action_print_activity_statement').report_action(
            self, data=data)

    def _prepare_statement(self):
        res = super()._prepare_statement()
        res.update({'date_start': self.date_start, "is_activity": True})
        return res
