# Copyright 2018 Eficent Business and IT Consulting Services S.L.
#   (http://www.eficent.com)
# License AGPL-3.0 or later (https://www.gnu.org/licenses/agpl.html).

from odoo import models


class OutstandingStatementWizard(models.TransientModel):
    """Outstanding Statement wizard."""

    _name = 'outstanding.statement.wizard'
    _inherit = 'statement.common.wizard'
    _description = 'Outstanding Statement Wizard'

    def _prepare_statement(self):
        res = super()._prepare_statement()
        res.update({"is_outstanding": True})
        return res

    def _export(self):
        """Export to PDF."""
        data = self._prepare_statement()
        return self.env.ref(
            'partner_statement'
            '.action_print_outstanding_statement').report_action(
            self, data=data)
