# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl).

from odoo import fields, models

from odoo.addons.component.core import Component


class PrestashopShopGroup(models.Model):
    _name = "prestashop.shop.group"
    _inherit = "prestashop.binding"
    _description = "PrestaShop Shop Group"

    name = fields.Char("Name", required=True)
    shop_ids = fields.One2many(
        comodel_name="prestashop.shop",
        inverse_name="shop_group_id",
        readonly=True,
        string="Shops",
    )
    company_id = fields.Many2one(
        related="backend_id.company_id", comodel_name="res.company", string="Company"
    )


class ShopGroupAdapter(Component):
    _name = "prestashop.shop.group.adapter"
    _inherit = "prestashop.adapter"
    _apply_on = "prestashop.shop.group"
    _prestashop_model = "shop_groups"
