# License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl).

from odoo import models


class StockRule(models.Model):
    _inherit = "stock.rule"

    def _prepare_purchase_order_line(
        self, product_id, product_qty, product_uom, company_id, values, po
    ):
        res = super()._prepare_purchase_order_line(
            product_id, product_qty, product_uom, company_id, values, po
        )
        res.update({"account_analytic_id": values.get("account_analytic_id", False)})
        return res

    def _make_po_get_domain(self, company_id, values, partner):
        res = super()._make_po_get_domain(company_id, values, partner)
        if "account_analytic_id" in values and values["account_analytic_id"]:
            res += (
                (
                    "order_line.account_analytic_id",
                    "=",
                    values.get("account_analytic_id", False),
                ),
            )
        return res
