/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class PDFPrintPage
implements Printable {
    private PDFFile file;
    private PrinterJob pjob;
    private JDialog pd;
    private JLabel pagenumlabel;
    private JButton cancel;

    public PDFPrintPage(PDFFile pDFFile) {
        this.file = pDFFile;
    }

    public void printFile(String string, boolean bl) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        PDFFile pDFFile = new PDFFile(mappedByteBuffer);
        PDFPrintPage pDFPrintPage = new PDFPrintPage(pDFFile);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
        Paper paper = new Paper();
        paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
        pageFormat.setPaper(paper);
        if (bl) {
            pageFormat = PrinterJob.getPrinterJob().pageDialog(pageFormat);
        }
        printerJob.setJobName(file.getName());
        if (printerJob.printDialog()) {
            pageFormat = printerJob.validatePage(pageFormat);
            Book book = new Book();
            book.append(pDFPrintPage, pageFormat, pDFFile.getNumPages());
            printerJob.setPageable(book);
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                System.out.println(printerException);
            }
        }
    }

    private void createPrintDialog() {
        this.pd = new JDialog((Frame)null, "Printing...", false);
        Container container = this.pd.getContentPane();
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        box2.add(new JLabel("Now printing: "));
        JLabel jLabel = new JLabel("file.pdf");
        box2.add(jLabel);
        box.add(box2);
        box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalStrut(10));
        box2.add(new JLabel("page "));
        this.pagenumlabel = new JLabel("1");
        box2.add(this.pagenumlabel);
        box2.add(new JLabel(" of "));
        JLabel jLabel2 = new JLabel(String.valueOf(this.file.getNumPages()));
        box2.add(jLabel2);
        box.add(box2);
        container.add((Component)box, "Center");
        Box box3 = Box.createHorizontalBox();
        box3.add(Box.createHorizontalGlue());
        this.cancel = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PDFPrintPage.this.doCancel();
            }
        });
        box3.add(this.cancel);
        container.add((Component)box3, "South");
    }

    public void show(PrinterJob printerJob) {
        this.pjob = printerJob;
        if (this.pd == null) {
            this.createPrintDialog();
        }
        this.pd.pack();
        this.pd.setVisible(true);
    }

    public void hide() {
        this.pd.dispose();
    }

    public void doCancel() {
        this.cancel.setEnabled(false);
        this.pjob.cancel();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2 = n + 1;
        if (n2 >= 1 && n2 <= this.file.getNumPages()) {
            int n3;
            int n4;
            if (this.pagenumlabel != null) {
                this.pagenumlabel.setText(String.valueOf(n2));
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            PDFPage pDFPage = this.file.getPage(n2);
            double d = pageFormat.getImageableWidth();
            double d2 = pageFormat.getImageableHeight();
            double d3 = pDFPage.getAspectRatio();
            double d4 = d / d2;
            if (d4 < 1.0) {
                switch (pageFormat.getOrientation()) {
                    case 0: 
                    case 2: {
                        pageFormat.setOrientation(1);
                        break;
                    }
                    case 1: {
                        pageFormat.setOrientation(0);
                    }
                }
                d = pageFormat.getImageableWidth();
                d2 = pageFormat.getImageableHeight();
                d4 = d / d2;
            }
            if (d3 > d4) {
                n4 = (int)(d / d3);
                n3 = (int)d;
            } else {
                n3 = (int)(d2 * d3);
                n4 = (int)d2;
            }
            Rectangle rectangle = new Rectangle((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), n3, n4);
            PDFRenderer pDFRenderer = new PDFRenderer(pDFPage, graphics2D, rectangle, null, null);
            try {
                pDFPage.waitForFinish();
                pDFRenderer.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return 0;
        }
        return 1;
    }
}

