/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFCmd;
import com.sun.pdfview.PDFRenderer;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public class PDFShapeCmd
extends PDFCmd {
    public static final int STROKE = 1;
    public static final int FILL = 2;
    public static final int BOTH = 3;
    public static final int CLIP = 4;
    private GeneralPath gp;
    private int style;
    private Rectangle2D bounds;
    BasicStroke againstroke = new BasicStroke(2.0f, 0, 2);

    public PDFShapeCmd(GeneralPath generalPath, int n) {
        this.gp = new GeneralPath(generalPath);
        this.style = n;
        this.bounds = generalPath.getBounds2D();
    }

    @Override
    public Rectangle2D execute(PDFRenderer pDFRenderer) {
        Shape shape;
        Shape shape2 = null;
        if ((this.style & 2) != 0) {
            shape2 = pDFRenderer.fill(this.gp);
            shape = this.checkOverlap(pDFRenderer);
            if (shape != null) {
                pDFRenderer.draw((GeneralPath)shape, this.againstroke);
            }
            if (this.gp != null) {
                pDFRenderer.setLastShape(this.gp);
            }
        }
        if ((this.style & 1) != 0) {
            shape = pDFRenderer.stroke(this.gp);
            shape2 = shape2 == null ? shape : shape2.createUnion((Rectangle2D)shape);
        }
        if ((this.style & 4) != 0) {
            pDFRenderer.clip(this.gp);
        }
        return shape2;
    }

    private GeneralPath checkOverlap(PDFRenderer pDFRenderer) {
        if (this.style == 2 && this.gp != null && pDFRenderer.getLastShape() != null) {
            float[] fArray = new float[16];
            float[] fArray2 = new float[16];
            int n = this.getPoints(this.gp, fArray);
            int n2 = this.getPoints(pDFRenderer.getLastShape(), fArray2);
            if (fArray != null && fArray2 != null) {
                for (int i = 0; i < n2; i += 4) {
                    for (int j = 0; j < n; j += 4) {
                        if (!((double)Math.abs(fArray[j + 2] - fArray2[i]) < 0.01) || !((double)Math.abs(fArray[j + 3] - fArray2[i + 1]) < 0.01) || !((double)Math.abs(fArray[j] - fArray2[i + 2]) < 0.01) || !((double)Math.abs(fArray[j + 1] - fArray2[i + 3]) < 0.01)) continue;
                        GeneralPath generalPath = new GeneralPath();
                        generalPath.moveTo(fArray[j], fArray[j + 1]);
                        generalPath.lineTo(fArray[j + 2], fArray[j + 3]);
                        return generalPath;
                    }
                }
            }
        }
        return null;
    }

    private int getPoints(GeneralPath generalPath, float[] fArray) {
        int n = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float[] fArray2 = new float[6];
        PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            if (n >= fArray.length) {
                fArray = null;
                break;
            }
            int n2 = pathIterator.currentSegment(fArray2);
            switch (n2) {
                case 0: {
                    f3 = f = fArray2[0];
                    f4 = f2 = fArray2[1];
                    break;
                }
                case 1: {
                    fArray[n++] = f;
                    fArray[n++] = f2;
                    int n3 = n++;
                    float f5 = fArray2[0];
                    fArray[n3] = f5;
                    f = f5;
                    int n4 = n++;
                    float f6 = fArray2[1];
                    fArray[n4] = f6;
                    f2 = f6;
                    break;
                }
                case 2: {
                    f = fArray2[2];
                    f2 = fArray2[3];
                    break;
                }
                case 3: {
                    f = fArray[4];
                    f2 = fArray[5];
                    break;
                }
                case 4: {
                    fArray[n++] = f;
                    fArray[n++] = f2;
                    int n5 = n++;
                    float f7 = f3;
                    fArray[n5] = f7;
                    f = f7;
                    int n6 = n++;
                    float f8 = f4;
                    fArray[n6] = f8;
                    f2 = f8;
                }
            }
            pathIterator.next();
        }
        return n;
    }

    @Override
    public String getDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        Rectangle2D rectangle2D = this.gp.getBounds2D();
        stringBuffer.append("ShapeCommand at: " + rectangle2D.getX() + ", " + rectangle2D.getY() + "\n");
        stringBuffer.append("Size: " + rectangle2D.getWidth() + " x " + rectangle2D.getHeight() + "\n");
        stringBuffer.append("Mode: ");
        if ((this.style & 2) != 0) {
            stringBuffer.append("FILL ");
        }
        if ((this.style & 1) != 0) {
            stringBuffer.append("STROKE ");
        }
        if ((this.style & 4) != 0) {
            stringBuffer.append("CLIP");
        }
        return stringBuffer.toString();
    }
}

