/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFXref;
import java.lang.ref.SoftReference;

public class PDFXrefEntry {
    private static final PDFXrefEntry FREED_OBJECT = new PDFXrefEntry(Type.FREE, -1, -1, null);
    private Type type;
    private int generation;
    private int offset;
    private PDFXref stream;
    private int[] objectIndexOffsets = null;
    private SoftReference<PDFObject> target = null;

    static PDFXrefEntry toBodyObject(int n, int n2) {
        return new PDFXrefEntry(Type.OBJ_IN_BODY, n, n2, null);
    }

    static PDFXrefEntry toStreamObject(PDFXref pDFXref, int n) {
        return new PDFXrefEntry(Type.OBJ_IN_STREAM, 0, n, pDFXref);
    }

    static PDFXrefEntry forFreedObject() {
        return FREED_OBJECT;
    }

    public boolean resolves(PDFXref pDFXref) {
        return this.type != Type.FREE && this.generation == pDFXref.getGeneration();
    }

    private PDFXrefEntry(Type type, int n, int n2, PDFXref pDFXref) {
        this.type = type;
        this.generation = n;
        this.offset = n2;
        this.stream = pDFXref;
    }

    public int getOffset() {
        return this.offset;
    }

    public PDFXref getStream() {
        return this.stream;
    }

    public Type getType() {
        return this.type;
    }

    public int getGeneration() {
        return this.generation;
    }

    public PDFObject getObject() {
        if (this.target != null) {
            return this.target.get();
        }
        return null;
    }

    public void setObject(PDFObject pDFObject) {
        this.target = new SoftReference<PDFObject>(pDFObject);
    }

    public int[] getObjectIndexOffsets() {
        return this.objectIndexOffsets;
    }

    public void setObjectIndexOffsets(int[] nArray) {
        this.objectIndexOffsets = nArray;
    }

    static enum Type {
        FREE,
        OBJ_IN_BODY,
        OBJ_IN_STREAM;


        public static Type forTypeField(int n) {
            if (n > 0 && n < 3) {
                return Type.values()[n];
            }
            return FREE;
        }

        public PDFXrefEntry makeXrefStreamEntry(int n, int n2) {
            switch (this) {
                case FREE: {
                    return PDFXrefEntry.forFreedObject();
                }
                case OBJ_IN_BODY: {
                    return PDFXrefEntry.toBodyObject(n2, n);
                }
                case OBJ_IN_STREAM: {
                    return PDFXrefEntry.toStreamObject(new PDFXref(n, 0), n2);
                }
            }
            throw new UnsupportedOperationException("Unhandled xref entry type " + (Object)((Object)this));
        }
    }
}

