/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.font.PDFFontDescriptor;
import com.sun.pdfview.font.TTFFont;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class CIDFontType2
extends TTFFont {
    private Map<Character, Float> widths = null;
    private Map<Character, Float> widthsVertical = null;
    private int defaultWidth = 1000;
    private int defaultWidthVertical = 1000;
    private ByteBuffer cidToGidMap;

    public CIDFontType2(String string, PDFObject pDFObject, PDFFontDescriptor pDFFontDescriptor) throws IOException {
        super(string, pDFObject, pDFFontDescriptor);
        this.parseWidths(pDFObject);
        PDFObject pDFObject2 = pDFObject.getDictRef("CIDSystemInfo");
        PDFObject pDFObject3 = pDFObject.getDictRef("CIDToGIDMap");
        if (pDFObject3 != null && pDFObject3.getType() == 7) {
            this.cidToGidMap = pDFObject3.getStreamBuffer();
        }
    }

    private void parseWidths(PDFObject pDFObject) throws IOException {
        float f;
        Character c;
        int n;
        int n2;
        PDFObject[] pDFObjectArray;
        PDFObject pDFObject2 = pDFObject.getDictRef("DW");
        if (pDFObject2 != null) {
            this.defaultWidth = pDFObject2.getIntValue();
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        PDFObject pDFObject3 = pDFObject.getDictRef("W");
        if (pDFObject3 != null) {
            this.widths = new HashMap<Character, Float>();
            pDFObjectArray = pDFObject3.getArray();
            for (n2 = 0; n2 < pDFObjectArray.length; ++n2) {
                if (n3 == 0) {
                    n4 = pDFObjectArray[n2].getIntValue();
                } else if (n3 == 1) {
                    if (pDFObjectArray[n2].getType() == 5) {
                        PDFObject[] pDFObjectArray2 = pDFObjectArray[n2].getArray();
                        for (n = 0; n < pDFObjectArray2.length; ++n) {
                            c = new Character((char)(n + n4));
                            f = pDFObjectArray2[n].getIntValue();
                            this.widths.put(c, new Float(f));
                        }
                        n3 = -1;
                    } else {
                        n5 = pDFObjectArray[n2].getIntValue();
                    }
                } else {
                    int n6 = pDFObjectArray[n2].getIntValue();
                    for (n = n4; n <= n5; ++n) {
                        this.widths.put(new Character((char)n), new Float(n6));
                    }
                    n3 = -1;
                }
                ++n3;
            }
        }
        if ((pDFObject2 = pDFObject.getDictRef("DW2")) != null) {
            this.defaultWidthVertical = pDFObject2.getIntValue();
        }
        if ((pDFObject3 = pDFObject.getDictRef("W2")) != null) {
            this.widthsVertical = new HashMap<Character, Float>();
            pDFObjectArray = pDFObject3.getArray();
            n3 = 0;
            n4 = 0;
            n5 = 0;
            for (n2 = 0; n2 < pDFObjectArray.length; ++n2) {
                if (n3 == 0) {
                    n4 = pDFObjectArray[n2].getIntValue();
                } else if (n3 == 1) {
                    if (pDFObjectArray[n2].getType() == 5) {
                        PDFObject[] pDFObjectArray3 = pDFObjectArray[n2].getArray();
                        for (n = 0; n < pDFObjectArray3.length; ++n) {
                            c = new Character((char)(n + n4));
                            f = pDFObjectArray3[n].getIntValue();
                            this.widthsVertical.put(c, new Float(f));
                        }
                        n3 = -1;
                    } else {
                        n5 = pDFObjectArray[n2].getIntValue();
                    }
                } else {
                    int n7 = pDFObjectArray[n2].getIntValue();
                    for (n = n4; n <= n5; ++n) {
                        this.widthsVertical.put(new Character((char)n), new Float(n7));
                    }
                    n3 = -1;
                }
                ++n3;
            }
        }
    }

    @Override
    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    @Override
    public float getWidth(char c, String string) {
        if (this.widths == null) {
            return 1.0f;
        }
        Float f = this.widths.get(new Character(c));
        if (f == null) {
            return 1.0f;
        }
        return f.floatValue() / (float)this.getDefaultWidth();
    }

    public int getDefaultWidthVertical() {
        return this.defaultWidthVertical;
    }

    public float getWidthVertical(char c, String string) {
        if (this.widthsVertical == null) {
            return 1.0f;
        }
        Float f = this.widthsVertical.get(new Character(c));
        if (f == null) {
            return 1.0f;
        }
        return f.floatValue() / (float)this.getDefaultWidth();
    }

    @Override
    protected synchronized GeneralPath getOutline(char c, float f) {
        int n = c & 0xFFFF;
        if (this.cidToGidMap != null) {
            n = this.cidToGidMap.getChar(n * 2);
        }
        return this.getOutline(n, f);
    }
}

