/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.TrueTypeTable;
import java.nio.ByteBuffer;
import java.util.Date;

public class HeadTable
extends TrueTypeTable {
    private int version;
    private int fontRevision;
    private int checksumAdjustment;
    private int magicNumber;
    private short flags;
    private short unitsPerEm;
    private long created;
    private long modified;
    private short xMin;
    private short yMin;
    private short xMax;
    private short yMax;
    private short macStyle;
    private short lowestRecPPem;
    private short fontDirectionHint;
    private short indexToLocFormat;
    private short glyphDataFormat;

    protected HeadTable() {
        super(1751474532);
        this.setVersion(65536);
        this.setFontRevision(65536);
        this.setChecksumAdjustment(0);
        this.setMagicNumber(1594834165);
        this.setFlags((short)0);
        this.setUnitsPerEm((short)64);
        this.setCreated(System.currentTimeMillis());
        this.setModified(System.currentTimeMillis());
        this.setXMin((short)0);
        this.setXMax((short)Short.MAX_VALUE);
        this.setYMin((short)0);
        this.setYMax((short)Short.MAX_VALUE);
        this.setMacStyle((short)0);
        this.setLowestRecPPem((short)0);
        this.setFontDirectionHint((short)0);
        this.setIndexToLocFormat((short)0);
        this.setGlyphDataFormat((short)0);
    }

    @Override
    public void setData(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() != 54) {
            throw new IllegalArgumentException("Bad Head table size");
        }
        this.setVersion(byteBuffer.getInt());
        this.setFontRevision(byteBuffer.getInt());
        this.setChecksumAdjustment(byteBuffer.getInt());
        this.setMagicNumber(byteBuffer.getInt());
        this.setFlags(byteBuffer.getShort());
        this.setUnitsPerEm(byteBuffer.getShort());
        this.setCreated(byteBuffer.getLong());
        this.setModified(byteBuffer.getLong());
        this.setXMin(byteBuffer.getShort());
        this.setXMax(byteBuffer.getShort());
        this.setYMin(byteBuffer.getShort());
        this.setYMax(byteBuffer.getShort());
        this.setMacStyle(byteBuffer.getShort());
        this.setLowestRecPPem(byteBuffer.getShort());
        this.setFontDirectionHint(byteBuffer.getShort());
        this.setIndexToLocFormat(byteBuffer.getShort());
        this.setGlyphDataFormat(byteBuffer.getShort());
    }

    @Override
    public ByteBuffer getData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getLength());
        byteBuffer.putInt(this.getVersion());
        byteBuffer.putInt(this.getFontRevision());
        byteBuffer.putInt(this.getChecksumAdjustment());
        byteBuffer.putInt(this.getMagicNumber());
        byteBuffer.putShort(this.getFlags());
        byteBuffer.putShort(this.getUnitsPerEm());
        byteBuffer.putLong(this.getCreated());
        byteBuffer.putLong(this.getModified());
        byteBuffer.putShort(this.getXMin());
        byteBuffer.putShort(this.getXMax());
        byteBuffer.putShort(this.getYMin());
        byteBuffer.putShort(this.getYMax());
        byteBuffer.putShort(this.getMacStyle());
        byteBuffer.putShort(this.getLowestRecPPem());
        byteBuffer.putShort(this.getFontDirectionHint());
        byteBuffer.putShort(this.getIndexToLocFormat());
        byteBuffer.putShort(this.getGlyphDataFormat());
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public int getLength() {
        return 54;
    }

    public int getVersion() {
        return this.version;
    }

    public int getFontRevision() {
        return this.fontRevision;
    }

    public int getChecksumAdjustment() {
        return this.checksumAdjustment;
    }

    public int getMagicNumber() {
        return this.magicNumber;
    }

    public short getFlags() {
        return this.flags;
    }

    public short getUnitsPerEm() {
        return this.unitsPerEm;
    }

    public long getCreated() {
        return this.created;
    }

    public long getModified() {
        return this.modified;
    }

    public short getXMin() {
        return this.xMin;
    }

    public short getYMin() {
        return this.yMin;
    }

    public short getXMax() {
        return this.xMax;
    }

    public short getYMax() {
        return this.yMax;
    }

    public short getMacStyle() {
        return this.macStyle;
    }

    public short getLowestRecPPem() {
        return this.lowestRecPPem;
    }

    public short getFontDirectionHint() {
        return this.fontDirectionHint;
    }

    public short getIndexToLocFormat() {
        return this.indexToLocFormat;
    }

    public short getGlyphDataFormat() {
        return this.glyphDataFormat;
    }

    public void setXMax(short s) {
        this.xMax = s;
    }

    public void setXMin(short s) {
        this.xMin = s;
    }

    public void setYMax(short s) {
        this.yMax = s;
    }

    public void setYMin(short s) {
        this.yMin = s;
    }

    public void setChecksumAdjustment(int n) {
        this.checksumAdjustment = n;
    }

    public void setCreated(long l) {
        this.created = l;
    }

    public void setFlags(short s) {
        this.flags = s;
    }

    public void setFontDirectionHint(short s) {
        this.fontDirectionHint = s;
    }

    public void setFontRevision(int n) {
        this.fontRevision = n;
    }

    public void setGlyphDataFormat(short s) {
        this.glyphDataFormat = s;
    }

    public void setIndexToLocFormat(short s) {
        this.indexToLocFormat = s;
    }

    public void setLowestRecPPem(short s) {
        this.lowestRecPPem = s;
    }

    public void setMacStyle(short s) {
        this.macStyle = s;
    }

    public void setMagicNumber(int n) {
        this.magicNumber = n;
    }

    public void setModified(long l) {
        this.modified = l;
    }

    public void setUnitsPerEm(short s) {
        this.unitsPerEm = s;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "    ";
        stringBuffer.append(string + "Version          : " + Integer.toHexString(this.getVersion()) + "\n");
        stringBuffer.append(string + "Revision         : " + Integer.toHexString(this.getFontRevision()) + "\n");
        stringBuffer.append(string + "ChecksumAdj      : " + Integer.toHexString(this.getChecksumAdjustment()) + "\n");
        stringBuffer.append(string + "MagicNumber      : " + Integer.toHexString(this.getMagicNumber()) + "\n");
        stringBuffer.append(string + "Flags            : " + Integer.toBinaryString(this.getFlags()) + "\n");
        stringBuffer.append(string + "UnitsPerEm       : " + this.getUnitsPerEm() + "\n");
        stringBuffer.append(string + "Created          : " + new Date(this.getCreated()) + "\n");
        stringBuffer.append(string + "Modified         : " + new Date(this.getModified()) + "\n");
        stringBuffer.append(string + "XMin             : " + this.getXMin() + "\n");
        stringBuffer.append(string + "XMax             : " + this.getXMax() + "\n");
        stringBuffer.append(string + "YMin             : " + this.getYMin() + "\n");
        stringBuffer.append(string + "YMax             : " + this.getYMax() + "\n");
        stringBuffer.append(string + "MacStyle         : " + Integer.toBinaryString(this.getMacStyle()) + "\n");
        stringBuffer.append(string + "LowestPPem       : " + this.getLowestRecPPem() + "\n");
        stringBuffer.append(string + "FontDirectionHint: " + this.getFontDirectionHint() + "\n");
        stringBuffer.append(string + "IndexToLocFormat : " + this.getIndexToLocFormat() + "\n");
        stringBuffer.append(string + "GlyphDataFormat  : " + this.getGlyphDataFormat() + "\n");
        return stringBuffer.toString();
    }
}

