/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.function;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.function.PDFFunction;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.LinkedList;

public class FunctionType4
extends PDFFunction {
    private static HashSet<Operation> operationSet = null;
    private LinkedList tokens = new LinkedList();
    private LinkedList<Object> stack = new LinkedList();

    protected FunctionType4() {
        super(4);
        if (operationSet == null) {
            this.initOperations();
        }
    }

    private void initOperations() {
        if (operationSet == null) {
            operationSet = new HashSet();
            operationSet.add(new Operation("abs"){

                @Override
                void eval() {
                    FunctionType4.this.pushDouble(Math.abs(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("add"){

                @Override
                void eval() {
                    FunctionType4.this.pushDouble(FunctionType4.this.popDouble() + FunctionType4.this.popDouble());
                }
            });
            operationSet.add(new Operation("atan"){

                @Override
                void eval() {
                    double d = FunctionType4.this.popDouble();
                    double d2 = FunctionType4.this.popDouble();
                    if (d == 0.0) {
                        FunctionType4.this.pushDouble(90.0);
                    } else {
                        FunctionType4.this.pushDouble(Math.toDegrees(Math.atan(d2 / d)));
                    }
                }
            });
            operationSet.add(new Operation("ceiling"){

                @Override
                void eval() {
                    FunctionType4.this.pushDouble(Math.ceil(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("cvi"){

                @Override
                void eval() {
                    FunctionType4.this.pushDouble((int)FunctionType4.this.popDouble());
                }
            });
            operationSet.add(new Operation("cvr"){

                @Override
                void eval() {
                }
            });
            operationSet.add(new Operation("div"){

                @Override
                void eval() {
                    double d = FunctionType4.this.popDouble();
                    double d2 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushDouble(d2 / d);
                }
            });
            operationSet.add(new Operation("exp"){

                @Override
                void eval() {
                    double d = FunctionType4.this.popDouble();
                    double d2 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushDouble(Math.pow(d, d2));
                }
            });
            operationSet.add(new Operation("floor"){

                @Override
                void eval() {
                    FunctionType4.this.pushDouble(Math.floor(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("idiv"){

                @Override
                void eval() {
                    long l = FunctionType4.this.popLong();
                    long l2 = FunctionType4.this.popLong();
                    FunctionType4.this.pushLong(l2 / l);
                }
            });
            operationSet.add(new Operation("ln"){

                @Override
                void eval() {
                    FunctionType4.this.pushDouble(Math.log(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("log"){

                @Override
                void eval() {
                    FunctionType4.this.pushDouble(Math.log10(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("mod"){

                @Override
                void eval() {
                    long l = FunctionType4.this.popLong();
                    long l2 = FunctionType4.this.popLong();
                    FunctionType4.this.pushLong(l2 % l);
                }
            });
            operationSet.add(new Operation("mul"){

                @Override
                void eval() {
                    FunctionType4.this.pushDouble(FunctionType4.this.popDouble() * FunctionType4.this.popDouble());
                }
            });
            operationSet.add(new Operation("neg"){

                @Override
                void eval() {
                    FunctionType4.this.pushDouble(-FunctionType4.this.popDouble());
                }
            });
            operationSet.add(new Operation("round"){

                @Override
                void eval() {
                    FunctionType4.this.pushLong(Math.round(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("sin"){

                @Override
                void eval() {
                    double d = Math.toRadians(FunctionType4.this.popDouble());
                    FunctionType4.this.pushDouble(Math.toDegrees(Math.sin(d)));
                }
            });
            operationSet.add(new Operation("sqrt"){

                @Override
                void eval() {
                    FunctionType4.this.pushDouble(Math.sqrt(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("sub"){

                @Override
                void eval() {
                    double d = FunctionType4.this.popDouble();
                    double d2 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushDouble(d2 - d);
                }
            });
            operationSet.add(new Operation("truncate"){

                @Override
                void eval() {
                    double d = FunctionType4.this.popDouble();
                    FunctionType4.this.pushDouble((double)((long)d) - d);
                }
            });
            operationSet.add(new Operation("and"){

                @Override
                void eval() {
                    FunctionType4.this.pushLong(FunctionType4.this.popLong() & FunctionType4.this.popLong());
                }
            });
            operationSet.add(new Operation("bitshift"){

                @Override
                void eval() {
                    long l = FunctionType4.this.popLong();
                    long l2 = FunctionType4.this.popLong();
                    FunctionType4.this.pushLong(l2 << (int)l);
                }
            });
            operationSet.add(new Operation("eq"){

                @Override
                void eval() {
                    FunctionType4.this.pushBoolean(FunctionType4.this.popObject().equals(FunctionType4.this.popObject()));
                }
            });
            operationSet.add(new Operation("false"){

                @Override
                void eval() {
                    FunctionType4.this.pushBoolean(false);
                }
            });
            operationSet.add(new Operation("ge"){

                @Override
                void eval() {
                    double d = FunctionType4.this.popDouble();
                    double d2 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushBoolean(d2 >= d);
                }
            });
            operationSet.add(new Operation("gt"){

                @Override
                void eval() {
                    double d = FunctionType4.this.popDouble();
                    double d2 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushBoolean(d2 > d);
                }
            });
            operationSet.add(new Operation("le"){

                @Override
                void eval() {
                    double d = FunctionType4.this.popDouble();
                    double d2 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushBoolean(d2 <= d);
                }
            });
            operationSet.add(new Operation("lt"){

                @Override
                void eval() {
                    double d = FunctionType4.this.popDouble();
                    double d2 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushBoolean(d2 < d);
                }
            });
            operationSet.add(new Operation("ne"){

                @Override
                void eval() {
                    FunctionType4.this.pushBoolean(!FunctionType4.this.popObject().equals(FunctionType4.this.popObject()));
                }
            });
            operationSet.add(new Operation("not"){

                @Override
                void eval() {
                    FunctionType4.this.pushLong(FunctionType4.this.popLong() ^ 0xFFFFFFFFFFFFFFFFL);
                }
            });
            operationSet.add(new Operation("or"){

                @Override
                void eval() {
                    FunctionType4.this.pushLong(FunctionType4.this.popLong() | FunctionType4.this.popLong());
                }
            });
            operationSet.add(new Operation("true"){

                @Override
                void eval() {
                    FunctionType4.this.pushBoolean(true);
                }
            });
            operationSet.add(new Operation("xor"){

                @Override
                void eval() {
                    FunctionType4.this.pushLong(FunctionType4.this.popLong() ^ FunctionType4.this.popLong());
                }
            });
            operationSet.add(new Operation("if"){

                @Override
                void eval() {
                    if (FunctionType4.this.popBoolean()) {
                        FunctionType4.this.stack.addFirst(FunctionType4.this.popExpression());
                    } else {
                        FunctionType4.this.popExpression();
                    }
                }
            });
            operationSet.add(new Operation("ifelse"){

                @Override
                void eval() {
                    if (FunctionType4.this.popBoolean()) {
                        FunctionType4.this.popExpression();
                    } else {
                        FunctionType4.this.popExpression();
                    }
                }
            });
            operationSet.add(new Operation("copy"){

                @Override
                void eval() {
                    long l = FunctionType4.this.popLong();
                    Object e = FunctionType4.this.stack.removeFirst();
                    FunctionType4.this.stack.addFirst(e);
                    FunctionType4.this.stack.addFirst(e);
                }
            });
            operationSet.add(new Operation("dup"){

                @Override
                void eval() {
                    Object object = FunctionType4.this.popObject();
                    FunctionType4.this.pushObject(object);
                    FunctionType4.this.pushObject(object);
                }
            });
            operationSet.add(new Operation("exch"){

                @Override
                void eval() {
                    Object object = FunctionType4.this.popObject();
                    Object object2 = FunctionType4.this.popObject();
                    FunctionType4.this.pushObject(object2);
                    FunctionType4.this.pushObject(object);
                }
            });
            operationSet.add(new Operation("index"){

                @Override
                void eval() {
                    Object e = FunctionType4.this.stack.removeFirst();
                    FunctionType4.this.stack.addFirst(e);
                    FunctionType4.this.stack.addFirst(e);
                }
            });
            operationSet.add(new Operation("pop"){

                @Override
                void eval() {
                    FunctionType4.this.stack.removeFirst();
                }
            });
            operationSet.add(new Operation("roll"){

                @Override
                void eval() {
                    Object e = FunctionType4.this.stack.removeFirst();
                    FunctionType4.this.stack.addFirst(e);
                    FunctionType4.this.stack.addFirst(e);
                }
            });
        }
    }

    @Override
    protected void parse(PDFObject pDFObject) throws IOException {
        this.readPS(pDFObject.getStreamBuffer());
        throw new PDFParseException("Unsupported function type 4.");
    }

    @Override
    protected void doFunction(float[] fArray, int n, float[] fArray2, int n2) {
    }

    private boolean popBoolean() {
        return false;
    }

    private void pushBoolean(boolean bl) {
    }

    private double popDouble() {
        return 0.0;
    }

    private void pushDouble(double d) {
    }

    private Expression popExpression() {
        return null;
    }

    private void pushExpression(Expression expression) {
    }

    private long popLong() {
        return 0L;
    }

    private void pushLong(long l) {
    }

    private Object popObject() {
        return this.stack.removeFirst();
    }

    private void pushObject(Object object) {
        this.stack.addFirst(object);
    }

    private void readPS(ByteBuffer byteBuffer) {
    }

    abstract class Operation {
        private String operatorName;

        public Operation(String string) {
            if (string == null) {
                throw new RuntimeException("Cannot have a null operator name");
            }
            this.operatorName = string;
        }

        public String getOperatorName() {
            return this.operatorName;
        }

        abstract void eval();

        public boolean equals(Object object) {
            if (object instanceof Operation) {
                return ((Operation)object).operatorName.equals(this.operatorName);
            }
            if (object instanceof String) {
                return this.operatorName.equals(object);
            }
            return false;
        }
    }

    class Expression
    extends LinkedList {
        Expression() {
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Expression;
        }
    }
}

