/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.pattern;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPaint;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.pattern.PatternType1;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Map;

public abstract class PDFPattern {
    private int type;
    private AffineTransform xform;

    protected PDFPattern(int n) {
        this.type = n;
    }

    public static PDFPattern getPattern(PDFObject pDFObject, Map map) throws IOException {
        PDFPattern pDFPattern = (PDFPattern)pDFObject.getCache();
        if (pDFPattern != null) {
            return pDFPattern;
        }
        int n = pDFObject.getDictRef("PatternType").getIntValue();
        PDFObject pDFObject2 = pDFObject.getDictRef("Matrix");
        AffineTransform affineTransform = null;
        if (pDFObject2 == null) {
            affineTransform = new AffineTransform();
        } else {
            float[] fArray = new float[6];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = pDFObject2.getAt(i).getFloatValue();
            }
            affineTransform = new AffineTransform(fArray);
        }
        switch (n) {
            case 1: {
                pDFPattern = new PatternType1();
                break;
            }
            default: {
                throw new PDFParseException("Unknown pattern type " + n);
            }
        }
        pDFPattern.setTransform(affineTransform);
        pDFPattern.parse(pDFObject, map);
        pDFObject.setCache(pDFPattern);
        return pDFPattern;
    }

    public int getPatternType() {
        return this.type;
    }

    public AffineTransform getTransform() {
        return this.xform;
    }

    protected void setTransform(AffineTransform affineTransform) {
        this.xform = affineTransform;
    }

    protected abstract void parse(PDFObject var1, Map var2) throws IOException;

    public abstract PDFPaint getPaint(PDFPaint var1);
}

