/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.render.DynamicVectorRenderer;

public class Overlays {
    private final Map overlayType = new HashMap();
    private final Map overlayColors = new HashMap();
    private final Map overlayObj = new HashMap();
    private final Map overlayTypeG = new HashMap();
    private final Map overlayColorsG = new HashMap();
    private final Map overlayObjG = new HashMap();

    public void printAdditionalObjectsOverPage(int page, int[] type, Color[] colors, Object[] obj) throws PdfException {
        Integer key = page;
        if (obj == null) {
            this.overlayType.remove(key);
            this.overlayColors.remove(key);
            this.overlayObj.remove(key);
        } else {
            int[] oldType = (int[])this.overlayType.get(key);
            if (oldType == null) {
                this.overlayType.put(key, type);
            } else {
                int oldLength = oldType.length;
                int newLength = type.length;
                int[] combined = new int[oldLength + newLength];
                System.arraycopy(oldType, 0, combined, 0, oldLength);
                System.arraycopy(type, 0, combined, oldLength, newLength);
                this.overlayType.put(key, combined);
            }
            Color[] oldCol = (Color[])this.overlayColors.get(key);
            if (oldCol == null) {
                this.overlayColors.put(key, colors);
            } else {
                int oldLength = oldCol.length;
                int newLength = colors.length;
                Color[] combined = new Color[oldLength + newLength];
                System.arraycopy(oldCol, 0, combined, 0, oldLength);
                System.arraycopy(colors, 0, combined, oldLength, newLength);
                this.overlayColors.put(key, combined);
            }
            Object[] oldObj = (Object[])this.overlayObj.get(key);
            if (oldType == null) {
                this.overlayObj.put(key, obj);
            } else {
                int oldLength = oldObj.length;
                int newLength = obj.length;
                Object[] combined = new Object[oldLength + newLength];
                System.arraycopy(oldObj, 0, combined, 0, oldLength);
                System.arraycopy(obj, 0, combined, oldLength, newLength);
                this.overlayObj.put(key, combined);
            }
        }
    }

    public void printAdditionalObjectsOverAllPages(int[] type, Color[] colors, Object[] obj) throws PdfException {
        Integer key = -1;
        if (obj == null) {
            this.overlayTypeG.remove(key);
            this.overlayColorsG.remove(key);
            this.overlayObjG.remove(key);
        } else {
            int[] oldType = (int[])this.overlayTypeG.get(key);
            if (oldType == null) {
                this.overlayTypeG.put(key, type);
            } else {
                int oldLength = oldType.length;
                int newLength = type.length;
                int[] combined = new int[oldLength + newLength];
                System.arraycopy(oldType, 0, combined, 0, oldLength);
                System.arraycopy(type, 0, combined, oldLength, newLength);
                this.overlayTypeG.put(key, combined);
            }
            Color[] oldCol = (Color[])this.overlayColorsG.get(key);
            if (oldCol == null) {
                this.overlayColorsG.put(key, colors);
            } else {
                int oldLength = oldCol.length;
                int newLength = colors.length;
                Color[] combined = new Color[oldLength + newLength];
                System.arraycopy(oldCol, 0, combined, 0, oldLength);
                System.arraycopy(colors, 0, combined, oldLength, newLength);
                this.overlayColorsG.put(key, combined);
            }
            Object[] oldObj = (Object[])this.overlayObjG.get(key);
            if (oldType == null) {
                this.overlayObjG.put(key, obj);
            } else {
                int oldLength = oldObj.length;
                int newLength = obj.length;
                Object[] combined = new Object[oldLength + newLength];
                System.arraycopy(oldObj, 0, combined, 0, oldLength);
                System.arraycopy(obj, 0, combined, oldLength, newLength);
                this.overlayObjG.put(key, combined);
            }
        }
    }

    public void clear() {
        this.overlayType.clear();
        this.overlayColors.clear();
        this.overlayObj.clear();
        this.overlayTypeG.clear();
        this.overlayColorsG.clear();
        this.overlayObjG.clear();
    }

    public void printOverlays(DynamicVectorRenderer dvr, int page) throws PdfException {
        Integer keyG = -1;
        int[] typeG = (int[])this.overlayTypeG.get(keyG);
        Color[] colorsG = (Color[])this.overlayColorsG.get(keyG);
        Object[] objG = (Object[])this.overlayObjG.get(keyG);
        dvr.drawAdditionalObjectsOverPage(typeG, colorsG, objG);
        Integer key = page;
        int[] type = (int[])this.overlayType.get(key);
        Color[] colors = (Color[])this.overlayColors.get(key);
        Object[] obj = (Object[])this.overlayObj.get(key);
        dvr.drawAdditionalObjectsOverPage(type, colors, obj);
    }
}

