/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorMapping;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class SeparationColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = 8546233863470224093L;
    protected GenericColorSpace altCS;
    static final int Black = 1009857357;
    static final int PANTONE_BLACK = 573970506;
    private static final int Cyan = 323563838;
    private static final int Magenta = 895186280;
    public static final int Yellow = 1010591868;
    protected ColorMapping colorMapper;
    protected Map cachedValues = new HashMap();
    private float[] domain;
    protected int cmykMapping = -1;
    protected boolean isProcess = false;
    protected static final int NOCMYK = -1;
    protected static final int MYK = 1;
    protected static final int CMY = 2;
    protected static final int CMK = 4;
    protected static final int CY = 5;
    protected static final int MY = 6;
    protected static final int CM = 8;
    protected static final int CMYK = 7;
    protected static final int CMYB = 9;

    public SeparationColorSpace() {
    }

    public SeparationColorSpace(PdfObjectReader currentPdfFile, PdfObject colorSpace) {
        this.value = -2073385820;
        this.processColorToken(currentPdfFile, colorSpace);
    }

    protected void processColorToken(PdfObjectReader currentPdfFile, PdfObject colorSpace) {
        PdfObject indexed = colorSpace.getDictionary(895578984);
        PdfObject functionObj = colorSpace.getDictionary(-1313946392);
        this.domain = null;
        if (colorSpace.getDictionary(861242754) != null) {
            this.isProcess = true;
        }
        byte[] name = null;
        Object components = null;
        if (this.value == -2073385820) {
            name = colorSpace.getStringValueAsByte(506543413);
            if (name != null) {
                components = new byte[][]{name};
            }
            this.componentCount = 1;
        } else {
            components = colorSpace.getStringArray(1920898752);
            this.componentCount = ((byte[][])components).length;
        }
        this.cmykMapping = -1;
        int[] values = new int[this.componentCount];
        if (components != null) {
            for (int ii = 0; ii < this.componentCount; ++ii) {
                values[ii] = PdfDictionary.generateChecksum(1, components[ii].length - 1, components[ii]);
            }
        }
        switch (this.componentCount) {
            case 1: {
                if (components == null || values[0] != 1009857357 && values[0] != 573970506) break;
                this.cmykMapping = 1009857357;
                break;
            }
            case 2: {
                if (values[0] == 323563838) {
                    if (values[1] == 1010591868) {
                        this.cmykMapping = 5;
                        break;
                    }
                    if (values[1] != 895186280) break;
                    this.cmykMapping = 8;
                    break;
                }
                if (values[0] != 895186280 || values[1] != 1010591868) break;
                this.cmykMapping = 6;
                break;
            }
            case 3: {
                if (values[0] == 895186280 && values[1] == 1010591868 && values[2] == 1009857357) {
                    this.cmykMapping = 1;
                    break;
                }
                if (values[0] == 323563838 && values[1] == 895186280 && values[2] == 1010591868) {
                    this.cmykMapping = 2;
                    break;
                }
                if (values[0] != 323563838 || values[1] != 895186280 || values[2] != 1009857357) break;
                this.cmykMapping = 4;
                break;
            }
            case 4: {
                if (values[0] != 323563838 || values[1] != 895186280 || values[2] != 1010591868 || values[3] != 1009857357) break;
                this.cmykMapping = 9;
                break;
            }
            case 5: {
                if (values[0] != 323563838 || values[1] != 895186280 || values[2] != 1010591868 || values[3] != 1009857357) break;
                this.cmykMapping = 7;
                break;
            }
            case 6: {
                if (values[0] != 323563838 || values[1] != 895186280 || values[2] != 1010591868 || values[3] != 1009857357) break;
                this.cmykMapping = 7;
            }
        }
        if (this.cmykMapping != -1) {
            this.altCS = new DeviceCMYKColorSpace();
        } else {
            colorSpace = colorSpace.getDictionary(-1247101998);
            this.altCS = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, colorSpace);
            if (this.altCS.getID() == 1247168582 && colorSpace.getParameterConstant(2054519176) == 1498837125) {
                this.altCS = new DeviceCMYKColorSpace();
            }
        }
        if (name != null) {
            int len = name.length;
            int jj = 0;
            byte[] tempName = new byte[len];
            for (int i = 0; i < len; ++i) {
                if (name[i] == 35) {
                    int topHex;
                    if ((topHex = name[++i]) >= 65 && topHex <= 70) {
                        topHex -= 55;
                    } else if (topHex >= 97 && topHex <= 102) {
                        topHex -= 87;
                    } else if (topHex >= 48 && topHex <= 57) {
                        topHex -= 48;
                    }
                    ++i;
                    while (name[i] == 32 || name[i] == 10 || name[i] == 13) {
                        ++i;
                    }
                    int bottomHex = name[i];
                    if (bottomHex >= 65 && bottomHex <= 70) {
                        bottomHex -= 55;
                    } else if (bottomHex >= 97 && bottomHex <= 102) {
                        bottomHex -= 87;
                    } else if (bottomHex >= 48 && bottomHex <= 57) {
                        bottomHex -= 48;
                    }
                    tempName[jj] = (byte)(bottomHex + (topHex << 4));
                } else {
                    tempName[jj] = name[i];
                }
                ++jj;
            }
            if (jj != len) {
                name = new byte[jj];
                System.arraycopy(tempName, 0, name, 0, jj);
            }
            this.pantoneName = new String(name);
        }
        if (functionObj == null) {
            colorSpace.getDictionary(-1313946392);
        }
        if (functionObj == null && indexed != null) {
            functionObj = indexed.getDictionary(-1313946392);
        }
        this.colorMapper = new ColorMapping(currentPdfFile, functionObj);
        this.domain = functionObj.getFloatArray(1026641277);
    }

    private void setColor(float value) {
        try {
            if (this.cmykMapping == 1009857357) {
                float[] newOp = new float[]{0.0f, 0.0f, 0.0f, value};
                this.altCS.setColor(newOp, 1);
            } else {
                int elements = 1;
                if (this.domain != null) {
                    elements = this.domain.length / 2;
                }
                float[] values = new float[elements];
                for (int j = 0; j < elements; ++j) {
                    values[j] = value;
                }
                float[] operand = this.colorMapper.getOperandFloat(values);
                this.altCS.setColor(operand, operand.length);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setColor(float[] operand, int opCount) {
        this.setColor(operand[0]);
    }

    @Override
    public void setColor(String[] operand, int opCount) {
        float[] f = new float[]{Float.parseFloat(operand[0])};
        this.setColor(f, 1);
    }

    @Override
    public BufferedImage JPEGToRGBImage(byte[] data, int ww, int hh, float[] decodeArray, int pX, int pY, boolean arrayInverted, PdfObject XObject2) {
        BufferedImage image;
        block9: {
            ImageInputStream iin;
            ImageReader iir;
            ByteArrayInputStream in;
            block8: {
                in = null;
                iir = null;
                iin = null;
                try {
                    ImageReader o;
                    in = new ByteArrayInputStream(data);
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
                    while (iterator.hasNext() && !(iir = (o = iterator.next())).canReadRaster()) {
                    }
                    ImageIO.setUseCache(false);
                    iin = ImageIO.createImageInputStream(in);
                    iir.setInput(iin, true);
                    Raster ras = iir.readRaster(0, null);
                    ras = SeparationColorSpace.cleanupRaster(ras, pX, pY, 1);
                    int w = ras.getWidth();
                    int h = ras.getHeight();
                    DataBufferByte rgb = (DataBufferByte)ras.getDataBuffer();
                    byte[] rawData = rgb.getData();
                    if (this.altCS.getID() == 1568372915) {
                        for (int aa = 0; aa < rawData.length; ++aa) {
                            rawData[aa] = (byte)(rawData[aa] ^ 0xFF);
                        }
                        int[] bands = new int[]{0};
                        image = new BufferedImage(w, h, 10);
                        WritableRaster raster = Raster.createInterleavedRaster(new DataBufferByte(rawData, rawData.length), w, h, w, 1, bands, null);
                        image.setData(raster);
                    } else {
                        image = this.createImage(w, h, rawData, arrayInverted);
                    }
                }
                catch (Exception ee) {
                    image = null;
                    if (!LogWriter.isOutput()) break block8;
                    LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
                }
            }
            try {
                in.close();
                iir.dispose();
                iin.close();
            }
            catch (Exception ee) {
                if (!LogWriter.isOutput()) break block9;
                LogWriter.writeLog("Problem closing  " + ee);
            }
        }
        return image;
    }

    @Override
    public BufferedImage JPEG2000ToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY) throws PdfException {
        BufferedImage image;
        block13: {
            ImageReader iir;
            ByteArrayInputStream in;
            block12: {
                try {
                    in = new ByteArrayInputStream(data);
                    iir = ImageIO.getImageReadersByFormatName("JPEG2000").next();
                }
                catch (Exception ee) {
                    Object image2 = null;
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Problem reading JPEG 2000: " + ee);
                    }
                    String message = "Exception " + ee + " with JPeg 2000 Image from iir = (ImageReader)ImageIO.getImageReadersByFormatName(\"JPEG2000\").next();";
                    if (!JAIHelper.isJAIused()) {
                        message = "JPeg 2000 Images and JAI not setup.\nYou need both JAI and imageio.jar on classpath, and the VM parameter -Dorg.jpedal.jai=true switch turned on";
                    }
                    throw new PdfException(message);
                }
                if (iir == null) {
                    return null;
                }
                try {
                    ImageInputStream iin = ImageIO.createImageInputStream(in);
                    try {
                        iir.setInput(iin, true);
                        image = iir.read(0);
                        iir.dispose();
                        iin.close();
                        in.close();
                    }
                    catch (Exception e) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("Problem reading JPEG 2000: " + e);
                        }
                        e.printStackTrace();
                        return null;
                    }
                    image = SeparationColorSpace.cleanupImage(image, pX, pY, this.value);
                    w = image.getWidth();
                    h = image.getHeight();
                    DataBufferByte rgb = (DataBufferByte)image.getRaster().getDataBuffer();
                    byte[] rawData = rgb.getData();
                    image = this.createImage(w, h, rawData, false);
                }
                catch (Exception ee) {
                    image = null;
                    if (!LogWriter.isOutput()) break block12;
                    LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
                }
            }
            try {
                in.close();
                iir.dispose();
            }
            catch (Exception ee) {
                if (!LogWriter.isOutput()) break block13;
                LogWriter.writeLog("Problem closing  " + ee);
            }
        }
        return image;
    }

    @Override
    public BufferedImage dataToRGB(byte[] data, int w, int h) {
        BufferedImage image;
        block2: {
            try {
                image = this.createImage(w, h, data, false);
            }
            catch (Exception ee) {
                image = null;
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Couldn't convert Separation colorspace data: " + ee);
            }
        }
        return image;
    }

    private BufferedImage createImage(int w, int h, byte[] rgb, boolean arrayInverted) {
        int pixelCount = 3 * w * h;
        byte[] imageData = new byte[pixelCount];
        int pixelReached = 0;
        float[][] lookuptable = new float[3][256];
        for (int i = 0; i < 256; ++i) {
            lookuptable[0][i] = -1.0f;
        }
        for (byte aRgb : rgb) {
            int value = aRgb & 0xFF;
            if (lookuptable[0][value] == -1.0f) {
                if (arrayInverted) {
                    this.setColor(1.0f - (float)value / 255.0f);
                } else {
                    this.setColor((float)value / 255.0f);
                }
                lookuptable[0][value] = ((Color)((Object)this.getColor())).getRed();
                lookuptable[1][value] = ((Color)((Object)this.getColor())).getGreen();
                lookuptable[2][value] = ((Color)((Object)this.getColor())).getBlue();
            }
            for (int comp = 0; comp < 3; ++comp) {
                imageData[pixelReached] = (byte)lookuptable[comp][value];
                ++pixelReached;
            }
        }
        BufferedImage image = new BufferedImage(w, h, 1);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(imageData, w, h);
        image.setData(raster);
        return image;
    }

    @Override
    public byte[] convertIndexToRGB(byte[] data) {
        byte[] newdata;
        block6: {
            this.isConverted = true;
            newdata = new byte[768];
            try {
                int outputReached = 0;
                int byteCount = data.length;
                float[] values = new float[this.componentCount];
                for (int i = 0; i < byteCount; i += this.componentCount) {
                    Color currentCol;
                    if (this.componentCount == 1 && this.value == -2073385820 && this.colorMapper == null) {
                        float[] opValues = new float[1];
                        opValues[1] = data[i] & 0xFF;
                        this.setColor(opValues, 1);
                        currentCol = (Color)((Object)this.getColor());
                    } else {
                        for (int j = 0; j < this.componentCount; ++j) {
                            values[j] = (float)(data[i + j] & 0xFF) / 255.0f;
                        }
                        float[] operand = this.colorMapper.getOperandFloat(values);
                        this.altCS.setColor(operand, operand.length);
                        currentCol = (Color)((Object)this.altCS.getColor());
                    }
                    newdata[outputReached] = (byte)currentCol.getRed();
                    newdata[++outputReached] = (byte)currentCol.getGreen();
                    newdata[++outputReached] = (byte)currentCol.getBlue();
                    ++outputReached;
                }
            }
            catch (Exception ee) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception  " + ee + " converting colorspace");
            }
        }
        return newdata;
    }

    @Override
    public PdfPaint getColor() {
        return this.altCS.getColor();
    }

    @Override
    public final Object clone() {
        Object o;
        this.setColorStatus();
        try {
            o = super.clone();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to clone object");
        }
        return o;
    }

    private void setColorStatus() {
        int foreground = this.altCS.currentColor.getRGB();
        this.r = foreground >> 16 & 0xFF;
        this.g = foreground >> 8 & 0xFF;
        this.b = foreground & 0xFF;
    }

    @Override
    public void restoreColorStatus() {
        this.altCS.currentColor = new PdfColor(this.r, this.g, this.b);
        this.altCS.clearCache();
    }

    public GenericColorSpace getAltColorSpace() {
        return this.altCS;
    }
}

