/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import org.jpedal.fonts.tt.conversion.FontWriter;

public class CFFFixer {
    private byte[] data;
    private byte[] original;
    private int charstringOffset = -1;
    private int privateOffset = -1;
    private int privateOffsetLocation = -1;
    private int privateOffsetLength = -1;
    private int fdArrayOffset = -1;
    private int fdArrayOffsetLocation = -1;
    private int fdArrayOffsetLength = -1;

    public CFFFixer(byte[] cff) {
        this.data = cff;
        this.original = new byte[cff.length];
        System.arraycopy(cff, 0, this.original, 0, cff.length);
        if (this.scanForDotsection()) {
            this.fixData();
        }
    }

    private boolean scanForDotsection() {
        boolean result = false;
        for (int i = 0; i < this.data.length - 1; ++i) {
            if (this.data[i] != 12 || this.data[i + 1] != 0) continue;
            result = true;
        }
        return result;
    }

    private void fixData() {
        try {
            int i;
            byte nameIndexStart = this.data[2];
            int nameIndexCount = FontWriter.getUintFromByteArray(this.data, nameIndexStart, 2);
            byte nameIndexOffsize = this.data[nameIndexStart + 2];
            int nameIndexEndOffsetLocation = nameIndexStart + 3 + nameIndexOffsize * nameIndexCount;
            int nameIndexEndOffset = FontWriter.getUintFromByteArray(this.data, nameIndexEndOffsetLocation, nameIndexOffsize);
            int dictIndexStart = nameIndexEndOffsetLocation + nameIndexEndOffset + (nameIndexOffsize - 1);
            int topDictIndexCount = FontWriter.getUintFromByteArray(this.data, dictIndexStart, 2);
            if (topDictIndexCount != 1) {
                this.data = this.original;
                return;
            }
            byte topDictIndexOffsize = this.data[dictIndexStart + 2];
            int topDictIndexEndOffsetLocation = dictIndexStart + 3 + topDictIndexOffsize * topDictIndexCount;
            int topDictIndexEndOffset = FontWriter.getUintFromByteArray(this.data, topDictIndexEndOffsetLocation, topDictIndexOffsize);
            int topDictDataStart = topDictIndexEndOffsetLocation + topDictIndexOffsize;
            byte[] topDict = new byte[topDictIndexEndOffset - 1];
            System.arraycopy(this.data, topDictDataStart, topDict, 0, topDictIndexEndOffset - 1);
            this.decodeTopDict(topDict);
            if (this.charstringOffset == -1) {
                this.data = this.original;
                return;
            }
            int charstringsCount = FontWriter.getUintFromByteArray(this.data, this.charstringOffset, 2);
            byte charstringsOffsize = this.data[this.charstringOffset + 2];
            int charstringsOffsetsStart = this.charstringOffset + 3;
            int[] charstringOffsets = new int[charstringsCount + 1];
            for (int i2 = 0; i2 < charstringsCount + 1; ++i2) {
                charstringOffsets[i2] = FontWriter.getUintFromByteArray(this.data, charstringsOffsetsStart + charstringsOffsize * i2, charstringsOffsize);
            }
            int charstringDataStart = charstringsOffsetsStart + (charstringsCount + 1) * charstringsOffsize;
            int bytesRemoved = 0;
            for (i = 0; i < charstringsCount; ++i) {
                int lastNumLength;
                int lastOpLength;
                int start = charstringDataStart + charstringOffsets[i] - 1;
                int end = charstringDataStart + charstringOffsets[i + 1] - 1;
                int[] c = new int[end - start];
                for (int j = 0; j < c.length; ++j) {
                    c[j] = this.data[start + j];
                    if (c[j] >= 0) continue;
                    int n = j;
                    c[n] = c[n] + 256;
                }
                for (int pointer = 0; pointer < c.length; pointer += lastOpLength + lastNumLength) {
                    int chunk = c[pointer];
                    if (chunk >= 32 && chunk <= 246) {
                        lastNumLength = 1;
                        lastOpLength = 0;
                        continue;
                    }
                    if (chunk >= 247 && chunk <= 254) {
                        lastNumLength = 2;
                        lastOpLength = 0;
                        continue;
                    }
                    if (chunk == 255) {
                        lastNumLength = 5;
                        lastOpLength = 0;
                        continue;
                    }
                    if (chunk == 28) {
                        lastNumLength = 3;
                        lastOpLength = 0;
                        continue;
                    }
                    if (chunk == 12) {
                        if (c[pointer + 1] == 0) {
                            System.arraycopy(this.data, start + pointer + 2, this.data, start + pointer, this.data.length - (start + pointer + 2));
                            System.arraycopy(c, pointer + 2, c, pointer, c.length - (pointer + 2));
                            int j = i + 1;
                            while (j < charstringOffsets.length) {
                                int n = j++;
                                charstringOffsets[n] = charstringOffsets[n] - 2;
                            }
                            bytesRemoved += 2;
                            lastOpLength = 0;
                        } else {
                            lastOpLength = 2;
                        }
                        lastNumLength = 0;
                        continue;
                    }
                    lastOpLength = 1;
                    lastNumLength = 0;
                }
            }
            if (bytesRemoved == 0) {
                this.data = this.original;
                return;
            }
            for (i = 0; i < charstringOffsets.length; ++i) {
                byte[] newNumber = FontWriter.setUintAsBytes(charstringOffsets[i], charstringsOffsize);
                System.arraycopy(newNumber, 0, this.data, charstringsOffsetsStart + i * charstringsOffsize, charstringsOffsize);
            }
            if (this.fdArrayOffset != -1 && this.fdArrayOffsetLength != -1 && this.fdArrayOffsetLocation != -1) {
                byte[] newFdArrayOffset = FontWriter.set1cNumber(this.fdArrayOffset - bytesRemoved);
                newFdArrayOffset = CFFFixer.pad1cNumber(this.fdArrayOffsetLength, newFdArrayOffset, this.fdArrayOffset - bytesRemoved);
                System.arraycopy(newFdArrayOffset, 0, this.data, topDictDataStart + this.fdArrayOffsetLocation, this.fdArrayOffsetLength);
            }
            if (this.privateOffset != -1 && this.privateOffsetLength != -1 && this.privateOffsetLocation != -1) {
                byte[] newPrivateOffset = FontWriter.set1cNumber(this.privateOffset - bytesRemoved);
                newPrivateOffset = CFFFixer.pad1cNumber(this.privateOffsetLength, newPrivateOffset, this.privateOffset - bytesRemoved);
                System.arraycopy(newPrivateOffset, 0, this.data, topDictDataStart + this.privateOffsetLocation, this.privateOffsetLength);
            }
            byte[] oldData = this.data;
            this.data = new byte[this.data.length - bytesRemoved];
            System.arraycopy(oldData, 0, this.data, 0, this.data.length);
        }
        catch (Exception e) {
            this.data = this.original;
        }
    }

    private void decodeTopDict(byte[] dict) {
        int lastOpLength;
        int[] d = new int[dict.length];
        for (int i = 0; i < dict.length; ++i) {
            d[i] = dict[i] < 0 ? dict[i] + 256 : dict[i];
        }
        int lastNumLength = 0;
        int lastNum = 0;
        for (int pointer = 0; pointer < d.length; pointer += lastOpLength + lastNumLength) {
            int chunk = d[pointer];
            if (chunk >= 32 && chunk <= 246) {
                lastNum = chunk - 139;
                lastNumLength = 1;
                lastOpLength = 0;
                continue;
            }
            if (chunk >= 247 && chunk <= 250) {
                lastNum = (chunk - 247) * 256 + d[pointer + 1] + 108;
                lastNumLength = 2;
                lastOpLength = 0;
                continue;
            }
            if (chunk >= 251 && chunk <= 254) {
                lastNum = -((chunk - 251) * 256) - d[pointer + 1] - 108;
                lastNumLength = 2;
                lastOpLength = 0;
                continue;
            }
            if (chunk == 28) {
                lastNum = FontWriter.getUintFromIntArray(d, pointer + 1, 2);
                lastNumLength = 3;
                lastOpLength = 0;
                continue;
            }
            if (chunk == 29) {
                lastNum = FontWriter.getUintFromIntArray(d, pointer + 1, 4);
                lastNumLength = 5;
                lastOpLength = 0;
                continue;
            }
            if (chunk == 30) {
                lastNumLength = 1;
                while ((d[pointer + lastNumLength] & 0xF) != 15 && (d[pointer + lastNumLength] & 0xF) != 15) {
                    ++lastNumLength;
                }
                ++lastNumLength;
                lastOpLength = 0;
                continue;
            }
            if (chunk == 12) {
                if (d[pointer + 1] == 36) {
                    this.fdArrayOffsetLocation = pointer - lastNumLength;
                    this.fdArrayOffsetLength = lastNumLength;
                    this.fdArrayOffset = lastNum;
                }
                lastOpLength = 2;
                lastNumLength = 0;
                continue;
            }
            if (chunk == 17) {
                this.charstringOffset = lastNum;
                lastOpLength = 1;
                lastNumLength = 0;
                continue;
            }
            if (chunk == 18) {
                this.privateOffsetLocation = pointer - lastNumLength;
                this.privateOffsetLength = lastNumLength;
                this.privateOffset = lastNum;
                lastOpLength = 1;
                lastNumLength = 0;
                continue;
            }
            lastOpLength = 1;
            lastNumLength = 0;
        }
    }

    private static byte[] pad1cNumber(int byteCount, byte[] currentRepresentation, int number) {
        if (byteCount == currentRepresentation.length) {
            return currentRepresentation;
        }
        if (byteCount < currentRepresentation.length) {
            throw new IllegalArgumentException("Trying to pad a number to a smaller size.");
        }
        if (byteCount != 2 && byteCount != 3 && byteCount != 5) {
            throw new IllegalArgumentException("Padding to an incorect number of bytes.");
        }
        byte[] result = byteCount == 2 ? new byte[]{-117, currentRepresentation[0]} : (byteCount == 3 ? new byte[]{28, (byte)(number >> 8 & 0xFF), (byte)(number & 0xFF)} : new byte[]{29, (byte)(number >> 24 & 0xFF), (byte)(number >> 16 & 0xFF), (byte)(number >> 8 & 0xFF), (byte)(number & 0xFF)});
        return result;
    }

    public byte[] getBytes() {
        return this.data;
    }
}

