/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.javafx;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jpedal.color.PdfPaint;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.render.ShapeFactory;
import org.jpedal.render.output.OutputDisplay;
import org.jpedal.render.output.OutputShape;

public class FXMLShape
extends OutputShape
implements ShapeFactory {
    private GraphicsState gs;
    private int windingRule = 1;

    public FXMLShape(int cmd, int shapeCount, float scaling, Shape currentShape, GraphicsState gs, AffineTransform scalingTransform, Point2D midPoint, Rectangle cropBox, int currentColor, int dpCount, int pageRotation, PdfPageData pageData, int pageNumber, boolean includeClip) {
        super(cmd, scaling, currentShape, gs, scalingTransform, midPoint, cropBox, currentColor, dpCount, pageRotation, pageData, pageNumber, includeClip);
        this.shapeCount = shapeCount;
        this.gs = gs;
        this.windingRule = currentShape.getPathIterator(scalingTransform).getWindingRule();
        this.generateShapeFromG2Data(gs, scalingTransform, cropBox);
    }

    @Override
    public void checkShapeClosed() {
        if (this.shapeIsOpen) {
            this.shapeIsOpen = false;
            this.finishShape();
        }
    }

    @Override
    protected void beginShape() {
        String strokeWidth = "";
        String strokeLineCap = "";
        String strokeLineJoin = "";
        String strokeColor = "";
        String strokeMiterLimit = "";
        String fillColor = "";
        String fillRule = "";
        String opacity = "";
        int fillType = this.gs.getFillType();
        if (fillType == 2 || fillType == 3) {
            float fillOpacity;
            PdfPaint col = this.gs.getNonstrokeColor();
            if (this.windingRule == 0) {
                fillRule = " fillRule=\"even_odd\"";
            }
            if ((fillOpacity = this.gs.getAlpha(2)) != 1.0f) {
                opacity = " opacity=\"" + fillOpacity + "\"";
            }
            String hexColor = OutputDisplay.hexColor(col.getRGB());
            strokeColor = " stroke=\"TRANSPARENT\"";
            fillColor = " fill=\"" + hexColor + '\"';
            this.currentColor = col.getRGB();
        }
        if (fillType == 1 || fillType == 3) {
            BasicStroke stroke = (BasicStroke)this.gs.getStroke();
            float strokeOpacity = this.gs.getAlpha(1);
            if (strokeOpacity != 1.0f) {
                opacity = " opacity=\"" + strokeOpacity + "\"";
            }
            if (this.gs.getOutputLineWidth() != 1) {
                strokeWidth = " strokeWidth=\"" + this.gs.getOutputLineWidth() + '\"';
            }
            if (stroke.getMiterLimit() != 10.0f) {
                strokeMiterLimit = " strokeMiterLimit=\"" + this.gs.getOutputLineWidth() + '\"';
            }
            strokeLineCap = " strokeLineCap=\"" + FXMLShape.determineLineCap(stroke) + '\"';
            strokeLineJoin = " strokeLineJoin=\"" + FXMLShape.determineLineJoin(stroke) + '\"';
            PdfPaint col = this.gs.getStrokeColor();
            String hexColor = OutputDisplay.hexColor(col.getRGB());
            strokeColor = " stroke=\"" + hexColor + '\"';
        }
        this.pathCommands.add("\t");
        this.pathCommands.add("<Path id=\"path" + this.shapeCount + '\"' + fillRule + strokeColor + fillColor + strokeWidth + strokeLineCap + strokeLineJoin + strokeMiterLimit + opacity + '>');
        this.pathCommands.add("\t<elements>");
    }

    @Override
    protected void finishShape() {
        this.pathCommands.add("\t</elements>");
        this.pathCommands.add("</Path>");
    }

    @Override
    protected void lineTo(double[] coords) {
        String coordinates = this.coordsToStringParam(coords, 2);
        String delimiter = ",";
        String[] temp = coordinates.split(delimiter);
        this.pathCommands.add("\t\t<LineTo x=\"" + temp[0] + "\" y=\"" + temp[1] + "\"/>");
    }

    @Override
    protected void bezierCurveTo(double[] coords) {
        String coordinates = this.coordsToStringParam(coords, 6);
        String delimiter = ",";
        String[] temp = coordinates.split(delimiter);
        this.pathCommands.add("\t\t<CubicCurveTo controlX1=\"" + temp[0] + "\" controlY1=\"" + temp[1] + "\" controlX2=\"" + temp[2] + "\" controlY2=\"" + temp[3] + "\" x=\"" + temp[4] + "\" y=\"" + temp[5] + "\" />");
    }

    @Override
    protected void quadraticCurveTo(double[] coords) {
        String coordinates = this.coordsToStringParam(coords, 4);
        String delimiter = ",";
        String[] temp = coordinates.split(delimiter);
        this.pathCommands.add("\t\t<QuadCurveTo controlX=\"" + temp[0] + "\" controlY=\"" + temp[1] + "\" x=\"" + temp[2] + "\" y=\"" + temp[3] + "\" />");
    }

    @Override
    protected void moveTo(double[] coords) {
        String coordinates = this.coordsToStringParam(coords, 2);
        String delimiter = ",";
        String[] temp = coordinates.split(delimiter);
        this.pathCommands.add("\t\t<MoveTo x=\"" + temp[0] + "\" y=\"" + temp[1] + "\"/>");
    }

    @Override
    protected void closePath() {
        this.pathCommands.add("\t\t<ClosePath />");
    }

    @Override
    protected void drawCropBox() {
        double[] coords = new double[]{this.cropBox.x, this.cropBox.y};
        this.pathCommands.add("\t\t<MoveTo x=\"" + coords[0] + "\" y=\"" + coords[1] + "\"/>");
        coords[0] = coords[0] + (double)this.cropBox.width;
        this.pathCommands.add("\t\t<LineTo x=\"" + coords[0] + "\" y=\"" + coords[1] + "\"/>");
        coords[1] = coords[1] + (double)this.cropBox.height;
        this.pathCommands.add("\t\t<LineTo x=\"" + coords[0] + "\" y=\"" + coords[1] + "\"/>");
        coords[0] = coords[0] - (double)this.cropBox.width;
        this.pathCommands.add("\t\t<LineTo x=\"" + coords[0] + "\" y=\"" + coords[1] + "\"/>");
    }

    @Override
    protected void applyGraphicsStateToPath(GraphicsState gs) {
    }

    protected static String determineLineCap(BasicStroke stroke) {
        String attribute;
        switch (stroke.getEndCap()) {
            case 1: {
                attribute = "ROUND";
                break;
            }
            case 2: {
                attribute = "SQUARE";
                break;
            }
            default: {
                attribute = "BUTT";
            }
        }
        return attribute;
    }

    protected static String determineLineJoin(BasicStroke stroke) {
        String attribute;
        switch (stroke.getLineJoin()) {
            case 1: {
                attribute = "ROUND";
                break;
            }
            case 2: {
                attribute = "BEVEL";
                break;
            }
            default: {
                attribute = "MITER";
            }
        }
        return attribute;
    }

    @Override
    public void setShapeNumber(int shapeCount) {
        this.shapeCount = shapeCount;
    }
}

