/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.BufferedReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.jpedal.utils.LogWriter;

public class Messages {
    private static Map messages = null;
    private static Map reportedValueMissing = new HashMap();
    protected static ResourceBundle bundle = null;
    private static boolean isInitialised = false;

    public static void setBundle(ResourceBundle newBundle) {
        bundle = newBundle;
        if (!isInitialised) {
            Messages.init();
        }
    }

    public static ResourceBundle getBundle() {
        return bundle;
    }

    public static String getMessage(String key) {
        String message;
        block9: {
            block8: {
                message = null;
                try {
                    message = (String)messages.get(key);
                    if (message == null) {
                        message = bundle.getString(key);
                    }
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block8;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            if (message == null) {
                try {
                    message = (String)messages.get(key);
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block9;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        if (message == null) {
            message = key;
        }
        if (message.length() == 0) {
            message = key + "<<";
        }
        return message;
    }

    private static void init() {
        isInitialised = true;
        BufferedReader input_stream = null;
        try {
            String element;
            String line;
            messages = new HashMap();
            if (input_stream == null) {
                LogWriter.writeLog("Unable to open messages.properties from jar");
            }
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements() && (line = (String)bundle.getObject(element = keys.nextElement())) != null) {
                StringBuilder newMessage = new StringBuilder();
                StringTokenizer t = new StringTokenizer(line, "\\&;", true);
                boolean isAmpersand = false;
                while (t.hasMoreTokens()) {
                    String ascii;
                    String nextValue;
                    if (isAmpersand) {
                        nextValue = "&";
                        isAmpersand = false;
                    } else {
                        nextValue = t.nextToken();
                    }
                    if (t.hasMoreTokens() && nextValue.equals("\\")) {
                        ascii = t.nextToken();
                        char c = ascii.charAt(0);
                        if (c == 'n') {
                            newMessage.append('\n');
                        } else if (c == ' ') {
                            newMessage.append(' ');
                        }
                        newMessage.append(ascii.substring(1));
                        continue;
                    }
                    if (t.hasMoreTokens() && nextValue.equals("&")) {
                        ascii = t.nextToken();
                        if (t.hasMoreTokens()) {
                            String end = t.nextToken();
                            if (end.equals("&")) {
                                newMessage.append('&');
                                newMessage.append(ascii);
                                isAmpersand = true;
                                continue;
                            }
                            if (end.equals(";")) {
                                if (ascii.startsWith("#")) {
                                    ascii = ascii.substring(1);
                                }
                                char c = (char)Integer.parseInt(ascii);
                                newMessage.append(c);
                                continue;
                            }
                            if (t.hasMoreTokens()) {
                                newMessage.append('&');
                            }
                            newMessage.append(ascii);
                            continue;
                        }
                        newMessage.append('&');
                        newMessage.append(ascii);
                        continue;
                    }
                    newMessage.append(nextValue);
                }
                messages.put(element, newMessage.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogWriter.writeLog("Exception " + e + " loading resource bundle.\nAlso check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
            System.err.println("Exception loading resource bundle.\nAlso check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
        }
        if (input_stream != null) {
            try {
                input_stream.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    public static void dispose() {
        messages = null;
        reportedValueMissing = null;
        bundle = null;
        isInitialised = false;
    }
}

