/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jsign.pkcs11;

import com.github.kwart.jsign.pkcs11.P11Key;
import com.github.kwart.jsign.pkcs11.P11SecretKeyFactory;
import com.github.kwart.jsign.pkcs11.P11Util;
import com.github.kwart.jsign.pkcs11.Session;
import com.github.kwart.jsign.pkcs11.Token;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import sun.nio.ch.DirectBuffer;
import sun.security.jca.JCAUtil;
import sun.security.pkcs11.wrapper.CK_AES_CTR_PARAMS;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11Cipher
extends CipherSpi {
    private static final int MODE_ECB = 3;
    private static final int MODE_CBC = 4;
    private static final int MODE_CTR = 5;
    private static final int PAD_NONE = 5;
    private static final int PAD_PKCS5 = 6;
    private final Token token;
    private final String algorithm;
    private final String keyAlgorithm;
    private final long mechanism;
    private Session session;
    private P11Key p11Key;
    private boolean initialized;
    private boolean encrypt;
    private int blockMode;
    private final int blockSize;
    private int paddingType;
    private Padding paddingObj;
    private byte[] padBuffer;
    private int padBufferLen;
    private byte[] iv;
    private int bytesBuffered;
    private int fixedKeySize = -1;
    private boolean reqBlockUpdates = false;

    P11Cipher(Token token, String algorithm, long mechanism) throws PKCS11Exception, NoSuchAlgorithmException {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
        String[] algoParts = algorithm.split("/");
        if (algoParts[0].startsWith("AES")) {
            this.blockSize = 16;
            int index = algoParts[0].indexOf(95);
            if (index != -1) {
                this.fixedKeySize = Integer.parseInt(algoParts[0].substring(index + 1)) / 8;
            }
            this.keyAlgorithm = "AES";
        } else {
            this.keyAlgorithm = algoParts[0];
            this.blockSize = this.keyAlgorithm.equals("RC4") || this.keyAlgorithm.equals("ARCFOUR") ? 0 : 8;
        }
        this.blockMode = algoParts.length > 1 ? this.parseMode(algoParts[1]) : 3;
        String defPadding = this.blockSize == 0 ? "NoPadding" : "PKCS5Padding";
        String paddingStr = algoParts.length > 2 ? algoParts[2] : defPadding;
        try {
            this.engineSetPadding(paddingStr);
        }
        catch (NoSuchPaddingException nspe) {
            throw new ProviderException(nspe);
        }
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Unsupported mode " + mode);
    }

    private int parseMode(String mode) throws NoSuchAlgorithmException {
        int result;
        if ((mode = mode.toUpperCase(Locale.ENGLISH)).equals("ECB")) {
            result = 3;
        } else if (mode.equals("CBC")) {
            if (this.blockSize == 0) {
                throw new NoSuchAlgorithmException("CBC mode not supported with stream ciphers");
            }
            result = 4;
        } else if (mode.equals("CTR")) {
            result = 5;
        } else {
            throw new NoSuchAlgorithmException("Unsupported mode " + mode);
        }
        return result;
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        this.paddingObj = null;
        this.padBuffer = null;
        if ((padding = padding.toUpperCase(Locale.ENGLISH)).equals("NOPADDING")) {
            this.paddingType = 5;
        } else if (padding.equals("PKCS5PADDING")) {
            if (this.blockMode == 5) {
                throw new NoSuchPaddingException("PKCS#5 padding not supported with CTR mode");
            }
            this.paddingType = 6;
            if (this.mechanism != 293L && this.mechanism != 310L && this.mechanism != 4229L) {
                this.paddingObj = new PKCS5Padding(this.blockSize);
                this.padBuffer = new byte[this.blockSize];
                char[] tokenLabel = this.token.tokenInfo.label;
                this.reqBlockUpdates = tokenLabel[0] == 'N' && tokenLabel[1] == 'S' && tokenLabel[2] == 'S';
            }
        } else {
            throw new NoSuchPaddingException("Unsupported padding " + padding);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.doFinalLength(inputLen);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.iv == null) {
            return null;
        }
        IvParameterSpec ivSpec = new IvParameterSpec(this.iv);
        try {
            AlgorithmParameters params = AlgorithmParameters.getInstance(this.keyAlgorithm, P11Util.getSunJceProvider());
            params.init(ivSpec);
            return params;
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException("Could not encode parameters", e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.implInit(opmode, key, null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("init() failed", e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] ivValue;
        if (params != null) {
            if (!(params instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Only IvParameterSpec supported");
            }
            IvParameterSpec ivSpec = (IvParameterSpec)params;
            ivValue = ivSpec.getIV();
        } else {
            ivValue = null;
        }
        this.implInit(opmode, key, ivValue, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] ivValue;
        if (params != null) {
            try {
                IvParameterSpec ivSpec = params.getParameterSpec(IvParameterSpec.class);
                ivValue = ivSpec.getIV();
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("Could not decode IV", e);
            }
        } else {
            ivValue = null;
        }
        this.implInit(opmode, key, ivValue, random);
    }

    private void implInit(int opmode, Key key, byte[] iv, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.reset(true);
        if (this.fixedKeySize != -1 && (key instanceof P11Key ? ((P11Key)key).length() >> 3 : key.getEncoded().length) != this.fixedKeySize) {
            throw new InvalidKeyException("Key size is invalid");
        }
        switch (opmode) {
            case 1: {
                this.encrypt = true;
                break;
            }
            case 2: {
                this.encrypt = false;
                break;
            }
            default: {
                throw new InvalidAlgorithmParameterException("Unsupported mode: " + opmode);
            }
        }
        if (this.blockMode == 3) {
            if (iv != null) {
                if (this.blockSize == 0) {
                    throw new InvalidAlgorithmParameterException("IV not used with stream ciphers");
                }
                throw new InvalidAlgorithmParameterException("IV not used in ECB mode");
            }
        } else if (iv == null) {
            if (!this.encrypt) {
                String exMsg = this.blockMode == 4 ? "IV must be specified for decryption in CBC mode" : "IV must be specified for decryption in CTR mode";
                throw new InvalidAlgorithmParameterException(exMsg);
            }
            if (random == null) {
                random = JCAUtil.getSecureRandom();
            }
            iv = new byte[this.blockSize];
            random.nextBytes(iv);
        } else if (iv.length != this.blockSize) {
            throw new InvalidAlgorithmParameterException("IV length must match block size");
        }
        this.iv = iv;
        this.p11Key = P11SecretKeyFactory.convertKey(this.token, key, this.keyAlgorithm);
        try {
            this.initialize();
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not initialize cipher", e);
        }
    }

    private void reset(boolean doCancel) {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        try {
            if (this.session == null) {
                return;
            }
            if (doCancel && this.token.explicitCancel) {
                this.cancelOperation();
            }
        }
        finally {
            this.p11Key.releaseKeyID();
            this.session = this.token.releaseSession(this.session);
            this.bytesBuffered = 0;
            this.padBufferLen = 0;
        }
    }

    private void cancelOperation() {
        block5: {
            this.token.ensureValid();
            try {
                int bufLen = this.doFinalLength(0);
                byte[] buffer = new byte[bufLen];
                if (this.encrypt) {
                    this.token.p11.C_EncryptFinal(this.session.id(), 0L, buffer, 0, bufLen);
                } else {
                    this.token.p11.C_DecryptFinal(this.session.id(), 0L, buffer, 0, bufLen);
                }
            }
            catch (PKCS11Exception e) {
                if (e.getErrorCode() == 145L) {
                    return;
                }
                if (!this.encrypt) break block5;
                throw new ProviderException("Cancel failed", e);
            }
        }
    }

    private void ensureInitialized() throws PKCS11Exception {
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.p11Key == null) {
            throw new ProviderException("Operation cannot be performed without calling engineInit first");
        }
        this.token.ensureValid();
        long p11KeyID = this.p11Key.getKeyID();
        try {
            CK_MECHANISM mechParams;
            if (this.session == null) {
                this.session = this.token.getOpSession();
            }
            CK_MECHANISM cK_MECHANISM = mechParams = this.blockMode == 5 ? new CK_MECHANISM(this.mechanism, new CK_AES_CTR_PARAMS(this.iv)) : new CK_MECHANISM(this.mechanism, this.iv);
            if (this.encrypt) {
                this.token.p11.C_EncryptInit(this.session.id(), mechParams, p11KeyID);
            } else {
                this.token.p11.C_DecryptInit(this.session.id(), mechParams, p11KeyID);
            }
        }
        catch (PKCS11Exception e) {
            this.p11Key.releaseKeyID();
            this.session = this.token.releaseSession(this.session);
            throw e;
        }
        this.initialized = true;
        this.bytesBuffered = 0;
        this.padBufferLen = 0;
    }

    private int updateLength(int inLen) {
        if (inLen <= 0) {
            return 0;
        }
        int result = inLen + this.bytesBuffered;
        if (this.blockSize != 0 && this.blockMode != 5) {
            result -= result & this.blockSize - 1;
        }
        return result;
    }

    private int doFinalLength(int inLen) {
        if (inLen < 0) {
            return 0;
        }
        int result = inLen + this.bytesBuffered;
        if (this.blockSize != 0 && this.encrypt && this.paddingType != 5) {
            result += this.blockSize - (result & this.blockSize - 1);
        }
        return result;
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOfs, int inLen) {
        try {
            byte[] out = new byte[this.updateLength(inLen)];
            int n = this.engineUpdate(in, inOfs, inLen, out, 0);
            return P11Util.convert(out, 0, n);
        }
        catch (ShortBufferException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected int engineUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException {
        int outLen = out.length - outOfs;
        return this.implUpdate(in, inOfs, inLen, out, outOfs, outLen);
    }

    @Override
    protected int engineUpdate(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException {
        return this.implUpdate(inBuffer, outBuffer);
    }

    @Override
    protected byte[] engineDoFinal(byte[] in, int inOfs, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        try {
            byte[] out = new byte[this.doFinalLength(inLen)];
            int n = this.engineDoFinal(in, inOfs, inLen, out, 0);
            return P11Util.convert(out, 0, n);
        }
        catch (ShortBufferException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected int engineDoFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n = 0;
        if (inLen != 0 && in != null) {
            n = this.engineUpdate(in, inOfs, inLen, out, outOfs);
            outOfs += n;
        }
        return n += this.implDoFinal(out, outOfs, out.length - outOfs);
    }

    @Override
    protected int engineDoFinal(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n = this.engineUpdate(inBuffer, outBuffer);
        return n += this.implDoFinal(outBuffer);
    }

    private int implUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws ShortBufferException {
        if (outLen < this.updateLength(inLen)) {
            throw new ShortBufferException();
        }
        try {
            this.ensureInitialized();
            int k = 0;
            int newPadBufferLen = 0;
            if (this.paddingObj != null && (!this.encrypt || this.reqBlockUpdates)) {
                if (this.padBufferLen != 0) {
                    if (this.padBufferLen != this.padBuffer.length) {
                        int bufCapacity = this.padBuffer.length - this.padBufferLen;
                        if (inLen > bufCapacity) {
                            this.bufferInputBytes(in, inOfs, bufCapacity);
                            inOfs += bufCapacity;
                            inLen -= bufCapacity;
                        } else {
                            this.bufferInputBytes(in, inOfs, inLen);
                            return 0;
                        }
                    }
                    k = this.encrypt ? this.token.p11.C_EncryptUpdate(this.session.id(), 0L, this.padBuffer, 0, this.padBufferLen, 0L, out, outOfs, outLen) : this.token.p11.C_DecryptUpdate(this.session.id(), 0L, this.padBuffer, 0, this.padBufferLen, 0L, out, outOfs, outLen);
                    this.padBufferLen = 0;
                }
                newPadBufferLen = inLen & this.blockSize - 1;
                if (!this.encrypt && newPadBufferLen == 0) {
                    newPadBufferLen = this.padBuffer.length;
                }
                inLen -= newPadBufferLen;
            }
            if (inLen > 0) {
                k = this.encrypt ? (k += this.token.p11.C_EncryptUpdate(this.session.id(), 0L, in, inOfs, inLen, 0L, out, outOfs + k, outLen - k)) : (k += this.token.p11.C_DecryptUpdate(this.session.id(), 0L, in, inOfs, inLen, 0L, out, outOfs + k, outLen - k));
            }
            if (this.paddingObj != null && newPadBufferLen > 0) {
                this.bufferInputBytes(in, inOfs + inLen, newPadBufferLen);
            }
            this.bytesBuffered += inLen - k;
            return k;
        }
        catch (PKCS11Exception e) {
            if (e.getErrorCode() == 336L) {
                throw (ShortBufferException)new ShortBufferException().initCause(e);
            }
            this.reset(true);
            throw new ProviderException("update() failed", e);
        }
    }

    private int implUpdate(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException {
        int inLen = inBuffer.remaining();
        if (inLen <= 0) {
            return 0;
        }
        int outLen = outBuffer.remaining();
        if (outLen < this.updateLength(inLen)) {
            throw new ShortBufferException();
        }
        int origPos = inBuffer.position();
        try {
            this.ensureInitialized();
            long inAddr = 0L;
            int inOfs = 0;
            byte[] inArray = null;
            if (inBuffer instanceof DirectBuffer) {
                inAddr = ((DirectBuffer)((Object)inBuffer)).address();
                inOfs = origPos;
            } else if (inBuffer.hasArray()) {
                inArray = inBuffer.array();
                inOfs = origPos + inBuffer.arrayOffset();
            }
            long outAddr = 0L;
            int outOfs = 0;
            byte[] outArray = null;
            if (outBuffer instanceof DirectBuffer) {
                outAddr = ((DirectBuffer)((Object)outBuffer)).address();
                outOfs = outBuffer.position();
            } else if (outBuffer.hasArray()) {
                outArray = outBuffer.array();
                outOfs = outBuffer.position() + outBuffer.arrayOffset();
            } else {
                outArray = new byte[outLen];
            }
            int k = 0;
            int newPadBufferLen = 0;
            if (this.paddingObj != null && (!this.encrypt || this.reqBlockUpdates)) {
                if (this.padBufferLen != 0) {
                    if (this.padBufferLen != this.padBuffer.length) {
                        int bufCapacity = this.padBuffer.length - this.padBufferLen;
                        if (inLen > bufCapacity) {
                            this.bufferInputBytes(inBuffer, bufCapacity);
                            inOfs += bufCapacity;
                            inLen -= bufCapacity;
                        } else {
                            this.bufferInputBytes(inBuffer, inLen);
                            return 0;
                        }
                    }
                    k = this.encrypt ? this.token.p11.C_EncryptUpdate(this.session.id(), 0L, this.padBuffer, 0, this.padBufferLen, outAddr, outArray, outOfs, outLen) : this.token.p11.C_DecryptUpdate(this.session.id(), 0L, this.padBuffer, 0, this.padBufferLen, outAddr, outArray, outOfs, outLen);
                    this.padBufferLen = 0;
                }
                newPadBufferLen = inLen & this.blockSize - 1;
                if (!this.encrypt && newPadBufferLen == 0) {
                    newPadBufferLen = this.padBuffer.length;
                }
                inLen -= newPadBufferLen;
            }
            if (inLen > 0) {
                if (inAddr == 0L && inArray == null) {
                    inArray = new byte[inLen];
                    inBuffer.get(inArray);
                } else {
                    inBuffer.position(inBuffer.position() + inLen);
                }
                k = this.encrypt ? (k += this.token.p11.C_EncryptUpdate(this.session.id(), inAddr, inArray, inOfs, inLen, outAddr, outArray, outOfs + k, outLen - k)) : (k += this.token.p11.C_DecryptUpdate(this.session.id(), inAddr, inArray, inOfs, inLen, outAddr, outArray, outOfs + k, outLen - k));
            }
            if (this.paddingObj != null && newPadBufferLen > 0) {
                this.bufferInputBytes(inBuffer, newPadBufferLen);
            }
            this.bytesBuffered += inLen - k;
            if (!(outBuffer instanceof DirectBuffer) && !outBuffer.hasArray()) {
                outBuffer.put(outArray, outOfs, k);
            } else {
                outBuffer.position(outBuffer.position() + k);
            }
            return k;
        }
        catch (PKCS11Exception e) {
            inBuffer.position(origPos);
            if (e.getErrorCode() == 336L) {
                throw (ShortBufferException)new ShortBufferException().initCause(e);
            }
            this.reset(true);
            throw new ProviderException("update() failed", e);
        }
    }

    private int implDoFinal(byte[] out, int outOfs, int outLen) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int requiredOutLen = this.doFinalLength(0);
        if (outLen < requiredOutLen) {
            throw new ShortBufferException();
        }
        boolean doCancel = true;
        try {
            this.ensureInitialized();
            int k = 0;
            if (this.encrypt) {
                if (this.paddingObj != null) {
                    int startOff = 0;
                    if (this.reqBlockUpdates) {
                        startOff = this.padBufferLen;
                    }
                    int actualPadLen = this.paddingObj.setPaddingBytes(this.padBuffer, startOff, requiredOutLen - this.bytesBuffered);
                    k = this.token.p11.C_EncryptUpdate(this.session.id(), 0L, this.padBuffer, 0, startOff + actualPadLen, 0L, out, outOfs, outLen);
                }
                doCancel = false;
                k += this.token.p11.C_EncryptFinal(this.session.id(), 0L, out, outOfs + k, outLen - k);
            } else {
                if (this.bytesBuffered == 0 && this.padBufferLen == 0) {
                    int startOff = 0;
                    return startOff;
                }
                if (this.paddingObj != null) {
                    if (this.padBufferLen != 0) {
                        k = this.token.p11.C_DecryptUpdate(this.session.id(), 0L, this.padBuffer, 0, this.padBufferLen, 0L, this.padBuffer, 0, this.padBuffer.length);
                    }
                    doCancel = false;
                    k += this.token.p11.C_DecryptFinal(this.session.id(), 0L, this.padBuffer, k, this.padBuffer.length - k);
                    int actualPadLen = this.paddingObj.unpad(this.padBuffer, k);
                    System.arraycopy(this.padBuffer, 0, out, outOfs, k -= actualPadLen);
                } else {
                    doCancel = false;
                    k = this.token.p11.C_DecryptFinal(this.session.id(), 0L, out, outOfs, outLen);
                }
            }
            int n = k;
            return n;
        }
        catch (PKCS11Exception e) {
            this.handleException(e);
            throw new ProviderException("doFinal() failed", e);
        }
        finally {
            this.reset(doCancel);
        }
    }

    private int implDoFinal(ByteBuffer outBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int requiredOutLen;
        int outLen = outBuffer.remaining();
        if (outLen < (requiredOutLen = this.doFinalLength(0))) {
            throw new ShortBufferException();
        }
        boolean doCancel = true;
        try {
            this.ensureInitialized();
            long outAddr = 0L;
            byte[] outArray = null;
            int outOfs = 0;
            if (outBuffer instanceof DirectBuffer) {
                outAddr = ((DirectBuffer)((Object)outBuffer)).address();
                outOfs = outBuffer.position();
            } else if (outBuffer.hasArray()) {
                outArray = outBuffer.array();
                outOfs = outBuffer.position() + outBuffer.arrayOffset();
            } else {
                outArray = new byte[outLen];
            }
            int k = 0;
            if (this.encrypt) {
                if (this.paddingObj != null) {
                    int startOff = 0;
                    if (this.reqBlockUpdates) {
                        startOff = this.padBufferLen;
                    }
                    int actualPadLen = this.paddingObj.setPaddingBytes(this.padBuffer, startOff, requiredOutLen - this.bytesBuffered);
                    k = this.token.p11.C_EncryptUpdate(this.session.id(), 0L, this.padBuffer, 0, startOff + actualPadLen, outAddr, outArray, outOfs, outLen);
                }
                doCancel = false;
                k += this.token.p11.C_EncryptFinal(this.session.id(), outAddr, outArray, outOfs + k, outLen - k);
            } else {
                if (this.bytesBuffered == 0 && this.padBufferLen == 0) {
                    int startOff = 0;
                    return startOff;
                }
                if (this.paddingObj != null) {
                    if (this.padBufferLen != 0) {
                        k = this.token.p11.C_DecryptUpdate(this.session.id(), 0L, this.padBuffer, 0, this.padBufferLen, 0L, this.padBuffer, 0, this.padBuffer.length);
                        this.padBufferLen = 0;
                    }
                    doCancel = false;
                    k += this.token.p11.C_DecryptFinal(this.session.id(), 0L, this.padBuffer, k, this.padBuffer.length - k);
                    int actualPadLen = this.paddingObj.unpad(this.padBuffer, k);
                    k -= actualPadLen;
                    outArray = this.padBuffer;
                    outOfs = 0;
                } else {
                    doCancel = false;
                    k = this.token.p11.C_DecryptFinal(this.session.id(), outAddr, outArray, outOfs, outLen);
                }
            }
            if (!this.encrypt && this.paddingObj != null || !(outBuffer instanceof DirectBuffer) && !outBuffer.hasArray()) {
                outBuffer.put(outArray, outOfs, k);
            } else {
                outBuffer.position(outBuffer.position() + k);
            }
            int n = k;
            return n;
        }
        catch (PKCS11Exception e) {
            this.handleException(e);
            throw new ProviderException("doFinal() failed", e);
        }
        finally {
            this.reset(doCancel);
        }
    }

    private void handleException(PKCS11Exception e) throws ShortBufferException, IllegalBlockSizeException {
        long errorCode = e.getErrorCode();
        if (errorCode == 336L) {
            throw (ShortBufferException)new ShortBufferException().initCause(e);
        }
        if (errorCode == 33L || errorCode == 65L) {
            throw (IllegalBlockSizeException)new IllegalBlockSizeException(e.toString()).initCause(e);
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        throw new UnsupportedOperationException("engineWrap()");
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException("engineUnwrap()");
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n = P11SecretKeyFactory.convertKey(this.token, key, this.keyAlgorithm).length();
        return n;
    }

    private final void bufferInputBytes(byte[] in, int inOfs, int len) {
        System.arraycopy(in, inOfs, this.padBuffer, this.padBufferLen, len);
        this.padBufferLen += len;
        this.bytesBuffered += len;
    }

    private final void bufferInputBytes(ByteBuffer inBuffer, int len) {
        inBuffer.get(this.padBuffer, this.padBufferLen, len);
        this.padBufferLen += len;
        this.bytesBuffered += len;
    }

    private static class PKCS5Padding
    implements Padding {
        private final int blockSize;

        PKCS5Padding(int blockSize) throws NoSuchPaddingException {
            if (blockSize == 0) {
                throw new NoSuchPaddingException("PKCS#5 padding not supported with stream ciphers");
            }
            this.blockSize = blockSize;
        }

        @Override
        public int setPaddingBytes(byte[] paddingBuffer, int startOff, int padLen) {
            Arrays.fill(paddingBuffer, startOff, startOff + padLen, (byte)(padLen & 0x7F));
            return padLen;
        }

        @Override
        public int unpad(byte[] paddedData, int len) throws BadPaddingException, IllegalBlockSizeException {
            int padStartIndex;
            if (len < 1 || len % this.blockSize != 0) {
                throw new IllegalBlockSizeException("Input length must be multiples of " + this.blockSize);
            }
            byte padValue = paddedData[len - 1];
            if (padValue < 1 || padValue > this.blockSize) {
                throw new BadPaddingException("Invalid pad value!");
            }
            for (int i = padStartIndex = len - padValue; i < len; ++i) {
                if (paddedData[i] == padValue) continue;
                throw new BadPaddingException("Invalid pad bytes!");
            }
            return padValue;
        }
    }

    private static interface Padding {
        public int setPaddingBytes(byte[] var1, int var2, int var3);

        public int unpad(byte[] var1, int var2) throws BadPaddingException, IllegalBlockSizeException;
    }
}

