/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jsign.pkcs11;

import com.github.kwart.jsign.pkcs11.NativeKeyHolder;
import com.github.kwart.jsign.pkcs11.P11Key;
import com.github.kwart.jsign.pkcs11.Session;
import com.github.kwart.jsign.pkcs11.Token;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.security.ProviderException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class SessionKeyRef
extends PhantomReference<P11Key> {
    private static ReferenceQueue<P11Key> refQueue = new ReferenceQueue();
    private static Set<SessionKeyRef> refSet = Collections.synchronizedSet(new HashSet());
    private long keyID;
    private Session session;
    private boolean wrapperKeyUsed;

    static ReferenceQueue<P11Key> referenceQueue() {
        return refQueue;
    }

    private static void drainRefQueueBounded() {
        SessionKeyRef next;
        while ((next = (SessionKeyRef)refQueue.poll()) != null) {
            next.dispose();
        }
    }

    SessionKeyRef(P11Key p11Key, long keyID, boolean wrapperKeyUsed, Session session) {
        super(p11Key, refQueue);
        if (session == null) {
            throw new ProviderException("key must be associated with a session");
        }
        this.registerNativeKey(keyID, session);
        this.wrapperKeyUsed = wrapperKeyUsed;
        refSet.add(this);
        SessionKeyRef.drainRefQueueBounded();
    }

    void registerNativeKey(long newKeyID, Session newSession) {
        assert (newKeyID != 0L);
        assert (newSession != null);
        this.updateNativeKey(newKeyID, newSession);
    }

    void removeNativeKey() {
        assert (this.session != null);
        this.updateNativeKey(0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNativeKey(long newKeyID, Session newSession) {
        if (newKeyID == 0L) {
            assert (newSession == null);
            Token token = this.session.token;
            if (token.isValid()) {
                Session s = null;
                try {
                    s = token.getOpSession();
                    token.p11.C_DestroyObject(s.id(), this.keyID);
                }
                catch (PKCS11Exception pKCS11Exception) {
                }
                finally {
                    token.releaseSession(s);
                }
            }
            this.session.removeObject();
        } else {
            newSession.addObject();
        }
        this.keyID = newKeyID;
        this.session = newSession;
    }

    void dispose() {
        if (this.wrapperKeyUsed) {
            NativeKeyHolder.decWrapperKeyRef();
        }
        if (this.keyID != 0L) {
            this.removeNativeKey();
        }
        refSet.remove(this);
        this.clear();
    }
}

