/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import java.awt.Rectangle;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class XFAFormObject
extends FormObject {
    public static final int LAYOUT_POSITION = 1;
    public static final int LAYOUT_LEFTtoRIGHT = 2;
    public static final int LAYOUT_RIGHTtoLEFT = 3;
    public static final int LAYOUT_TABLE = 4;
    public static final int LAYOUT_TOPtoBOTTOM = 5;
    public int layout;
    public String script;
    public String scriptType;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int INLINE = 0;
    public int heightOfCaption;
    public int widthOfCaption;
    public int captionPosition = 0;
    public static final int SQUARE = 50;
    public static final int ROUND = 51;
    public int outline;
    public static final int CHOICE_CLICK = 1;
    public static final int CHOICE_ENTRY = 2;
    public static final int CHOICE_ALWAYS = 3;
    public int choiceShown;
    public static final int BORDER_DASHED = 1;
    public static final int BORDER_DOTTED = 2;
    public static final int BORDER_DASHDOT = 3;
    public static final int BORDER_DASHDOTDOT = 4;
    public static final int BORDER_SOLID = 5;
    public static final int BORDER_LOWERED = 6;
    public static final int BORDER_RAISED = 7;
    public static final int BORDER_ETCHED = 8;
    public static final int BORDER_EMBOSSED = 9;
    public int borderStroke;
    public static final int ACTION_CHANGE = 1;
    public static final int ACTION_MOUSECLICK = 2;
    public static final int ACTION_DOCSAVED = 3;
    public static final int ACTION_PRERENDER = 4;
    public static final int ACTION_GAINFOCUS = 5;
    public static final int ACTION_LOSSFOCUS = 6;
    public static final int ACTION_FIELDFULL = 7;
    public static final int ACTION_INIT = 8;
    public static final int ACTION_MOUSEPRESS = 9;
    public static final int ACTION_MOUSEENTER = 10;
    public static final int ACTION_MOUSEEXIT = 11;
    public static final int ACTION_MOUSERELEASE = 12;
    public static final int ACTION_WEBSENT = 13;
    public static final int ACTION_WEBSENDING = 14;
    public static final int ACTION_POSTSAVE = 15;
    public static final int ACTION_PRESAVE = 16;
    public static final int ACTION_POSTPRINT = 17;
    public static final int ACTION_SUBMITVIAHTTP = 18;
    public static final int ACTION_DOMLOADED = 19;
    public int activity = -1;
    public String typeface;
    public int numericValue;
    public boolean editable;
    public int marginBottomInset;
    public int marginTopInset;
    public int marginLeftInset;
    public int marginRightInset;
    public static final int DELEGATETOSERVER = 30;
    public static final int FORMAT_XDP = 1;
    public static final int FORMAT_URLENCODED = 2;
    public static final int FORMAT_PDF = 3;
    public static final int FORMAT_XFD = 4;
    public static final int FORMAT_XML = 5;
    public static final int ENCODE_DEFAULT = 0;
    public static final int ENCODE_ISO_8859_1 = 1;
    public static final int ENCODE_ISO_8859_2 = 2;
    public static final int ENCODE_ISO_8859_7 = 3;
    public static final int ENCODE_SHIFT_JIS = 4;
    public static final int ENCODE_KSC_5601 = 5;
    public static final int ENCODE_BIG_FIVE = 6;
    public static final int ENCODE_GB_2312 = 7;
    public static final int ENCODE_UTF_8 = 8;
    public static final int ENCODE_UTF_16 = 9;
    public static final int ENCODE_UCS_2 = 10;
    public static final int ENCODE_FONTSPECIFIC = 15;
    public int submitDataFormat;
    public String submitURL;
    public int submitTextEncode;
    public int longMedium;
    public int shortMedium;
    public String stdPaperName;
    public static final int JUSTIFY_EXCEPT_LAST_ALIGNMENT = 2;
    public static final int JUSTIFY_ALIGNMENT = 3;
    public static final int RADIX_ALIGNMENT = 4;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public float verticalAlign;

    public XFAFormObject() {
        this.isXFAObject = true;
    }

    @Override
    public PdfObject duplicate() {
        XFAFormObject newObject = (XFAFormObject)super.duplicate();
        newObject.activity = this.activity;
        newObject.borderStroke = this.borderStroke;
        newObject.captionPosition = this.captionPosition;
        newObject.choiceShown = this.choiceShown;
        newObject.heightOfCaption = this.heightOfCaption;
        newObject.layout = this.layout;
        newObject.longMedium = this.longMedium;
        newObject.numericValue = this.numericValue;
        newObject.marginBottomInset = this.marginBottomInset;
        newObject.marginTopInset = this.marginTopInset;
        newObject.marginLeftInset = this.marginLeftInset;
        newObject.marginRightInset = this.marginRightInset;
        newObject.outline = this.outline;
        newObject.shortMedium = this.shortMedium;
        newObject.submitDataFormat = this.submitDataFormat;
        newObject.submitTextEncode = this.submitTextEncode;
        newObject.widthOfCaption = this.widthOfCaption;
        newObject.script = this.script;
        newObject.scriptType = this.scriptType;
        newObject.stdPaperName = this.stdPaperName;
        newObject.submitURL = this.submitURL;
        newObject.typeface = this.typeface;
        newObject.editable = this.editable;
        newObject.verticalAlign = this.verticalAlign;
        return newObject;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n  layout=");
        buf.append(this.layout);
        buf.append("\n  scriptname=");
        buf.append(this.script);
        buf.append("\n  heightofcaption=");
        buf.append(this.heightOfCaption);
        buf.append("\n  widthofcaption=");
        buf.append(this.widthOfCaption);
        buf.append("\n  captionposition=");
        buf.append(this.captionPosition);
        buf.append("\n  outline=");
        buf.append(this.outline);
        buf.append("\n  choiceshown=");
        buf.append(this.choiceShown);
        buf.append("\n  borderstroke=");
        buf.append(this.borderStroke);
        buf.append("\n  activity=");
        buf.append(this.activity);
        buf.append("\n  typeface=");
        buf.append(this.typeface);
        buf.append("\n  numericvalue=");
        buf.append(this.numericValue);
        buf.append("\n  editable=");
        buf.append(this.editable);
        buf.append("\n  maginbottom=");
        buf.append(this.marginBottomInset);
        buf.append("\n  margintop=");
        buf.append(this.marginTopInset);
        buf.append("\n  marginleft=");
        buf.append(this.marginLeftInset);
        buf.append("\n  marginright=");
        buf.append(this.marginRightInset);
        buf.append("\n  submitdataformat=");
        buf.append(this.submitDataFormat);
        buf.append("\n  submiturl=");
        buf.append(this.submitURL);
        buf.append("\n  submittextencoding=");
        buf.append(this.submitTextEncode);
        buf.append("\n  longmedium=");
        buf.append(this.longMedium);
        buf.append("\n  shortmedium=");
        buf.append(this.shortMedium);
        buf.append("\n  stdpapername=");
        buf.append(this.stdPaperName);
        buf.append("\n  verticalalign=");
        buf.append(this.verticalAlign);
        return super.toString() + buf;
    }

    public void setHorizontalAlign(Object field) {
        this.Q = 2;
        if (field.equals("center")) {
            this.Q = 0;
        } else if (field.equals("justify")) {
            this.Q = 2;
        } else if (field.equals("justifyAll")) {
            this.Q = 3;
        } else if (field.equals("left")) {
            this.Q = 2;
        } else if (field.equals("radix")) {
            this.Q = 4;
        } else if (field.equals("right")) {
            this.Q = 4;
        } else {
            LogWriter.writeFormLog("XFAFormObject.setHorizontalAlign not taking " + field, false);
        }
    }

    public void setVerticalAllign(String attValue) {
        if (attValue.equals("middle")) {
            this.verticalAlign = 0.5f;
        } else if (attValue.equals("top")) {
            this.verticalAlign = 0.0f;
        } else if (attValue.equals("bottom")) {
            this.verticalAlign = 1.0f;
        } else {
            LogWriter.writeFormLog("XFAFormObject.setVerticalAlign not taking " + attValue, false);
        }
    }

    public void setLayout(String val) {
        if (val.equals("position")) {
            this.layout = 1;
        } else if (val.equals("lr-tb")) {
            this.layout = 2;
        } else if (val.equals("rl-tb")) {
            this.layout = 3;
        } else if (val.equals("row")) {
            LogWriter.writeFormLog("row layout NOT IMPLEMENTED", false);
        } else if (val.equals("table")) {
            this.layout = 4;
        } else if (val.equals("tb")) {
            this.layout = 5;
        }
    }

    public static void setLocale(String attValue) {
        LogWriter.writeFormLog("XFAFormObject.setLocale NOT IMPLEMENTED =" + attValue, false);
    }

    public void setScript(String attValue) {
        this.script = attValue;
    }

    public static void setBindtypeOnMerge(String attValue) {
    }

    public static void setPositionToVector(String attValue) {
    }

    public void setCaptionReserve(int attValue) {
        if (this.captionPosition != 0) {
            if (this.captionPosition == 3 || this.captionPosition == 4) {
                this.heightOfCaption = attValue;
            } else if (this.captionPosition == 1 || this.captionPosition == 2) {
                this.widthOfCaption = attValue;
            }
        }
    }

    public void setCaptionPlacement(String attValue) {
        if (attValue.equals("left")) {
            this.captionPosition = 1;
        } else if (attValue.equals("right")) {
            this.captionPosition = 2;
        } else if (attValue.equals("top")) {
            this.captionPosition = 3;
        } else if (attValue.equals("bottom")) {
            this.captionPosition = 4;
        } else if (attValue.equals("inline")) {
            this.captionPosition = 0;
        }
    }

    public void setOutline(String attValue) {
        if (attValue.equals("square")) {
            this.outline = 50;
        } else if (attValue.equals("round")) {
            this.outline = 51;
        }
    }

    public static void setContentType(String attValue) {
    }

    public void setChoiceOpening(String attValue) {
        if (attValue.equals("userControl")) {
            this.choiceShown = 1;
        } else if (attValue.equals("OnEntry")) {
            this.choiceShown = 2;
        } else if (attValue.equals("always")) {
            this.choiceShown = 3;
        }
    }

    public void setBorderStroke(String attValue) {
        if (attValue.equals("solid")) {
            this.borderStroke = 5;
        } else if (attValue.equals("dashed")) {
            this.borderStroke = 1;
        } else if (attValue.equals("dotted")) {
            this.borderStroke = 2;
        } else if (attValue.equals("dashDot")) {
            this.borderStroke = 3;
        } else if (attValue.equals("dashDotDot")) {
            this.borderStroke = 4;
        } else if (attValue.equals("lowered")) {
            this.borderStroke = 6;
        } else if (attValue.equals("raised")) {
            this.borderStroke = 7;
        } else if (attValue.equals("etched")) {
            this.borderStroke = 8;
        } else if (attValue.equals("embossed")) {
            this.borderStroke = 9;
        }
    }

    public void setEventAction(String attValue) {
        if (attValue.equals("change")) {
            this.activity = 1;
        } else if (attValue.equals("click")) {
            this.activity = 2;
        } else if (attValue.equals("docClose")) {
            this.activity = 3;
        } else if (attValue.equals("docReady")) {
            this.activity = 4;
        } else if (attValue.equals("enter")) {
            this.activity = 5;
        } else if (attValue.equals("exit")) {
            this.activity = 6;
        } else if (attValue.equals("full")) {
            this.activity = 7;
        } else if (attValue.equals("initialize")) {
            this.activity = 8;
        } else if (attValue.equals("mouseDown")) {
            this.activity = 9;
        } else if (attValue.equals("mouseEnter")) {
            this.activity = 10;
        } else if (attValue.equals("mouseExit")) {
            this.activity = 11;
        } else if (attValue.equals("mouseUp")) {
            this.activity = 12;
        } else if (attValue.equals("postExecute")) {
            this.activity = 13;
        } else if (attValue.equals("postPrint")) {
            this.activity = 17;
        } else if (attValue.equals("postSave")) {
            this.activity = 15;
        } else if (attValue.equals("preExecute")) {
            this.activity = 14;
        } else if (attValue.equals("preSave")) {
            this.activity = 16;
        } else if (attValue.equals("preSubmit")) {
            this.activity = 18;
        } else if (attValue.equals("ready")) {
            this.activity = 19;
        }
    }

    public void setTypeface(String attValue) {
        this.typeface = attValue;
    }

    public void setIntegerValue(String nodeValue) {
        if (nodeValue == null) {
            return;
        }
        try {
            this.numericValue = Integer.parseInt(nodeValue);
        }
        catch (NumberFormatException e) {
            LogWriter.writeFormLog("NumberFormatException XFAFormObject", false);
        }
    }

    public void setEditability(String attValue) {
        if (attValue.equals("0")) {
            this.editable = false;
        } else if (attValue.equals("1")) {
            this.editable = true;
        }
    }

    public void setWidth(int attValue) {
        if (this.BBox == null) {
            this.BBox = new Rectangle(0, 0, 0, 0);
        }
        this.BBox.width = attValue;
    }

    public void setHeight(int attValue) {
        if (this.BBox == null) {
            this.BBox = new Rectangle(0, 0, 0, 0);
        }
        this.BBox.height = attValue;
    }

    public void setX(int attValue) {
        if (this.BBox == null) {
            this.BBox = new Rectangle(0, 0, 0, 0);
        }
        this.BBox.x = attValue;
    }

    public void setY(int attValue) {
        if (this.BBox == null) {
            this.BBox = new Rectangle(0, 0, 0, 0);
        }
        this.BBox.y = attValue;
    }

    public void setMarginBottomInset(int attValue) {
        this.marginBottomInset = attValue;
    }

    public void setMarginTopInset(int attValue) {
        this.marginTopInset = attValue;
    }

    public void setMarginLeftInset(int attValue) {
        this.marginLeftInset = attValue;
    }

    public void setMarginRightInset(int attValue) {
        this.marginRightInset = attValue;
    }

    public void setLongMeduim(int attValue) {
        this.longMedium = attValue;
    }

    public void setShortMedium(int attValue) {
        this.shortMedium = attValue;
    }

    public void setStdPaperName(String attValue) {
        this.stdPaperName = attValue;
    }

    public void setSubmitFormat(String attValue) {
        if (attValue.equals("xdp")) {
            this.submitDataFormat = 1;
        } else if (attValue.equals("delegate")) {
            this.submitDataFormat = 30;
        } else if (attValue.equals("formdata")) {
            this.submitDataFormat = 2;
        } else if (attValue.equals("pdf")) {
            this.submitDataFormat = 3;
        } else if (attValue.equals("xfd")) {
            this.submitDataFormat = 4;
        } else if (attValue.equals("xml")) {
            this.submitDataFormat = 5;
        }
    }

    public void setSubmitURL(String attValue) {
        this.submitURL = attValue;
    }

    public void setSubmitTextEncoding(String attValue) {
        if (this.submitDataFormat == 2) {
            return;
        }
        if (attValue.equalsIgnoreCase("none")) {
            this.submitTextEncode = 0;
        } else if (attValue.equalsIgnoreCase("ISO-8859-1")) {
            this.submitTextEncode = 1;
        } else if (attValue.equalsIgnoreCase("iso-8859-2")) {
            this.submitTextEncode = 2;
        } else if (attValue.equalsIgnoreCase("iso-8859-7")) {
            this.submitTextEncode = 3;
        } else if (attValue.equalsIgnoreCase("shift-jis")) {
            this.submitTextEncode = 4;
        } else if (attValue.equalsIgnoreCase("ksc-5601")) {
            this.submitTextEncode = 5;
        } else if (attValue.equalsIgnoreCase("big-five")) {
            this.submitTextEncode = 6;
        } else if (attValue.equalsIgnoreCase("gb-2312")) {
            this.submitTextEncode = 7;
        } else if (attValue.equalsIgnoreCase("utf-8")) {
            this.submitTextEncode = 8;
        } else if (attValue.equalsIgnoreCase("utf-16")) {
            this.submitTextEncode = 9;
        } else if (attValue.equalsIgnoreCase("ucs-2")) {
            this.submitTextEncode = 10;
        } else if (attValue.equalsIgnoreCase("fontSpecific")) {
            this.submitTextEncode = 15;
        }
    }

    public void setScriptType(String item) {
        this.scriptType = item;
    }
}

