/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.Flag;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class FullScreenWindow {
    private static GraphicsDevice defaultScreen;
    private GraphicsDevice screen;
    private JFrame jf;
    private boolean dead = false;
    private Flag flag = new Flag();
    private GraphicsDevice pickedDevice;

    public FullScreenWindow(JComponent jComponent, boolean bl) {
        this.init(jComponent, bl);
    }

    public FullScreenWindow(JComponent jComponent) {
        this.init(jComponent, false);
    }

    public void close() {
        this.dead = true;
        this.flag.set();
        this.screen.setFullScreenWindow(null);
        if (this.jf != null) {
            this.jf.dispose();
        }
    }

    private void init(JComponent jComponent, boolean bl) {
        if (bl) {
            defaultScreen = null;
        }
        this.screen = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        if (defaultScreen != null) {
            for (int i = 0; i < graphicsDeviceArray.length; ++i) {
                if (graphicsDeviceArray[i] != defaultScreen) continue;
                this.screen = defaultScreen;
            }
        }
        if (graphicsDeviceArray.length == 1) {
            this.screen = graphicsDeviceArray[0];
        }
        if (this.screen == null) {
            this.screen = this.pickScreen(graphicsDeviceArray);
        }
        if (this.dead) {
            return;
        }
        defaultScreen = this.screen;
        DisplayMode displayMode = this.screen.getDisplayMode();
        GraphicsConfiguration graphicsConfiguration = this.screen.getDefaultConfiguration();
        this.jf = new JFrame(graphicsConfiguration);
        this.jf.setUndecorated(true);
        this.jf.setBounds(graphicsConfiguration.getBounds());
        this.jf.getContentPane().add(jComponent);
        this.jf.setVisible(true);
        this.screen.setFullScreenWindow(this.jf);
    }

    private void pickDevice(GraphicsDevice graphicsDevice) {
        this.pickedDevice = graphicsDevice;
        this.flag.set();
    }

    private GraphicsDevice pickScreen(GraphicsDevice[] graphicsDeviceArray) {
        int n;
        this.flag.clear();
        int n2 = 0;
        PickMe[] pickMeArray = new PickMe[graphicsDeviceArray.length];
        for (n = 0; n < graphicsDeviceArray.length; ++n) {
            if (graphicsDeviceArray[n].isFullScreenSupported()) {
                ++n2;
            }
            pickMeArray[n] = new PickMe(graphicsDeviceArray[n]);
        }
        this.flag.waitForFlag();
        for (n = 0; n < pickMeArray.length; ++n) {
            if (pickMeArray[n] == null) continue;
            pickMeArray[n].dispose();
        }
        return this.pickedDevice;
    }

    class PickMe
    extends JFrame {
        GraphicsDevice mygd;

        public PickMe(GraphicsDevice graphicsDevice) {
            super(graphicsDevice.getDefaultConfiguration());
            this.setUndecorated(true);
            this.mygd = graphicsDevice;
            JButton jButton = new JButton("Click here to use this screen");
            jButton.setBackground(Color.yellow);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FullScreenWindow.this.pickDevice(PickMe.this.mygd);
                }
            });
            Dimension dimension = jButton.getPreferredSize();
            dimension.width += 30;
            dimension.height = 200;
            jButton.setPreferredSize(dimension);
            this.getContentPane().add(jButton);
            this.pack();
            Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
            int n = rectangle.width / 2 - dimension.width / 2 + rectangle.x;
            int n2 = rectangle.height / 2 - dimension.height / 2 + rectangle.y;
            this.setLocation(n, n2);
            this.setVisible(true);
        }
    }
}

