/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import java.io.IOException;
import java.io.RandomAccessFile;

public class HexDump {
    public static void printData(byte[] byArray) {
        char[] cArray = new char[17];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            cArray[n++] = n2 == 0 ? 46 : (n2 < 32 || n2 >= 127 ? 63 : (char)n2);
            if (i % 16 == 0) {
                int n3 = Integer.toHexString(byArray.length).length();
                int n4 = Integer.toHexString(i).length();
                for (int j = n3; j > n4; --j) {
                    System.out.print("0");
                }
                System.out.print(Integer.toHexString(i) + ": ");
            }
            if (n2 < 16) {
                System.out.print("0" + Integer.toHexString(n2));
            } else {
                System.out.print(Integer.toHexString(n2));
            }
            if ((i & 0xF) == 15 || i == byArray.length - 1) {
                System.out.println("      " + new String(cArray));
                n = 0;
                continue;
            }
            if ((i & 7) == 7) {
                System.out.print("  ");
                cArray[n++] = 32;
                continue;
            }
            if ((i & 1) != 1) continue;
            System.out.print(" ");
        }
        System.out.println();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: ");
            System.out.println("    HexDump <filename>");
            System.exit(-1);
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(stringArray[0], "r");
            int n = (int)randomAccessFile.length();
            byte[] byArray = new byte[n];
            randomAccessFile.readFully(byArray);
            HexDump.printData(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

