/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.decode.Predictor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public class PNGPredictor
extends Predictor {
    public PNGPredictor() {
        super(1);
    }

    @Override
    public ByteBuffer unpredict(ByteBuffer byteBuffer) throws IOException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n = this.getColumns() * this.getColors() * this.getBitsPerComponent();
        n = (int)Math.ceil((double)n / 8.0);
        while (byteBuffer.remaining() >= n + 1) {
            int n2 = byteBuffer.get() & 0xFF;
            byArray = new byte[n];
            byteBuffer.get(byArray);
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    this.doSubLine(byArray);
                    break;
                }
                case 2: {
                    this.doUpLine(byArray, byArray2);
                    break;
                }
                case 3: {
                    this.doAverageLine(byArray, byArray2);
                    break;
                }
                case 4: {
                    this.doPaethLine(byArray, byArray2);
                }
            }
            arrayList.add(byArray);
            byArray2 = byArray;
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(arrayList.size() * n);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            byteBuffer2.put((byte[])iterator.next());
        }
        byteBuffer2.flip();
        return byteBuffer2;
    }

    protected void doSubLine(byte[] byArray) {
        int n = (int)Math.ceil((double)(this.getBitsPerComponent() * this.getColors()) / 8.0);
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = i - n;
            if (n2 < 0) continue;
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] + byArray[n2]);
        }
    }

    protected void doUpLine(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null) {
            return;
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] + byArray2[i]);
        }
    }

    protected void doAverageLine(byte[] byArray, byte[] byArray2) {
        int n = (int)Math.ceil((double)(this.getBitsPerComponent() * this.getColors()) / 8.0);
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = 0;
            int n4 = 0;
            int n5 = n2 - n;
            if (n5 >= 0) {
                n3 = byArray[n5] & 0xFF;
            }
            if (byArray2 != null) {
                n4 = byArray2[n2] & 0xFF;
            }
            int n6 = n2++;
            byArray[n6] = (byte)(byArray[n6] + (byte)Math.floor((n3 + n4) / 2));
        }
    }

    protected void doPaethLine(byte[] byArray, byte[] byArray2) {
        int n = (int)Math.ceil((double)(this.getBitsPerComponent() * this.getColors()) / 8.0);
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = n2 - n;
            if (n6 >= 0) {
                n3 = byArray[n6] & 0xFF;
            }
            if (byArray2 != null) {
                n4 = byArray2[n2] & 0xFF;
            }
            if (n6 > 0 && byArray2 != null) {
                n5 = byArray2[n6] & 0xFF;
            }
            int n7 = n2++;
            byArray[n7] = (byte)(byArray[n7] + (byte)this.paeth(n3, n4, n5));
        }
    }

    protected int paeth(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        int n5 = Math.abs(n4 - n);
        int n6 = Math.abs(n4 - n2);
        int n7 = Math.abs(n4 - n3);
        if (n5 <= n6 && n5 <= n7) {
            return n;
        }
        if (n6 <= n7) {
            return n2;
        }
        return n3;
    }
}

