/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.decode.Predictor;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TIFFPredictor
extends Predictor {
    public TIFFPredictor() {
        super(0);
    }

    @Override
    public ByteBuffer unpredict(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.limit());
        int n = this.getColors();
        int n2 = n * this.getBitsPerComponent();
        int n3 = (this.getColumns() * n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        while (byteBuffer.remaining() > 0) {
            int n4;
            int n5;
            int n6;
            int n7;
            byteBuffer.get(byArray);
            if (this.getBitsPerComponent() == 8) {
                for (n7 = n; n7 < byArray.length; n7 += n) {
                    for (int i = 0; i < n; ++i) {
                        int n8 = n6 = n7 + i;
                        byArray[n8] = (byte)(byArray[n8] + byArray[n6 - n]);
                    }
                }
            } else if (this.getBitsPerComponent() == 16) {
                int n9;
                short[] sArray = new short[n];
                for (n9 = 0; n9 < n; ++n9) {
                    n6 = n9 * 2;
                    sArray[n9] = (short)(byArray[n6] << 8 | byArray[n6 + 1] & 0xFFFF);
                }
                for (n9 = n * 2; n9 < byArray.length; n9 += n * 2) {
                    for (n6 = 0; n6 < n; ++n6) {
                        n5 = n9 + n6 * 2;
                        n4 = (short)(byArray[n5] << 8 | byArray[n5 + 1] & 0xFFFF);
                        n4 = (short)(n4 + sArray[n6]);
                        byArray[n5] = (byte)(n4 >>> 8 & 0xFF);
                        byArray[n5 + 1] = (byte)(n4 & 0xFF);
                        sArray[n6] = n4;
                    }
                }
            } else {
                assert (this.getBitsPerComponent() == 1 || this.getBitsPerComponent() == 2 || this.getBitsPerComponent() == 4) : "we don't want to grab components across pixel boundaries";
                n7 = n2 * this.getColumns();
                byte[] byArray2 = new byte[n];
                n6 = 8 - this.getBitsPerComponent();
                n5 = (1 << this.getBitsPerComponent()) - 1;
                for (n4 = 0; n4 < n; ++n4) {
                    byArray2[n4] = TIFFPredictor.getbits(byArray, n4 * this.getBitsPerComponent(), n6, n5);
                }
                for (n4 = n2; n4 < n7; n4 += n2) {
                    for (int i = 0; i < n; ++i) {
                        byte by = TIFFPredictor.getbits(byArray, n4 + i * this.getBitsPerComponent(), n6, n5);
                        byArray2[i] = by = (byte)(by + byArray2[i]);
                        TIFFPredictor.setbits(byArray, n4 + i * this.getBitsPerComponent(), n6, n5, by);
                    }
                }
            }
            byteBuffer2.put(byArray);
        }
        byteBuffer2.flip();
        return byteBuffer2;
    }

    private static byte getbits(byte[] byArray, int n, int n2, int n3) {
        byte by = byArray[n >> 3];
        int n4 = n & 7;
        int n5 = n2 - n4;
        return (byte)(by >>> n5 & n3);
    }

    private static void setbits(byte[] byArray, int n, int n2, int n3, byte by) {
        byte by2 = byArray[n >> 3];
        int n4 = n & 7;
        int n5 = n2 - n4;
        byArray[n >> 3] = (byte)(by2 & ~(n3 << n5) | by << n5);
    }
}

