/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFObject;
import java.io.IOException;
import java.util.HashMap;

public abstract class PDFCMap {
    private static HashMap<String, PDFCMap> cache;

    protected PDFCMap() {
    }

    public static PDFCMap getCMap(PDFObject pDFObject) throws IOException {
        if (pDFObject.getType() == 4) {
            return PDFCMap.getCMap(pDFObject.getStringValue());
        }
        if (pDFObject.getType() == 7) {
            return PDFCMap.parseCMap(pDFObject);
        }
        throw new IOException("CMap type not Name or Stream!");
    }

    public static PDFCMap getCMap(String string) throws IOException {
        if (cache == null) {
            PDFCMap.populateCache();
        }
        if (!cache.containsKey(string)) {
            throw new IOException("Unknown CMap: " + string);
        }
        return cache.get(string);
    }

    protected static void populateCache() {
        cache = new HashMap();
        cache.put("Identity-H", new PDFCMap(){

            @Override
            public char map(char c) {
                return c;
            }
        });
    }

    protected static PDFCMap parseCMap(PDFObject pDFObject) throws IOException {
        throw new IOException("Parsing CMap Files Unsupported!");
    }

    public abstract char map(char var1);

    public int getFontID(char c) {
        return 0;
    }
}

