/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.swing.JTextArea;
import net.sf.jsignpdf.Constants;

public class JTextAreaHandler
extends Handler {
    private JTextArea jTextArea;

    public JTextAreaHandler(JTextArea jTextArea) {
        if (jTextArea == null) {
            throw new IllegalArgumentException("JTextArea has to be not-null.");
        }
        this.jTextArea = jTextArea;
    }

    @Override
    public void close() {
        this.jTextArea = null;
    }

    @Override
    public void publish(LogRecord record) {
        this.jTextArea.append(record.getLevel() + " " + record.getMessage() + Constants.NEW_LINE);
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            try (StringWriter stringWriter = new StringWriter();){
                thrown.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                this.jTextArea.append(stringWriter.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jTextArea.append(Constants.NEW_LINE);
        }
        this.jTextArea.setCaretPosition(this.jTextArea.getText().length());
    }

    @Override
    public void flush() {
    }
}

