/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import net.sf.jsignpdf.Constants;

public class SignerFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 1L;
    public static final FileFilter FILEFILTER_PDF = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".pdf");
        }

        @Override
        public String getDescription() {
            return Constants.RES.get("filefilter.pdf");
        }
    };

    @Override
    public void approveSelection() {
        File file;
        if (this.getDialogType() == 1 && (file = this.getSelectedFile()) != null && file.exists() && !this.confirmOverwrite(file)) {
            return;
        }
        super.approveSelection();
    }

    private boolean confirmOverwrite(File file) {
        String tmpMessage = Constants.RES.get("filechooser.overwrite.question", file.getAbsolutePath());
        return 0 == JOptionPane.showOptionDialog(this, tmpMessage, Constants.RES.get("filechooser.save.warning"), 0, 2, null, null, null);
    }

    @Override
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
        if (this.getUI() instanceof BasicFileChooserUI) {
            BasicFileChooserUI tmpUi = (BasicFileChooserUI)this.getUI();
            tmpUi.setFileName(file == null ? "" : file.getName());
        }
    }

    public void showFileChooser(JTextField aFileField, FileFilter aFilter, int aType) {
        String tmpFileName;
        this.setDialogType(aType);
        this.resetChoosableFileFilters();
        if (aFilter != null) {
            this.setFileFilter(aFilter);
        }
        if ((tmpFileName = aFileField.getText()) == null || tmpFileName.length() == 0) {
            this.setSelectedFile(null);
        } else {
            File tmpFile = new File(tmpFileName);
            this.setSelectedFile(tmpFile);
        }
        if (0 == this.showDialog(this, null)) {
            aFileField.setText(this.getSelectedFile().getAbsolutePath());
        }
    }
}

