/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.util.HashMap;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.raw.NamesObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public class NameLookup
extends HashMap {
    private static final long serialVersionUID = 1604162937228903817L;
    private final PdfFileReader objectReader;

    public NameLookup(PdfFileReader objectReader) {
        this.objectReader = objectReader;
    }

    public void readNames(PdfObject nameObject, Javascript javascript, boolean isKid) {
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        objectDecoder.checkResolved(nameObject);
        int[] nameLists = new int[]{893600855, -2006286978};
        int count = nameLists.length;
        if (isKid) {
            count = 1;
        }
        for (int ii = 0; ii < count; ++ii) {
            PdfArrayIterator namesArray;
            int kidCount;
            PdfObject pdfObj = isKid ? nameObject : nameObject.getDictionary(nameLists[ii]);
            if (pdfObj == null) continue;
            byte[][] kidList = pdfObj.getKeyArray(456733763);
            if (kidList != null && (kidCount = kidList.length) > 0) {
                for (byte[] aKidList : kidList) {
                    String nextValue = new String(aKidList);
                    NamesObject nextObject = new NamesObject(nextValue);
                    nextObject.ignoreRecursion(false);
                    this.objectReader.readObject(nextObject);
                    this.readNames(nextObject, javascript, true);
                }
            }
            if ((namesArray = pdfObj.getMixedArray(826094945)) == null || namesArray.getTokenCount() <= 0) continue;
            while (namesArray.hasMoreTokens()) {
                String name = namesArray.getNextValueAsString(true);
                if (!namesArray.hasMoreTokens()) continue;
                String value = namesArray.getNextValueAsString(true);
                if (nameLists[ii] == -2006286978) continue;
                this.put(name, value);
            }
        }
    }
}

