/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.T3Display;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Node;

public class FormStream {
    public static final boolean debugUnimplemented = false;
    public static final boolean debug = false;
    private static boolean showFontMessage = false;
    public static final boolean exitOnError = false;
    protected PdfObjectReader currentPdfFile;
    public static boolean marksNewJavascriptCode = false;
    public static final int[] id = new int[]{17, 4866, 4668, 21, 40, 20, 37, 5695, 8223, 8211, 8230, 8217, 31, 4865, 27, 22, 38, 4866, 5139, 10019, 5155, 10016, 5152};

    public FormStream() {
    }

    public FormStream(PdfObjectReader inCurrentPdfFile) {
        this.currentPdfFile = inCurrentPdfFile;
    }

    public FormObject createAppearanceString(FormObject formObj, PdfObjectReader inCurrentPdfFile) {
        this.currentPdfFile = inCurrentPdfFile;
        this.init(formObj);
        return formObj;
    }

    private void init(FormObject formObject) {
        String textStream;
        boolean debug = false;
        int Ff = formObject.getInt(5686);
        if (Ff != -1) {
            formObject.commandFf(Ff);
        }
        if (!marksNewJavascriptCode) {
            this.resolveAdditionalAction(formObject);
        }
        this.setupAPimages(formObject, false);
        int key = formObject.getNameAsConstant(24);
        if (key != -1) {
            if (key == 36 || key == 32) {
                if (!formObject.hasDownImage()) {
                    formObject.setOffsetDownApp();
                }
            } else if (key == 30) {
                formObject.setNoDownIcon();
            } else if (key == 25) {
                formObject.setInvertForDownIcon();
            }
        }
        if ((textStream = formObject.getTextStreamValue(5137)) != null) {
            FormStream.decodeFontCommandObj(textStream, formObject);
        }
    }

    public void setupAPimages(FormObject formObject, boolean debug) {
        int[] values = new int[]{30, 34, 20};
        String[] names = new String[]{"PdfDictionary.N", "PdfDictionary.R", "PdfDictionary.D"};
        int APcount = values.length;
        for (int ii = 0; ii < APcount; ++ii) {
            Map otherValues;
            PdfObject OffObj;
            BufferedImage img;
            PdfObject APobj = formObject.getDictionary(4384).getDictionary(values[ii]);
            if (APobj == null) continue;
            if (debug && values[ii] == 30) {
                System.out.println(" AP (" + names[ii] + ")=" + APobj + ' ' + APobj.getObjectRefAsString() + " AP=" + formObject.getDictionary(4384) + " form=" + formObject + ' ' + formObject.getObjectRefAsString() + " stream=" + APobj.getDecodedStream() + " Off=" + APobj.getDictionary(2045494));
            }
            if (APobj.getDecodedStream() != null) {
                img = FormStream.rotate(FormStream.decode(this.currentPdfFile, APobj, formObject.getParameterConstant(1147962727)), formObject.getDictionary(7451).getInt(34));
                if (debug) {
                    System.out.println(img);
                }
                if (img == null) continue;
                if (values[ii] == 20) {
                    formObject.setAppearanceImage(img, 20, 2045494);
                    if (!debug) continue;
                    System.out.println("D " + img);
                    continue;
                }
                if (values[ii] == 30 && !formObject.hasNormalOff()) {
                    formObject.setAppearanceImage(img, 30, 2045494);
                    if (!debug) continue;
                    System.out.println("N " + img);
                    continue;
                }
                if (values[ii] != 34) continue;
                formObject.setAppearanceImage(img, 34, 2045494);
                if (!debug) continue;
                System.out.println("R " + img);
                continue;
            }
            PdfObject OnObj = APobj.getDictionary(7998);
            if (OnObj != null) {
                img = FormStream.rotate(FormStream.decode(this.currentPdfFile, OnObj, formObject.getParameterConstant(1147962727)), formObject.getDictionary(7451).getInt(34));
                if (debug) {
                    System.out.println("On=" + OnObj + ' ' + img);
                }
                if (img == null) continue;
                if (values[ii] == 20) {
                    formObject.setAppearanceImage(img, 20, 7998);
                    if (!formObject.hasDownOff()) {
                        formObject.setAppearanceImage(null, 20, 2045494);
                    }
                } else if (values[ii] == 30) {
                    formObject.setAppearanceImage(img, 30, 7998);
                    formObject.setNormalOnState("On");
                } else if (values[ii] == 34) {
                    formObject.setAppearanceImage(img, 34, 7998);
                    if (!formObject.hasRolloverOff()) {
                        formObject.setAppearanceImage(null, 34, 2045494);
                    }
                }
            }
            if ((OffObj = APobj.getDictionary(2045494)) != null) {
                img = FormStream.rotate(FormStream.decode(this.currentPdfFile, OffObj, formObject.getParameterConstant(1147962727)), formObject.getDictionary(7451).getInt(34));
                if (debug) {
                    System.out.println("Off=" + OffObj + ' ' + OffObj.getDecodedStream() + ' ' + img);
                }
                if (img == null) continue;
                if (values[ii] == 20) {
                    formObject.setAppearanceImage(img, 20, 2045494);
                } else if (values[ii] == 30) {
                    formObject.setAppearanceImage(img, 30, 2045494);
                } else if (values[ii] == 34) {
                    formObject.setAppearanceImage(img, 34, 2045494);
                }
            }
            if ((otherValues = APobj.getOtherDictionaries()) == null || otherValues.isEmpty()) continue;
            if (debug) {
                System.out.println(formObject.getObjectRefAsString() + " AP Other=" + otherValues);
            }
            for (String key : otherValues.keySet()) {
                Object val = otherValues.get(key);
                PdfObject otherObj = (PdfObject)val;
                img = FormStream.rotate(FormStream.decode(this.currentPdfFile, otherObj, formObject.getParameterConstant(1147962727)), formObject.getDictionary(7451).getInt(34));
                if (debug) {
                    System.out.println("(other) " + key + ' ' + otherObj + ' ' + img);
                }
                if (img == null) continue;
                if (values[ii] == 20) {
                    if (debug) {
                        System.out.println("D(other) set=" + img + ' ' + formObject);
                    }
                    formObject.setAppearanceImage(img, 20, 7998);
                    if (formObject.hasDownOff()) continue;
                    formObject.setAppearanceImage(null, 20, 2045494);
                    continue;
                }
                if (values[ii] == 30) {
                    formObject.setAppearanceImage(img, 30, 7998);
                    formObject.setNormalOnState(key);
                    if (debug) {
                        System.out.println("Set N (other) " + formObject);
                    }
                    if (formObject.hasNormalOff()) continue;
                    formObject.setAppearanceImage(null, 30, 2045494);
                    continue;
                }
                if (values[ii] != 34) continue;
                formObject.setAppearanceImage(img, 34, 7998);
                if (formObject.hasRolloverOff()) continue;
                formObject.setAppearanceImage(null, 34, 2045494);
            }
        }
    }

    private void resolveAdditionalAction(FormObject formObject) {
        int[] nArray = id;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int anId;
            int idValue = anId = nArray[i];
        }
    }

    public static BufferedImage decode(PdfObjectReader currentPdfFile, PdfObject XObject2, int subtype) {
        return FormStream.decode(currentPdfFile, XObject2, subtype, 0, 0, 0, 1.0f);
    }

    public static BufferedImage decode(PdfObjectReader currentPdfFile, PdfObject XObject2, int subtype, int width, int height, int offsetImage, float pageScaling) {
        boolean useHires = true;
        currentPdfFile.checkResolved(XObject2);
        try {
            Graphics2D g2;
            BufferedImage aa;
            float scaling;
            PdfStreamDecoder glyphDecoder;
            T3Display glyphDisplay;
            ObjectStore localStore;
            block42: {
                localStore = new ObjectStore(null);
                glyphDisplay = new T3Display(0, false, 20, localStore);
                if (!useHires) {
                    glyphDisplay.setOptimisedRotation(false);
                } else {
                    glyphDisplay.setHiResImageForDisplayMode(useHires);
                }
                glyphDecoder = new PdfStreamDecoder(currentPdfFile, useHires, null);
                glyphDecoder.setParameters(false, true, 15, 0);
                glyphDecoder.setIntValue(-12, 1);
                glyphDecoder.setBooleanValue(-16, true);
                glyphDecoder.setObjectValue(-8, localStore);
                glyphDecoder.setObjectValue(23, glyphDisplay);
                try {
                    PdfObject Resources = XObject2.getDictionary(2004251818);
                    if (Resources != null) {
                        glyphDecoder.readResources(Resources, false);
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception " + e + " reading resources in XForm");
                    if (!LogWriter.isOutput()) break block42;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            byte[] commands = XObject2.getDecodedStream();
            if (commands != null) {
                glyphDecoder.decodeStreamIntoObjects(commands, false);
            }
            boolean ignoreColors = glyphDecoder.ignoreColors;
            localStore.flush();
            T3Glyph form = new T3Glyph(glyphDisplay, 0, 0, ignoreColors, "");
            float[] BBox = XObject2.getFloatArray(303185736);
            float rectX1 = 0.0f;
            float rectY1 = 0.0f;
            if (BBox != null) {
                float hs;
                float ws;
                float diff;
                int diffInt;
                int boxHeight;
                for (int ii = 0; ii < 4; ++ii) {
                    BBox[ii] = BBox[ii] * pageScaling;
                }
                rectX1 = BBox[0];
                rectY1 = BBox[1];
                int boxWidth = (int)(BBox[2] + 0.5f - BBox[0]);
                if (boxWidth < 0) {
                    boxWidth = -boxWidth;
                }
                if ((boxHeight = (int)(BBox[3] + 0.5f - BBox[1])) < 0) {
                    boxHeight = -boxHeight;
                }
                if (boxWidth == 0 && boxHeight > 0) {
                    boxWidth = 1;
                }
                if (boxWidth > 0 && boxHeight == 0) {
                    boxHeight = 1;
                }
                if ((diffInt = (int)(diff = (ws = (float)width / (float)boxWidth) - (hs = (float)height / (float)boxHeight))) != 0) {
                    int tmpI = width;
                    width = height;
                    height = tmpI;
                    ws = (float)width / (float)boxWidth;
                    hs = (float)height / (float)boxHeight;
                }
                if (ws < 1.0f || hs < 1.0f) {
                    scaling = 1.0f;
                    width = boxWidth;
                    height = boxHeight;
                } else {
                    if (ws > hs) {
                        scaling = ws;
                        height = (int)((float)boxHeight * scaling);
                    } else {
                        scaling = hs;
                        width = (int)((float)boxWidth * scaling);
                    }
                    rectX1 *= scaling;
                    rectY1 *= scaling;
                }
            } else {
                float hs;
                float ws;
                float defaultSize = 20.0f;
                if ((float)height < defaultSize) {
                    height = (int)defaultSize;
                }
                if ((float)width < defaultSize) {
                    width = (int)defaultSize;
                }
                if ((ws = (float)width / defaultSize) > (hs = (float)height / defaultSize)) {
                    scaling = ws;
                    height = (int)(defaultSize * scaling);
                } else {
                    scaling = hs;
                    width = (int)(defaultSize * scaling);
                }
                rectX1 *= scaling;
                rectY1 *= scaling;
            }
            if (width == 0 || height == 0) {
                return null;
            }
            if (scaling > 1.0f) {
                height += 2;
                width += 2;
            }
            if (offsetImage == 1) {
                width += 2;
                height += 2;
            }
            int offset = height;
            float[] matrix = XObject2.getFloatArray(1145198201);
            if (matrix != null) {
                float a = matrix[0];
                float b = matrix[1];
                float c = matrix[2];
                float d = matrix[3];
                float e = matrix[4] * scaling * pageScaling;
                float f = matrix[5] * scaling * pageScaling;
                if (c != 0.0f) {
                    aa = new BufferedImage(height, width, 2);
                    offset = width;
                } else {
                    aa = new BufferedImage(width, height, 2);
                    if (!(b < 0.0f)) {
                        if (e != 0.0f) {
                            e = -rectX1;
                        }
                        if (f != 0.0f) {
                            f = -rectY1;
                        }
                    }
                }
                g2 = (Graphics2D)aa.getGraphics();
                AffineTransform flip = new AffineTransform();
                flip.translate(0.0, offset);
                flip.scale(1.0, -1.0);
                g2.setTransform(flip);
                AffineTransform affineTransform = new AffineTransform(a, b, c, d, e, f);
                g2.transform(affineTransform);
            } else {
                aa = new BufferedImage(width, height, 2);
                g2 = (Graphics2D)aa.getGraphics();
                AffineTransform flip = new AffineTransform();
                flip.translate(0.0, offset);
                flip.scale(1.0, -1.0);
                g2.setTransform(flip);
            }
            if (offsetImage == 2) {
                g2.scale(-1.0, -1.0);
            } else if (offsetImage == 1) {
                g2.translate(1, 1);
            }
            if (subtype == 1919840408) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            form.render(0, g2, scaling * pageScaling, true);
            g2.dispose();
            return aa;
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            return null;
        }
        catch (Error e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Error: " + e.getMessage());
            }
            if (ExternalHandlers.throwMissingCIDError && e.getMessage().contains("kochi")) {
                throw e;
            }
            return null;
        }
    }

    public static BufferedImage rotate(BufferedImage src, int rotation) {
        BufferedImage dst;
        if (src == null) {
            return null;
        }
        if (rotation == 0) {
            return src;
        }
        try {
            double angle = (double)rotation * Math.PI / 180.0;
            int w = src.getWidth();
            int h = src.getHeight();
            int newW = (int)Math.round((double)h * Math.abs(Math.sin(angle)) + (double)w * Math.abs(Math.cos(angle)));
            int newH = (int)Math.round((double)h * Math.abs(Math.cos(angle)) + (double)w * Math.abs(Math.sin(angle)));
            AffineTransform at = AffineTransform.getTranslateInstance((newW - w) / 2, (newH - h) / 2);
            at.rotate(angle, w / 2, h / 2);
            dst = new BufferedImage(newW, newH, 2);
            Graphics2D g2 = dst.createGraphics();
            g2.drawRenderedImage(src, at);
            g2.dispose();
        }
        catch (Error e) {
            dst = null;
        }
        return dst;
    }

    public boolean hasXFADataSet() {
        return false;
    }

    public static void decodeFontCommandObj(String fontStream, FormObject formObject) {
        StringTokenizer tokens = new StringTokenizer(fontStream, "() []");
        int tokenCount = tokens.countTokens();
        String[] tokenValues = new String[tokenCount];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            tokenValues[i] = tokens.nextToken();
            ++i;
        }
        for (i = tokenCount - 1; i > -1; --i) {
            if (tokenValues[i].equals("g")) {
                --i;
                float col = 0.0f;
                try {
                    col = Float.parseFloat(FormStream.handleComma(tokenValues[i]));
                }
                catch (Exception e) {
                    LogWriter.writeLog("Error in generating g value " + tokenValues[i]);
                }
                formObject.setTextColor(new float[]{col});
                continue;
            }
            if (tokenValues[i].equals("Tf")) {
                --i;
                int textSize = 8;
                try {
                    textSize = (int)Float.parseFloat(FormStream.handleComma(tokenValues[i]));
                }
                catch (Exception e) {
                    LogWriter.writeLog("Error in generating Tf size " + tokenValues[i]);
                }
                --i;
                String font = null;
                try {
                    font = tokenValues[i];
                    if (font.startsWith("/")) {
                        font = font.substring(1);
                    }
                }
                catch (Exception e) {
                    LogWriter.writeLog("Error in generating Tf font " + tokenValues[i]);
                }
                PdfFont currentFont = new PdfFont();
                formObject.setTextFont(currentFont.setFont(font, textSize));
                formObject.setTextSize(textSize);
                continue;
            }
            if (tokenValues[i].equals("rg") || tokenValues[i].equals("r")) {
                float b = Float.parseFloat(FormStream.handleComma(tokenValues[--i]));
                float g = Float.parseFloat(FormStream.handleComma(tokenValues[--i]));
                float r = Float.parseFloat(FormStream.handleComma(tokenValues[--i]));
                formObject.setTextColor(new float[]{r, g, b});
                continue;
            }
            if (tokenValues[i].equals("Sig")) {
                LogWriter.writeFormLog("Sig-  UNIMPLEMENTED=" + fontStream + "< " + i, false);
                continue;
            }
            if (tokenValues[i].equals("\\n") || showFontMessage) continue;
            showFontMessage = true;
            LogWriter.writeFormLog("{stream} Unknown FONT command " + tokenValues[i] + ' ' + i + " string=" + fontStream, false);
        }
    }

    private static String handleComma(String tokenValue) {
        int comma = tokenValue.indexOf(44);
        if (comma != -1) {
            tokenValue = tokenValue.substring(0, comma);
        }
        return tokenValue;
    }

    public Node getXFA(int xfaTemplate) {
        throw new RuntimeException("getXFA Should never be called in base class");
    }
}

