/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.render.output.FontMapper;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class GenericFontMapper
implements FontMapper {
    private static final boolean STORE_UNIQUE_FONTS = false;
    private static final boolean DEBUG = false;
    private static boolean createXMLTemplate;
    private static final String DEFAULT_FONT = "DEFAULT_FONT";
    String style = "normal";
    String weight = "normal";
    String family = null;
    private String fontID;
    private int fontMode = 3;
    private boolean isFontEmbedded = false;
    private static Set<String> fontsInPdf;
    private static Map<String, String> userXMLTemplate;
    public static Map<String, String> fontMappings;
    public static Map<String, Integer> fontSizeAdjustments;
    private static Map<String, String> fontStyle;
    private static Map<String, String> fontWeight;
    private static String defaultFonts;
    private String rawFont;

    public GenericFontMapper(String rawFont) {
        this.init(rawFont);
        this.rawFont = rawFont;
    }

    public GenericFontMapper(String rawFont, int fontMode, boolean isFontEmbedded) {
        this.fontMode = fontMode;
        this.isFontEmbedded = isFontEmbedded;
        this.rawFont = rawFont;
        this.init(rawFont);
    }

    private void init(String rawFont) {
        String fontLessAttributes;
        if (this.fontMode == 6 || this.fontMode == 7) {
            this.fontID = rawFont;
            if (!this.isFontEmbedded || StandardFonts.isStandardFont(rawFont, true)) {
                int ptr = rawFont.indexOf(44);
                if (ptr == -1) {
                    ptr = rawFont.indexOf(45);
                }
                if (ptr == -1) {
                    for (int i = rawFont.length() - 1; i >= 0; --i) {
                        int pt = rawFont.codePointAt(i);
                        if (pt < 48 || pt > 57) continue;
                        if (i >= rawFont.length() - 1) break;
                        ptr = i - 1;
                        break;
                    }
                }
                if (ptr > 0) {
                    this.findAttributes(rawFont);
                }
            }
        } else if (!(this.directMapFont(rawFont) || this.mapFont(fontLessAttributes = this.findAttributes(rawFont)) || this.hasSimiliarMapping(fontLessAttributes))) {
            switch (this.fontMode) {
                case 3: {
                    this.fontID = DEFAULT_FONT;
                    break;
                }
                case 2: {
                    throw new RuntimeException("Font " + rawFont + " not mapped");
                }
            }
        }
        if (createXMLTemplate) {
            userXMLTemplate.put(rawFont, this.fontID);
        }
    }

    private String findAttributes(String rawFont) {
        String result = rawFont;
        int ptr = rawFont.indexOf(44);
        if (ptr == -1) {
            ptr = rawFont.indexOf(45);
        }
        if (ptr == -1) {
            for (int i = rawFont.length() - 1; i >= 0; --i) {
                int pt = rawFont.codePointAt(i);
                if (pt < 48 || pt > 57) continue;
                if (i >= rawFont.length() - 1) break;
                ptr = i - 1;
                break;
            }
        }
        if (ptr != -1) {
            String fontAttributes = rawFont.substring(ptr + 1, rawFont.length()).toLowerCase();
            this.family = result = rawFont.substring(0, ptr);
            boolean isFontExists = false;
            for (String k : fontMappings.keySet()) {
                if (!k.startsWith(this.family)) continue;
                isFontExists = true;
            }
            if (isFontExists || !this.isFontEmbedded) {
                if (fontAttributes.contains("heavy")) {
                    this.weight = "900";
                } else if (fontAttributes.endsWith("black")) {
                    this.weight = "bolder";
                } else if (fontAttributes.contains("light")) {
                    this.weight = "lighter";
                } else if (fontAttributes.contains("condensed")) {
                    this.weight = "100";
                } else if (fontAttributes.contains("bold")) {
                    this.weight = "bold";
                }
                if (fontAttributes.equals("it") || fontAttributes.contains("italic") || fontAttributes.contains("kursiv") || fontAttributes.contains("oblique")) {
                    this.style = "italic";
                }
            }
        }
        return result;
    }

    private boolean mapFont(String s) {
        if (fontMappings.get(s) != null) {
            this.fontID = s;
            return true;
        }
        return false;
    }

    private boolean directMapFont(String s) {
        boolean result = this.mapFont(s);
        if (!result) {
            return false;
        }
        if (fontStyle.containsKey(s)) {
            this.style = fontStyle.get(s);
        }
        if (fontWeight.containsKey(s)) {
            this.weight = fontWeight.get(s);
        }
        return true;
    }

    private boolean hasSimiliarMapping(String fontName) {
        Set<String> keySet = fontMappings.keySet();
        HashSet<String> candidates = new HashSet<String>();
        for (String key : keySet) {
            String lcFont;
            String lcKey = key.toLowerCase();
            if (lcKey.equals(lcFont = fontName.toLowerCase())) {
                this.fontID = key;
                return true;
            }
            if (!lcKey.contains(lcFont) && !lcFont.contains(lcKey)) continue;
            candidates.add(key);
        }
        if (!candidates.isEmpty()) {
            String[] result = new String[candidates.size()];
            result = candidates.toArray(result);
            this.fontID = result[0];
            if (candidates.size() > 1) {
                for (int i = 1; i < result.length; ++i) {
                    if (result[i].length() >= this.fontID.length()) continue;
                    this.fontID = result[i];
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getFont(boolean includeFamily) {
        String result = fontMappings.get(this.fontID);
        if (result == null && this.family != null && includeFamily) {
            result = fontMappings.get(this.family);
        }
        if (this.fontMode == 6 && result == null) {
            return this.rawFont;
        }
        if (this.isFontEmbedded && this.fontMode == 7 && result == null) {
            this.rawFont = this.rawFont.replaceAll("[.,*#]", "-");
            return this.rawFont;
        }
        if (result == null && (this.fontMode == 6 || this.fontMode == 7)) {
            this.rawFont = this.rawFont.replaceAll("[.,*#]", "-");
            return this.rawFont;
        }
        return result == null ? "" : result;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public String getWeight() {
        return this.weight;
    }

    @Override
    public int getFontSizeAdjustment() {
        int result = fontSizeAdjustments.get(this.fontID) != null ? fontSizeAdjustments.get(this.fontID) : 0;
        return result;
    }

    public static void loadCustomFontMappings(InputStream xmlFile) {
        block7: {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(xmlFile);
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getElementsByTagName("font");
                for (int i = 0; i < nList.getLength(); ++i) {
                    Node nNode = nList.item(i);
                    if (nNode.getNodeType() != 1) continue;
                    Element eElement = (Element)nNode;
                    String rawFont = GenericFontMapper.getTagValue("rawFont", eElement);
                    if (rawFont.length() == 0) {
                        throw new RuntimeException("A font element with no name?");
                    }
                    String tempSize = GenericFontMapper.getTagValue("sizeAdjust", eElement);
                    int sizeAdjust = tempSize.length() == 0 ? 0 : Integer.valueOf(tempSize);
                    String mapping = GenericFontMapper.getTagValue("mappedTo", eElement);
                    String style = GenericFontMapper.getTagValue("style", eElement);
                    String weight = GenericFontMapper.getTagValue("weight", eElement);
                    if (mapping.length() > 0) {
                        fontMappings.put(rawFont, mapping);
                    }
                    if (sizeAdjust != 0) {
                        fontSizeAdjustments.put(rawFont, sizeAdjust);
                    }
                    if (style.length() > 0) {
                        fontStyle.put(rawFont, style);
                    }
                    if (weight.length() <= 0) continue;
                    fontWeight.put(rawFont, weight);
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block7;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    private static String getTagValue(String tag, Element eElement) {
        Node nullCheck = eElement.getElementsByTagName(tag).item(0);
        if (nullCheck == null) {
            return "";
        }
        NodeList nlList = nullCheck.getChildNodes();
        Node nValue = nlList.item(0);
        return nValue != null ? nValue.getNodeValue() : "";
    }

    public static void showFoundFonts() {
        for (String rawFont : fontsInPdf) {
            System.out.println(rawFont);
        }
    }

    public static void setXMLTemplate(boolean b) {
        createXMLTemplate = b;
        userXMLTemplate = createXMLTemplate ? new HashMap<String, String>() : null;
    }

    public static void createXMLTemplate(String fileName) {
        block4: {
            if (userXMLTemplate == null) {
                throw new AssertionError((Object)"XML Template is null.");
            }
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element rootElement = document.createElement("fontMappings");
                document.appendChild(rootElement);
                for (String entry : userXMLTemplate.keySet()) {
                    Element fontRoot = document.createElement("font");
                    rootElement.appendChild(fontRoot);
                    Element e = document.createElement("rawFont");
                    fontRoot.appendChild(e);
                    Text n = document.createTextNode(entry);
                    e.appendChild(n);
                    e = document.createElement("sizeAdjust");
                    fontRoot.appendChild(e);
                    Integer size = fontSizeAdjustments.get(userXMLTemplate.get(entry));
                    n = document.createTextNode(size != null ? size.toString() : "");
                    e.appendChild(n);
                    e = document.createElement("mappedTo");
                    fontRoot.appendChild(e);
                    String mapping = fontMappings.get(userXMLTemplate.get(entry));
                    n = document.createTextNode(mapping != null ? mapping : "");
                    e.appendChild(n);
                    e = document.createElement("style");
                    fontRoot.appendChild(e);
                    String style = fontStyle.get(userXMLTemplate.get(entry));
                    n = document.createTextNode(style != null ? style : "");
                    e.appendChild(n);
                    e = document.createElement("weight");
                    fontRoot.appendChild(e);
                    String weight = fontWeight.get(userXMLTemplate.get(entry));
                    n = document.createTextNode(weight != null ? weight : "");
                    e.appendChild(n);
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(new File(fileName));
                transformer.transform(source, result);
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    public static void main(String[] argv) {
    }

    static {
        block4: {
            createXMLTemplate = false;
            fontsInPdf = new HashSet<String>();
            userXMLTemplate = null;
            fontMappings = new HashMap<String, String>();
            fontSizeAdjustments = new HashMap<String, Integer>();
            fontStyle = new HashMap<String, String>();
            fontWeight = new HashMap<String, String>();
            defaultFonts = "/org/jpedal/render/output/defaultFontMap.xml";
            String arialType = "Arial, Helvetica, sans-serif";
            String arialBlackType = "'Arial Black', Gadget, sans-serif";
            String comicSansType = "'Comic Sans MS', Textile, cursive";
            String courierNewType = "'Courier New', Courier, monospace";
            String georgiaType = "Georgia, 'Times New Roman', Times, serif";
            String impactType = "Impact, Charcoal, sans-serif";
            String lucidaConsoleType = "'Lucida Console', Monaco, monospace";
            String lucidaSansType = "'Lucida Sans Unicode', 'Lucida Grande', sans-serif";
            String palatinoType = "'Palatino Linotype', 'Book Antiqua', Palatino, serif";
            String tahomaType = "Tahoma, Geneva, sans-serif";
            String romanType = "'Times New Roman', Times, serif";
            String trebuchetType = "'Trebuchet MS', Helvetica, sans-serif";
            String verdanaType = "Verdana, Geneva, sans-serif";
            String symbolType = "Symbol";
            String webdingsType = "Webdings";
            String wingdingsType = "Wingdings, 'Zapf Dingbats'";
            String msSansSerifType = "'MS Sans Serif', Geneva, sans-serif";
            String msSerifType = "'MS Serif', 'New York', serif";
            String helveticaType = "Helvetica, Arial, sans-serif";
            if (fontMappings.keySet().isEmpty()) {
                fontMappings.put("Arial", arialType);
                fontMappings.put("ArialMT", arialType);
                fontMappings.put("ArialBlack", arialBlackType);
                fontMappings.put("ComicSansMS", comicSansType);
                fontMappings.put("CourierNew", courierNewType);
                fontMappings.put("Georgia", georgiaType);
                fontMappings.put("Impact", impactType);
                fontMappings.put("LucidaConsole", lucidaConsoleType);
                fontMappings.put("LucidaSansUnicode", lucidaSansType);
                fontMappings.put("PalatinoLinotype", palatinoType);
                fontMappings.put("Tahoma", tahomaType);
                fontMappings.put("TimesNewRoman", romanType);
                fontMappings.put("Times", romanType);
                fontMappings.put("Trebuchet", trebuchetType);
                fontMappings.put("Verdana", verdanaType);
                fontMappings.put("Symbol", symbolType);
                fontMappings.put("Webdings", webdingsType);
                fontMappings.put("Wingdings", wingdingsType);
                fontMappings.put("MSSansSerif", msSansSerifType);
                fontMappings.put("MSSerif", msSerifType);
                fontMappings.put("Helvetica", helveticaType);
                fontMappings.put("ZapfDingbats", wingdingsType);
                fontMappings.put(DEFAULT_FONT, romanType);
                fontSizeAdjustments.put(DEFAULT_FONT, -1);
            }
            try {
                InputStream defaultFile = GenericFontMapper.class.getResourceAsStream(defaultFonts);
                if (defaultFile != null) {
                    GenericFontMapper.loadCustomFontMappings(defaultFile);
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }
}

