/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.io;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.render.output.io.CustomIO;
import org.jpedal.utils.LogWriter;

public class DefaultIO
implements CustomIO {
    private BufferedWriter output = null;
    Map imagesWritten = new HashMap();

    @Override
    public void writeFont(String path, byte[] rawFontData) {
        block2: {
            try {
                BufferedOutputStream fontOutput = new BufferedOutputStream(new FileOutputStream(path));
                fontOutput.write(rawFontData);
                fontOutput.flush();
                fontOutput.close();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    @Override
    public void writeJS(String rootDir, InputStream url) throws IOException {
        String cssPath = rootDir + "/js";
        File cssDir = new File(cssPath);
        if (!cssDir.exists()) {
            cssDir.mkdirs();
        }
        BufferedInputStream stylesheet = new BufferedInputStream(url);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(rootDir + "/js/aform.js"));
        ObjectStore.copy(stylesheet, bos);
        bos.flush();
        bos.close();
        stylesheet.close();
    }

    @Override
    public void writeCSS(String rootDir, String fileName, StringBuilder css) {
        block3: {
            String cssPath = rootDir + fileName + '/';
            File cssDir = new File(cssPath);
            if (!cssDir.exists()) {
                cssDir.mkdirs();
            }
            try {
                BufferedOutputStream CSSOutput = new BufferedOutputStream(new FileOutputStream(cssPath + "styles.css"));
                CSSOutput.write(css.toString().getBytes());
                CSSOutput.flush();
                CSSOutput.close();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    @Override
    public boolean isOutputOpen() {
        return this.output != null;
    }

    @Override
    public void setupOutput(String path, boolean append, String encodingUsed) throws FileNotFoundException, UnsupportedEncodingException {
        this.output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path, append), encodingUsed));
    }

    @Override
    public void flush() {
        block2: {
            try {
                this.output.flush();
                this.output.close();
                this.imagesWritten.clear();
                this.output = null;
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    @Override
    public void writeString(String str) {
        block2: {
            try {
                this.output.write(str);
                this.output.write(10);
                this.output.flush();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    @Override
    public String writeImage(String rootDir, String path, BufferedImage image) {
        String file;
        block4: {
            file = path + this.getImageTypeUsed();
            String fullPath = rootDir + file;
            try {
                if (!JAIHelper.isJAIused()) {
                    ImageIO.write((RenderedImage)image, "PNG", new File(fullPath));
                } else {
                    JAIHelper.confirmJAIOnClasspath();
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(fullPath)));
                    ImageEncoder encoder = ImageCodec.createImageEncoder((String)"PNG", (OutputStream)bos, null);
                    encoder.encode((RenderedImage)image);
                    bos.close();
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return file;
    }

    @Override
    public String getImageTypeUsed() {
        return ".png";
    }
}

