/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.javafx;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jpedal.color.PdfPaint;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.render.ShapeFactory;
import org.jpedal.render.output.OutputShape;

public class JavaFXShape
extends OutputShape
implements ShapeFactory {
    private int windingRule = 1;

    public JavaFXShape(int cmd, int shapeCount, float scaling, Shape currentShape, GraphicsState gs, AffineTransform scalingTransform, Point2D midPoint, Rectangle cropBox, int currentColor, int dpCount, int pageRotation, PdfPageData pageData, int pageNumber, boolean includeClip) {
        super(cmd, scaling, currentShape, gs, scalingTransform, midPoint, cropBox, currentColor, dpCount, pageRotation, pageData, pageNumber, includeClip);
        this.shapeCount = shapeCount;
        this.windingRule = currentShape.getPathIterator(scalingTransform).getWindingRule();
        this.generateShapeFromG2Data(gs, scalingTransform, cropBox);
    }

    @Override
    protected void beginShape() {
        this.pathCommands.add("\n");
        this.pathCommands.add("\tPath path_" + this.shapeCount + " = new Path();");
        this.pathCommands.add("\tObservableList<PathElement> shape_" + this.shapeCount + " = path_" + this.shapeCount + ".getElements();");
        this.pathCommands.add("\taddToGroup.add(path_" + this.shapeCount + ");");
    }

    @Override
    protected void lineTo(double[] coords) {
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new LineTo(" + this.coordsToStringParam(coords, 2) + "));");
    }

    @Override
    protected void bezierCurveTo(double[] coords) {
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new CubicCurveTo(" + this.coordsToStringParam(coords, 6) + "));");
    }

    @Override
    protected void quadraticCurveTo(double[] coords) {
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new QuadCurveTo(" + this.coordsToStringParam(coords, 4) + "));");
    }

    @Override
    protected void moveTo(double[] coords) {
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new MoveTo(" + this.coordsToStringParam(coords, 2) + "));");
    }

    @Override
    protected void closePath() {
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new ClosePath());");
    }

    @Override
    protected void drawCropBox() {
        this.pathCommands.clear();
        this.pathCommands.add("\n\t\t/**");
        this.pathCommands.add("\t* Crop Box properties");
        this.pathCommands.add("\t*/ ");
        this.pathCommands.add("\tPath path_" + this.shapeCount + " = new Path();");
        this.pathCommands.add("\tObservableList<PathElement> shape_" + this.shapeCount + " = path_" + this.shapeCount + ".getElements();");
        this.pathCommands.add("\taddToGroup.add(path_" + this.shapeCount + ");");
        double[] coords = new double[]{this.cropBox.x, this.cropBox.y};
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new MoveTo(" + this.convertCoords(coords, 2) + "));");
        coords[0] = coords[0] + (double)this.cropBox.width;
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new LineTo(" + this.convertCoords(coords, 2) + "));");
        coords[1] = coords[1] + (double)this.cropBox.height;
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new LineTo(" + this.convertCoords(coords, 2) + "));");
        coords[0] = coords[0] - (double)this.cropBox.width;
        this.pathCommands.add("\tshape_" + this.shapeCount + ".add(new LineTo(" + this.convertCoords(coords, 2) + "));");
    }

    @Override
    protected void applyGraphicsStateToPath(GraphicsState gs) {
        int fillType = gs.getFillType();
        if (fillType == 2 || fillType == 3) {
            float fillOpacity;
            PdfPaint col = gs.getNonstrokeColor();
            if (this.windingRule == 0) {
                this.pathCommands.add("\tpath_" + this.shapeCount + ".setFillRule(FillRule.EVEN_ODD);");
            }
            if ((fillOpacity = gs.getAlpha(2)) != 1.0f) {
                this.pathCommands.add("\tpath_" + this.shapeCount + ".setOpacity(" + fillOpacity + ");");
            }
            this.pathCommands.add("\tpath_" + this.shapeCount + ".setStroke(null);");
            this.pathCommands.add("\tpath_" + this.shapeCount + ".setFill(Color." + JavaFXShape.rgbToCSSColor(col.getRGB()) + ");");
            this.currentColor = col.getRGB();
        }
        if (fillType == 1 || fillType == 3) {
            BasicStroke stroke = (BasicStroke)gs.getStroke();
            float strokeOpacity = gs.getAlpha(1);
            if (strokeOpacity != 1.0f) {
                this.pathCommands.add("\tpath_" + this.shapeCount + ".setOpacity(" + strokeOpacity + ");");
            }
            if (gs.getOutputLineWidth() != 1) {
                this.pathCommands.add("\tpath_" + this.shapeCount + ".setStrokeWidth(" + gs.getOutputLineWidth() + ");");
            }
            if (stroke.getMiterLimit() != 10.0f) {
                this.pathCommands.add("\tpath_" + this.shapeCount + ".setStrokeMiterLimit(" + (double)stroke.getLineWidth() * (double)this.scaling + ");");
            }
            this.pathCommands.add("\tpath_" + this.shapeCount + ".setStrokeLineCap(StrokeLineCap." + JavaFXShape.determineLineCap(stroke) + ");");
            this.pathCommands.add("\tpath_" + this.shapeCount + ".setStrokeLineJoin(StrokeLineJoin." + JavaFXShape.determineLineJoin(stroke) + ");");
            PdfPaint col = gs.getStrokeColor();
            this.pathCommands.add("\tpath_" + this.shapeCount + ".setStroke(Color." + JavaFXShape.rgbToCSSColor(col.getRGB()) + ");");
        }
    }

    protected static String determineLineCap(BasicStroke stroke) {
        String attribute;
        switch (stroke.getEndCap()) {
            case 1: {
                attribute = "ROUND";
                break;
            }
            case 2: {
                attribute = "SQUARE";
                break;
            }
            default: {
                attribute = "BUTT";
            }
        }
        return attribute;
    }

    protected static String determineLineJoin(BasicStroke stroke) {
        String attribute;
        switch (stroke.getLineJoin()) {
            case 1: {
                attribute = "ROUND";
                break;
            }
            case 2: {
                attribute = "BEVEL";
                break;
            }
            default: {
                attribute = "MITER";
            }
        }
        return attribute;
    }

    @Override
    public void setShapeNumber(int shapeCount) {
        this.shapeCount = shapeCount;
    }
}

