/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

public class XFAUtils {
    public static double convertToMilliPoints(String str) {
        str = str.toLowerCase();
        double retValue = 0.0;
        retValue = Double.parseDouble(str.substring(0, str.length() - 2));
        if (str != null) {
            if (str.contains("pt")) {
                retValue *= 1000.0;
            } else if (str.contains("mm")) {
                retValue *= 2834.64567;
            } else if (str.contains("cm")) {
                retValue *= 28346.4567;
            } else if (str.contains("in")) {
                retValue *= 72000.0;
            } else if (str.contains("px")) {
                retValue *= retValue * 1000.0 * 0.0;
            } else {
                System.err.println("xfa value not found for " + str);
            }
        }
        return retValue;
    }

    public static double convertToPixels96(String str) {
        str = str.toLowerCase();
        double retValue = 0.0;
        retValue = Double.parseDouble(str.substring(0, str.length() - 2));
        if (str != null) {
            if (str.contains("pt")) {
                retValue *= 1.333333333;
            } else if (str.contains("mm")) {
                retValue *= 3.779527559;
            } else if (str.contains("cm")) {
                retValue *= 37.795275591;
            } else if (str.contains("in")) {
                retValue *= 96.0;
            } else if (str.contains("px")) {
                retValue *= 1.0;
            } else {
                System.err.println("xfa value not found for " + str);
            }
        }
        return retValue;
    }
}

