/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.PixelFactory;
import com.idrsolutions.pdf.color.shading.ShadingFactory;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;

public class AxialContext
implements PaintContext {
    private float maxPDFX = -9999.0f;
    private float maxPDFY = -9999.0f;
    private float minPDFX = 9999.0f;
    private float minPDFY = 9999.0f;
    GenericColorSpace shadingColorSpace;
    private float scaling = 1.0f;
    private final boolean[] isExtended;
    private final float x0;
    private final float x1;
    private final float y0;
    private final float y1;
    private final float t0;
    private float t1 = 1.0f;
    private final PDFFunction[] function;
    private final boolean isPrinting;
    private final int pageHeight;
    private final boolean colorsReversed;
    private final int minX;
    private final float[] background;
    private final float offX;
    private final float offY;
    int pageRotation;
    private final boolean isInverted;
    private int renderingType = 3;

    public AxialContext(AffineTransform xform, int renderingType, boolean isPrinting, int offX, int offY, int minX, int pHeight, float scaling, boolean[] isExtended, float[] domain, float[] coords, GenericColorSpace shadingColorSpace, boolean colorsReversed, float[] background, PDFFunction[] function) {
        double[] aff = new double[6];
        xform.getMatrix(aff);
        if (aff[0] == 0.0 && aff[1] > 0.0 && aff[2] > 0.0 && aff[3] == 0.0) {
            this.pageRotation = 90;
        }
        this.isInverted = renderingType == 8;
        this.renderingType = renderingType;
        this.isPrinting = isPrinting;
        this.offX = offX;
        this.offY = offY;
        this.colorsReversed = colorsReversed;
        this.pageHeight = pHeight;
        this.isExtended = isExtended;
        this.t0 = domain[0];
        this.t1 = domain[1];
        this.background = background;
        this.x0 = coords[0];
        this.x1 = coords[2];
        this.y0 = coords[1];
        this.y1 = coords[3];
        this.shadingColorSpace = shadingColorSpace;
        this.function = function;
        this.scaling = scaling;
        this.minX = minX;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int xstart, int ystart, int w, int h) {
        if (this.pageRotation == 90) {
            int tmp = xstart;
            xstart = ystart;
            ystart = tmp;
        }
        boolean isTooSmall = this.renderingType == 3 && ((float)w / this.scaling <= 1.0f || (float)h / this.scaling <= 1.0f);
        int rastSize = w * h * 4;
        int[] data = new int[rastSize];
        float lastT = -1.0f;
        float dx = this.x1 - this.x0;
        float dy = this.y1 - this.y0;
        float divisor = dx * dx + dy * dy;
        Color col0 = this.colorsReversed ? this.calculateColor(this.t1) : this.calculateColor(this.t0);
        int cr = col0.getRed();
        int cg = col0.getGreen();
        int cb = col0.getBlue();
        if (this.background != null) {
            this.shadingColorSpace.setColor(this.background, 4);
            Color c = (Color)((Object)this.shadingColorSpace.getColor());
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int base = (y * w + x) * 4;
                    data[base] = c.getRed();
                    data[base + 1] = c.getGreen();
                    data[base + 2] = c.getBlue();
                    data[base + 3] = 255;
                }
            }
        }
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                float[] xy = this.pageRotation != 90 ? PixelFactory.convertPhysicalToPDF(this.isPrinting, x, y, this.offX, this.offY, this.scaling, xstart, ystart, this.minX, this.pageHeight) : PixelFactory.convertPhysicalToPDF(this.isPrinting, y, x, this.offX, this.offY, this.scaling, xstart, ystart, this.minX, this.pageHeight);
                float pdfX = xy[0];
                float pdfY = this.isInverted ? -xy[1] : xy[1];
                float xx = isTooSmall ? 0.5f : (dx * (pdfX - this.x0) + dy * (pdfY - this.y0)) / divisor;
                float yDiff = this.y0 - this.y1;
                if (this.isPrinting && yDiff < 0.0f) {
                    xx = 1.0f - xx;
                }
                if (pdfX > this.maxPDFX) {
                    this.maxPDFX = pdfX;
                }
                if (pdfX < this.minPDFX) {
                    this.minPDFX = pdfX;
                }
                if (pdfY > this.maxPDFY) {
                    this.maxPDFY = pdfY;
                }
                if (pdfY < this.minPDFY) {
                    this.minPDFY = pdfY;
                }
                float t = xx < 0.0f && this.isExtended[0] ? this.t0 : (xx > 1.0f && this.isExtended[1] ? this.t1 : this.t0 + (this.t1 - this.t0) * xx);
                if (isTooSmall) {
                    t = 0.5f;
                }
                if (!(t >= this.t0) || !(t <= this.t1)) continue;
                if (this.colorsReversed) {
                    t = 1.0f - t;
                }
                if (t != lastT) {
                    lastT = t;
                    Color c = this.calculateColor(t);
                    cr = c.getRed();
                    cg = c.getGreen();
                    cb = c.getBlue();
                }
                int base = (y * w + x) * 4;
                data[base] = cr;
                data[base + 1] = cg;
                data[base + 2] = cb;
                data[base + 3] = 255;
            }
        }
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    private Color calculateColor(float val) {
        float[] colValues = ShadingFactory.applyFunctions(this.function, new float[]{val});
        this.shadingColorSpace.setColor(colValues, colValues.length);
        Color col = (Color)((Object)this.shadingColorSpace.getColor());
        return col;
    }
}

