/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.ByteBufferInputStream;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.PdfSubByteSampleModel;
import com.sun.pdfview.colorspace.IndexedColor;
import com.sun.pdfview.colorspace.PDFColorSpace;
import com.sun.pdfview.colorspace.YCCKColorSpace;
import com.sun.pdfview.decode.PDFDecoder;
import java.awt.Color;
import java.awt.Point;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PackedColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class PDFImage {
    private static int[][] GREY_TO_ARGB = new int[8][];
    private int[] colorKeyMask = null;
    private int width;
    private int height;
    private PDFColorSpace colorSpace;
    private int bpc;
    private boolean imageMask = false;
    private PDFImage sMask;
    private float[] decode;
    private float[] decodeMins;
    private float[] decodeCoefficients;
    private PDFObject imageObj;

    public static void dump(PDFObject pDFObject) throws IOException {
        PDFImage.p("dumping PDF object: " + pDFObject);
        if (pDFObject == null) {
            return;
        }
        HashMap<String, PDFObject> hashMap = pDFObject.getDictionary();
        PDFImage.p("   dict = " + hashMap);
        for (String string : hashMap.keySet()) {
            PDFImage.p("key = " + string + " value = " + hashMap.get(string));
        }
    }

    public static void p(String string) {
        System.out.println(string);
    }

    private static int[] getGreyToArgbMap(int n) {
        assert (n <= 8);
        int[] nArray = GREY_TO_ARGB[n - 1];
        if (nArray == null) {
            nArray = PDFImage.createGreyToArgbMap(n);
        }
        return nArray;
    }

    private static int[] createGreyToArgbMap(int n) {
        ColorSpace colorSpace = PDFColorSpace.getColorSpace(0).getColorSpace();
        byte[] byArray = new byte[1 << n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(i & 0xFF);
        }
        int[] nArray = new int[byArray.length];
        int n2 = (1 << n) - 1;
        WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferByte(byArray, byArray.length), byArray.length, 1, byArray.length, new int[]{n2}, null);
        BufferedImage bufferedImage = new BufferedImage(new PdfComponentColorModel(colorSpace, new int[]{n}), writableRaster, false, null);
        ColorModel colorModel = ColorModel.getRGBdefault();
        WritableRaster writableRaster2 = Raster.createPackedRaster(new DataBufferInt(nArray, nArray.length), nArray.length, 1, nArray.length, ((PackedColorModel)colorModel).getMasks(), null);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster2, false, null);
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, ColorSpace.getInstance(1000), null);
        colorConvertOp.filter(bufferedImage, bufferedImage2);
        PDFImage.GREY_TO_ARGB[n - 1] = nArray;
        return nArray;
    }

    protected PDFImage(PDFObject pDFObject) {
        this.imageObj = pDFObject;
    }

    public static PDFImage createImage(PDFObject pDFObject, Map map) throws IOException {
        Object object;
        Object object2;
        Object object3;
        PDFImage pDFImage = new PDFImage(pDFObject);
        PDFObject pDFObject2 = pDFObject.getDictRef("Width");
        if (pDFObject2 == null) {
            throw new PDFParseException("Unable to read image width: " + pDFObject);
        }
        pDFImage.setWidth(pDFObject2.getIntValue());
        PDFObject pDFObject3 = pDFObject.getDictRef("Height");
        if (pDFObject3 == null) {
            throw new PDFParseException("Unable to get image height: " + pDFObject);
        }
        pDFImage.setHeight(pDFObject3.getIntValue());
        PDFObject pDFObject4 = pDFObject.getDictRef("ImageMask");
        if (pDFObject4 != null) {
            pDFImage.setImageMask(pDFObject4.getBooleanValue());
        }
        if (pDFImage.isImageMask()) {
            float f;
            pDFImage.setBitsPerComponent(1);
            object3 = new Color[]{Color.BLACK, Color.WHITE};
            object2 = pDFObject.getDictRef("Decode");
            if (object2 != null && (f = (object = ((PDFObject)object2).getArray())[0].getFloatValue()) == 1.0f) {
                object3 = new Color[]{Color.WHITE, Color.BLACK};
            }
            pDFImage.setColorSpace(new IndexedColor((Color[])object3));
        } else {
            object3 = pDFObject.getDictRef("BitsPerComponent");
            if (object3 == null) {
                throw new PDFParseException("Unable to get bits per component: " + pDFObject);
            }
            pDFImage.setBitsPerComponent(((PDFObject)object3).getIntValue());
            object2 = pDFObject.getDictRef("ColorSpace");
            if (object2 == null) {
                throw new PDFParseException("No ColorSpace for image: " + pDFObject);
            }
            object = PDFColorSpace.getColorSpace((PDFObject)object2, map);
            pDFImage.setColorSpace((PDFColorSpace)object);
        }
        object3 = pDFObject.getDictRef("Decode");
        if (object3 != null) {
            object2 = ((PDFObject)object3).getArray();
            object = new float[((PDFObject[])object2).length];
            for (int i = 0; i < ((PDFObject[])object2).length; ++i) {
                object[i] = (PDFObject)((PDFObject)object2[i]).getFloatValue();
            }
            pDFImage.setDecode((float[])object);
        }
        if (pDFObject4 == null) {
            object2 = pDFObject.getDictRef("SMask");
            if (object2 == null) {
                object2 = pDFObject.getDictRef("Mask");
            }
            if (object2 != null) {
                if (((PDFObject)object2).getType() == 7) {
                    try {
                        object = PDFImage.createImage((PDFObject)object2, map);
                        pDFImage.setSMask((PDFImage)object);
                    }
                    catch (IOException iOException) {
                        PDFImage.p("ERROR: there was a problem parsing the mask for this object");
                        PDFImage.dump(pDFObject);
                        iOException.printStackTrace(System.out);
                    }
                } else if (((PDFObject)object2).getType() == 5) {
                    try {
                        pDFImage.setColorKeyMask((PDFObject)object2);
                    }
                    catch (IOException iOException) {
                        PDFImage.p("ERROR: there was a problem parsing the color mask for this object");
                        PDFImage.dump(pDFObject);
                        iOException.printStackTrace(System.out);
                    }
                }
            }
        }
        return pDFImage;
    }

    public BufferedImage getImage() {
        try {
            BufferedImage bufferedImage = (BufferedImage)this.imageObj.getCache();
            if (bufferedImage == null) {
                byte[] byArray = null;
                ByteBuffer byteBuffer = null;
                boolean bl = PDFDecoder.isLastFilter(this.imageObj, PDFDecoder.DCT_FILTERS);
                if (bl) {
                    byteBuffer = this.imageObj.getStreamBuffer(PDFDecoder.DCT_FILTERS);
                } else {
                    byArray = this.imageObj.getStream();
                }
                bufferedImage = this.parseData(byArray, byteBuffer);
                this.imageObj.setCache(bufferedImage);
            }
            return bufferedImage;
        }
        catch (IOException iOException) {
            System.out.println("Error reading image");
            iOException.printStackTrace();
            return null;
        }
    }

    protected BufferedImage parseData(byte[] byArray, ByteBuffer byteBuffer) throws IOException {
        Transparency transparency;
        Object object;
        Object object2;
        Object object3;
        ColorModel colorModel = this.createColorModel();
        BufferedImage bufferedImage = null;
        if (byteBuffer != null) {
            byteBuffer.mark();
            object3 = new JpegDecoder(byteBuffer, colorModel);
            object2 = null;
            try {
                bufferedImage = ((JpegDecoder)object3).decode();
            }
            catch (IIOException iIOException) {
                object2 = iIOException;
                ((JpegDecoder)object3).setYcckDecodeMode(true);
                try {
                    bufferedImage = ((JpegDecoder)object3).decode();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            colorModel = ((JpegDecoder)object3).getColorModel();
            byteBuffer = null;
            object3 = null;
            if (bufferedImage == null) {
                assert (object2 != null);
                throw new IIOException(((Throwable)object2).getMessage() + ". Maybe installing JAI for expanded image format " + "support would help?", (Throwable)object2);
            }
        } else {
            int n;
            object3 = new DataBufferByte(byArray, byArray.length);
            object2 = colorModel.createCompatibleSampleModel(this.getWidth(), this.getHeight());
            try {
                object = Raster.createWritableRaster((SampleModel)object2, (DataBuffer)object3, new Point(0, 0));
            }
            catch (RasterFormatException rasterFormatException) {
                n = this.getWidth() * this.getColorSpace().getNumComponents() * this.getBitsPerComponent();
                int n2 = n + 0;
                int n3 = n2 * this.getHeight();
                if (n3 > byArray.length) {
                    byte[] byArray2 = new byte[n3];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    object3 = new DataBufferByte(byArray2, n3);
                    object = Raster.createWritableRaster((SampleModel)object2, (DataBuffer)object3, new Point(0, 0));
                }
                throw rasterFormatException;
            }
            if (colorModel instanceof IndexColorModel) {
                transparency = (IndexColorModel)colorModel;
                n = 12;
                if (this.getBitsPerComponent() == 8) {
                    n = 13;
                }
                bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), n, (IndexColorModel)transparency);
                bufferedImage.setData((Raster)object);
            } else {
                bufferedImage = new BufferedImage(colorModel, (WritableRaster)object, true, null);
            }
        }
        object3 = colorModel.getColorSpace();
        object2 = ColorSpace.getInstance(1000);
        if (this.isGreyscale((ColorSpace)object3) && this.bpc <= 8 && this.getDecode() == null && byteBuffer == null) {
            bufferedImage = this.convertGreyscaleToArgb(byArray, bufferedImage);
        } else if (!this.isImageMask() && object3 instanceof ICC_ColorSpace && !object3.equals(object2) && !Boolean.getBoolean("PDFRenderer.avoidColorConvertOp")) {
            object = new ColorConvertOp((ColorSpace)object3, (ColorSpace)object2, null);
            transparency = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            bufferedImage = ((ColorConvertOp)object).filter(bufferedImage, (BufferedImage)transparency);
        }
        object = this.getSMask();
        if (object != null) {
            transparency = ((PDFImage)object).getImage();
            BufferedImage bufferedImage2 = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            int[] nArray = new int[this.width];
            int[] nArray2 = new int[this.width];
            for (int i = 0; i < this.height; ++i) {
                bufferedImage.getRGB(0, i, this.width, 1, nArray, 0, this.width);
                ((BufferedImage)transparency).getRGB(0, i, this.width, 1, nArray2, 0, this.width);
                for (int j = 0; j < this.width; ++j) {
                    int n = -16777216;
                    nArray2[j] = (nArray2[j] & 0xFF) << 24 | nArray[j] & ~n;
                }
                bufferedImage2.setRGB(0, i, this.width, 1, nArray2, 0, this.width);
            }
            bufferedImage = bufferedImage2;
        }
        return bufferedImage;
    }

    private boolean isGreyscale(ColorSpace colorSpace) {
        return colorSpace == PDFColorSpace.getColorSpace(0).getColorSpace();
    }

    private BufferedImage convertGreyscaleToArgb(byte[] byArray, BufferedImage bufferedImage) {
        int n;
        int[] nArray = new int[this.getWidth() * this.getHeight()];
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = 0;
        int[] nArray2 = PDFImage.getGreyToArgbMap(this.bpc);
        if (this.bpc == 1) {
            n = (this.getWidth() + 7) / 8;
            if (nArray2[0] == 0 && nArray2[1] == -1) {
                for (int i = 0; i < this.getHeight(); ++i) {
                    int n3 = i * n;
                    for (int j = 0; j < this.getWidth(); ++j) {
                        byte by = byArray[n3 + j / 8];
                        int n4 = by >> 7 - (j & 7) & 1;
                        nArray[n2] = 0xFF000000 | n4 - 1 ^ 0xFFFFFF;
                        ++n2;
                    }
                }
            } else {
                for (int i = 0; i < this.getHeight(); ++i) {
                    int n5 = i * n;
                    for (int j = 0; j < this.getWidth(); ++j) {
                        byte by = byArray[n5 + j / 8];
                        int n6 = by >> 7 - (j & 7) & 1;
                        nArray[n2] = nArray2[n6];
                        ++n2;
                    }
                }
            }
        } else {
            for (n = 0; n < this.getHeight(); ++n) {
                for (int i = 0; i < this.getWidth(); ++i) {
                    int n7 = writableRaster.getSample(i, n, 0);
                    nArray[n2] = nArray2[n7];
                    ++n2;
                }
            }
        }
        ColorModel colorModel = ColorModel.getRGBdefault();
        return new BufferedImage(colorModel, Raster.createPackedRaster(new DataBufferInt(nArray, nArray.length), this.getWidth(), this.getHeight(), this.getWidth(), ((PackedColorModel)colorModel).getMasks(), null), false, null);
    }

    public int getWidth() {
        return this.width;
    }

    protected void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    protected void setHeight(int n) {
        this.height = n;
    }

    private void setColorKeyMask(PDFObject pDFObject) throws IOException {
        PDFObject[] pDFObjectArray = pDFObject.getArray();
        this.colorKeyMask = null;
        int[] nArray = new int[pDFObjectArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = pDFObjectArray[i].getIntValue();
        }
        this.colorKeyMask = nArray;
    }

    protected PDFColorSpace getColorSpace() {
        return this.colorSpace;
    }

    protected void setColorSpace(PDFColorSpace pDFColorSpace) {
        this.colorSpace = pDFColorSpace;
    }

    protected int getBitsPerComponent() {
        return this.bpc;
    }

    protected void setBitsPerComponent(int n) {
        this.bpc = n;
    }

    public boolean isImageMask() {
        return this.imageMask;
    }

    public void setImageMask(boolean bl) {
        this.imageMask = bl;
    }

    public PDFImage getSMask() {
        return this.sMask;
    }

    protected void setSMask(PDFImage pDFImage) {
        this.sMask = pDFImage;
    }

    protected float[] getDecode() {
        return this.decode;
    }

    protected void setDecode(float[] fArray) {
        float f = (1 << this.getBitsPerComponent()) - 1;
        this.decode = fArray;
        this.decodeCoefficients = new float[fArray.length / 2];
        this.decodeMins = new float[fArray.length / 2];
        for (int i = 0; i < fArray.length; i += 2) {
            this.decodeMins[i / 2] = fArray[i];
            this.decodeCoefficients[i / 2] = (fArray[i + 1] - fArray[i]) / f;
        }
    }

    private ColorModel createColorModel() {
        PDFColorSpace pDFColorSpace = this.getColorSpace();
        if (pDFColorSpace instanceof IndexedColor) {
            int n;
            int n2;
            int n3;
            IndexedColor indexedColor = (IndexedColor)pDFColorSpace;
            byte[] byArray = indexedColor.getColorComponents();
            int n4 = indexedColor.getCount();
            if (this.decode != null) {
                byte[] byArray2 = new byte[byArray.length];
                for (int i = 0; i < n4; ++i) {
                    byte[] byArray3 = new byte[]{(byte)i};
                    float[] fArray = this.normalize(byArray3, null, 0);
                    n3 = (int)fArray[0];
                    byArray2[i * 3] = byArray[n3 * 3];
                    byArray2[i * 3 + 1] = byArray[n3 * 3 + 1];
                    byArray2[i * 3 + 2] = byArray[n3 * 3 + 2];
                }
                byArray = byArray2;
            }
            if ((n2 = 1 << this.getBitsPerComponent()) < n4) {
                byte[] byArray4 = new byte[n2 * 3];
                System.arraycopy(byArray, 0, byArray4, 0, n2 * 3);
                byArray = byArray4;
                n4 = n2;
            }
            if (this.colorKeyMask == null || this.colorKeyMask.length == 0) {
                return new IndexColorModel(this.getBitsPerComponent(), n4, byArray, 0, false);
            }
            byte[] byArray5 = new byte[n4 * 4];
            int n5 = 0;
            for (n = 0; n < n4; ++n) {
                byArray5[n5++] = byArray[n * 3];
                byArray5[n5++] = byArray[n * 3 + 1];
                byArray5[n5++] = byArray[n * 3 + 2];
                byArray5[n5++] = -1;
            }
            for (n = 0; n < this.colorKeyMask.length; n += 2) {
                for (n3 = this.colorKeyMask[n]; n3 <= this.colorKeyMask[n + 1]; ++n3) {
                    byArray5[n3 * 4 + 3] = 0;
                }
            }
            return new IndexColorModel(this.getBitsPerComponent(), n4, byArray5, 0, true);
        }
        int[] nArray = new int[pDFColorSpace.getNumComponents()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getBitsPerComponent();
        }
        return this.decode != null ? new DecodeComponentColorModel(pDFColorSpace.getColorSpace(), nArray) : new PdfComponentColorModel(pDFColorSpace.getColorSpace(), nArray);
    }

    private ColorModel createColorModel(PDFColorSpace pDFColorSpace) {
        if (pDFColorSpace instanceof IndexedColor) {
            int n;
            int n2;
            int n3;
            IndexedColor indexedColor = (IndexedColor)pDFColorSpace;
            byte[] byArray = indexedColor.getColorComponents();
            int n4 = indexedColor.getCount();
            if (this.decode != null) {
                byte[] byArray2 = new byte[byArray.length];
                for (int i = 0; i < n4; ++i) {
                    byte[] byArray3 = new byte[]{(byte)i};
                    float[] fArray = this.normalize(byArray3, null, 0);
                    n3 = (int)fArray[0];
                    byArray2[i * 3] = byArray[n3 * 3];
                    byArray2[i * 3 + 1] = byArray[n3 * 3 + 1];
                    byArray2[i * 3 + 2] = byArray[n3 * 3 + 2];
                }
                byArray = byArray2;
            }
            if ((n2 = 1 << this.getBitsPerComponent()) < n4) {
                byte[] byArray4 = new byte[n2 * 3];
                System.arraycopy(byArray, 0, byArray4, 0, n2 * 3);
                byArray = byArray4;
                n4 = n2;
            }
            if (this.colorKeyMask == null || this.colorKeyMask.length == 0) {
                return new IndexColorModel(this.getBitsPerComponent(), n4, byArray, 0, false);
            }
            byte[] byArray5 = new byte[n4 * 4];
            int n5 = 0;
            for (n = 0; n < n4; ++n) {
                byArray5[n5++] = byArray[n * 3];
                byArray5[n5++] = byArray[n * 3 + 1];
                byArray5[n5++] = byArray[n * 3 + 2];
                byArray5[n5++] = -1;
            }
            for (n = 0; n < this.colorKeyMask.length; n += 2) {
                for (n3 = this.colorKeyMask[n]; n3 <= this.colorKeyMask[n + 1]; ++n3) {
                    byArray5[n3 * 4 + 3] = 0;
                }
            }
            return new IndexColorModel(this.getBitsPerComponent(), n4, byArray5, 0, true);
        }
        int[] nArray = new int[pDFColorSpace.getNumComponents()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getBitsPerComponent();
        }
        return this.decode != null ? new DecodeComponentColorModel(pDFColorSpace.getColorSpace(), nArray) : new PdfComponentColorModel(pDFColorSpace.getColorSpace(), nArray);
    }

    private float[] normalize(byte[] byArray, float[] fArray, int n) {
        if (fArray == null) {
            fArray = new float[n + byArray.length];
        }
        switch (byArray.length) {
            case 4: {
                fArray[n + 3] = this.decodeMins[3] + (float)(byArray[3] & 0xFF) * this.decodeCoefficients[3];
            }
            case 3: {
                fArray[n + 2] = this.decodeMins[2] + (float)(byArray[2] & 0xFF) * this.decodeCoefficients[2];
            }
            case 2: {
                fArray[n + 1] = this.decodeMins[1] + (float)(byArray[1] & 0xFF) * this.decodeCoefficients[1];
            }
            case 1: {
                fArray[n] = this.decodeMins[0] + (float)(byArray[0] & 0xFF) * this.decodeCoefficients[0];
                break;
            }
            default: {
                throw new IllegalArgumentException("Someone needs to add support for more than 4 components");
            }
        }
        return fArray;
    }

    class DecodeComponentColorModel
    extends PdfComponentColorModel {
        DecodeComponentColorModel(ColorSpace colorSpace, int[] nArray) {
            super(colorSpace, nArray);
        }

        @Override
        public int getRGB(Object object) {
            float[] fArray;
            float[] fArray2 = fArray = this.getNormalizedComponents(object, null, 0);
            return this.getAlpha(object) << 24 | (int)(fArray2[0] * 255.0f + 0.5f) << 16 | (int)(fArray2[1] * 255.0f + 0.5f) << 8 | (int)(fArray2[2] * 255.0f + 0.5f);
        }

        @Override
        public float[] getNormalizedComponents(Object object, float[] fArray, int n) {
            return PDFImage.this.normalize((byte[])object, fArray, n);
        }
    }

    static class PdfComponentColorModel
    extends ComponentColorModel {
        int bitsPerComponent;

        public PdfComponentColorModel(ColorSpace colorSpace, int[] nArray) {
            super(colorSpace, nArray, false, false, 1, 0);
            this.pixel_bits = nArray.length * nArray[0];
            this.bitsPerComponent = nArray[0];
        }

        @Override
        public SampleModel createCompatibleSampleModel(int n, int n2) {
            if (this.bitsPerComponent >= 8) {
                assert (this.bitsPerComponent == 8 || this.bitsPerComponent == 16);
                int n3 = this.getNumComponents();
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = i;
                }
                return new PixelInterleavedSampleModel(this.getTransferType(), n, n2, n3, n * n3, nArray);
            }
            switch (this.getPixelSize()) {
                case 1: 
                case 2: 
                case 4: {
                    return new MultiPixelPackedSampleModel(this.getTransferType(), n, n2, this.getPixelSize());
                }
            }
            assert (this.getTransferType() == 0);
            return new PdfSubByteSampleModel(n, n2, this.getNumComponents(), this.bitsPerComponent);
        }

        @Override
        public boolean isCompatibleRaster(Raster raster) {
            if (this.bitsPerComponent < 8 || this.getNumComponents() == 1) {
                SampleModel sampleModel = raster.getSampleModel();
                return sampleModel.getSampleSize(0) == this.bitsPerComponent;
            }
            return super.isCompatibleRaster(raster);
        }
    }

    private class JpegDecoder {
        private ByteBuffer jpegData;
        private ColorModel cm;
        private boolean ycckDecodeMode = false;

        private JpegDecoder(ByteBuffer byteBuffer, ColorModel colorModel) {
            this.jpegData = byteBuffer;
            this.cm = colorModel;
        }

        public void setYcckDecodeMode(boolean bl) {
            this.ycckDecodeMode = bl;
        }

        public ColorModel getColorModel() {
            return this.cm;
        }

        private BufferedImage decode() throws IOException {
            Object object;
            Object object2;
            ImageReadParam imageReadParam = null;
            if (PDFImage.this.getDecode() != null) {
                imageReadParam = new ImageReadParam();
                object2 = this.cm.createCompatibleSampleModel(PDFImage.this.getWidth(), PDFImage.this.getHeight());
                object = Raster.createWritableRaster((SampleModel)object2, new Point(0, 0));
                imageReadParam.setDestination(new BufferedImage(this.cm, (WritableRaster)object, true, null));
            }
            object2 = ImageIO.getImageReadersByFormatName("jpeg");
            object = null;
            while (object2.hasNext()) {
                try {
                    ImageReader imageReader = object2.next();
                    imageReader.setInput(ImageIO.createImageInputStream(new ByteBufferInputStream(this.jpegData)), true, false);
                    try {
                        return this.readImage(imageReader, imageReadParam);
                    }
                    catch (Exception exception) {
                        if (exception instanceof IIOException) {
                            throw (IIOException)exception;
                        }
                        throw new IIOException("Internal reader error?", exception);
                    }
                }
                catch (IIOException iIOException) {
                    this.jpegData.reset();
                    object = iIOException;
                }
            }
            throw object;
        }

        private BufferedImage readImage(ImageReader imageReader, ImageReadParam imageReadParam) throws IOException {
            if (this.ycckDecodeMode) {
                Attr attr;
                Node node;
                Node node2;
                Node node3;
                IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
                if (iIOMetadata != null && (node3 = iIOMetadata.getAsTree("javax_imageio_1.0")) != null && (node2 = this.getChild(node3, "Chroma")) != null && (node = this.getChild(node2, "ColorSpaceType")) != null && (attr = (Attr)node.getAttributes().getNamedItem("name")) != null && "YCCK".equals(attr.getValue())) {
                    Raster raster = imageReader.readRaster(0, imageReadParam);
                    PDFImage.this.colorSpace = new PDFColorSpace(new YCCKColorSpace(PDFImage.this.colorSpace.getColorSpace()));
                    this.cm = PDFImage.this.createColorModel();
                    return new BufferedImage(this.cm, Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), null), true, null);
                }
                throw new IIOException("Not a YCCK image");
            }
            if (imageReadParam != null && imageReadParam.getDestination() != null) {
                return imageReader.read(0, imageReadParam);
            }
            return new BufferedImage(this.cm, imageReader.read(0, imageReadParam).getRaster(), true, null);
        }

        private Node getChild(Node node, String string) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node node2 = node.getChildNodes().item(i);
                if (!node2.getNodeName().equals(string)) continue;
                return node2;
            }
            return null;
        }
    }
}

