/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.colorspace;

import com.sun.pdfview.PDFObject;
import java.awt.color.ColorSpace;
import java.io.IOException;

public class LabColor
extends ColorSpace {
    float[] white = new float[]{1.0f, 1.0f, 1.0f};
    float[] black = new float[]{0.0f, 0.0f, 0.0f};
    float[] range = new float[]{-100.0f, 100.0f, -100.0f, 100.0f};
    static ColorSpace cie = ColorSpace.getInstance(1000);

    public LabColor(PDFObject pDFObject) throws IOException {
        super(1, 3);
        int n;
        PDFObject pDFObject2 = pDFObject.getDictRef("WhitePoint");
        if (pDFObject2 != null) {
            for (n = 0; n < 3; ++n) {
                this.white[n] = pDFObject2.getAt(n).getFloatValue();
            }
        }
        if ((pDFObject2 = pDFObject.getDictRef("BlackPoint")) != null) {
            for (n = 0; n < 3; ++n) {
                this.black[n] = pDFObject2.getAt(n).getFloatValue();
            }
        }
        if ((pDFObject2 = pDFObject.getDictRef("Range")) != null) {
            for (n = 0; n < 4; ++n) {
                this.range[n] = pDFObject2.getAt(n).getFloatValue();
            }
        }
    }

    @Override
    public int getNumComponents() {
        return 3;
    }

    public final float stage2(float f) {
        return f >= 0.20689656f ? f * f * f : 0.12841855f * (f - 0.13793103f);
    }

    @Override
    public float[] toRGB(float[] fArray) {
        if (fArray.length == 3) {
            float f = (fArray[0] + 16.0f) / 116.0f + fArray[1] / 500.0f;
            float f2 = (fArray[0] + 16.0f) / 116.0f;
            float f3 = (fArray[0] + 16.0f) / 116.0f - fArray[2] / 200.0f;
            float[] fArray2 = new float[]{this.white[0] * this.stage2(f), this.white[0] * this.stage2(f2), this.white[0] * this.stage2(f3)};
            float[] fArray3 = cie.fromCIEXYZ(fArray2);
            return fArray3;
        }
        return this.black;
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        return new float[3];
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        return new float[3];
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        return new float[3];
    }
}

