/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public class ASCII85Decode {
    private ByteBuffer buf;

    private ASCII85Decode(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
    }

    private int nextChar() {
        while (this.buf.remaining() > 0) {
            char c = (char)this.buf.get();
            if (PDFFile.isWhiteSpace(c)) continue;
            return c;
        }
        return -1;
    }

    private boolean decode5(ByteArrayOutputStream byteArrayOutputStream) throws PDFParseException {
        int n;
        int[] nArray = new int[5];
        for (n = 0; n < 5; ++n) {
            nArray[n] = this.nextChar();
            if (nArray[n] == 126) {
                if (this.nextChar() == 62) break;
                throw new PDFParseException("Bad character in ASCII85Decode: not ~>");
            }
            if (nArray[n] >= 33 && nArray[n] <= 117) {
                int n2 = n;
                nArray[n2] = nArray[n2] - 33;
                continue;
            }
            if (nArray[n] == 122) {
                if (n == 0) {
                    nArray[n] = 0;
                    n = 4;
                    continue;
                }
                throw new PDFParseException("Inappropriate 'z' in ASCII85Decode");
            }
            throw new PDFParseException("Bad character in ASCII85Decode: " + nArray[n] + " (" + (char)nArray[n] + ")");
        }
        if (n > 0) {
            --n;
        }
        int n3 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + nArray[2] * 85 * 85 + nArray[3] * 85 + nArray[4];
        for (int i = 0; i < n; ++i) {
            int n4 = 8 * (3 - i);
            byteArrayOutputStream.write((byte)(n3 >> n4 & 0xFF));
        }
        return n == 4;
    }

    private ByteBuffer decode() throws PDFParseException {
        this.buf.rewind();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (this.decode5(byteArrayOutputStream)) {
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public static ByteBuffer decode(ByteBuffer byteBuffer, PDFObject pDFObject) throws PDFParseException {
        ASCII85Decode aSCII85Decode = new ASCII85Decode(byteBuffer);
        return aSCII85Decode.decode();
    }
}

