/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decrypt;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.decrypt.PDFDecrypter;
import java.nio.ByteBuffer;
import java.util.Map;

public class CryptFilterDecrypter
implements PDFDecrypter {
    private Map<String, PDFDecrypter> decrypters;
    private PDFDecrypter defaultStreamDecrypter;
    private PDFDecrypter defaultStringDecrypter;

    public CryptFilterDecrypter(Map<String, PDFDecrypter> map, String string, String string2) throws PDFParseException {
        this.decrypters = map;
        assert (this.decrypters.containsKey("Identity")) : "Crypt Filter map does not contain required Identity filter";
        this.defaultStreamDecrypter = this.decrypters.get(string);
        if (this.defaultStreamDecrypter == null) {
            throw new PDFParseException("Unknown crypt filter specified as default for streams: " + string);
        }
        this.defaultStringDecrypter = this.decrypters.get(string2);
        if (this.defaultStringDecrypter == null) {
            throw new PDFParseException("Unknown crypt filter specified as default for strings: " + string2);
        }
    }

    @Override
    public ByteBuffer decryptBuffer(String string, PDFObject pDFObject, ByteBuffer byteBuffer) throws PDFParseException {
        PDFDecrypter pDFDecrypter;
        if (string == null) {
            pDFDecrypter = this.defaultStreamDecrypter;
        } else {
            pDFDecrypter = this.decrypters.get(string);
            if (pDFDecrypter == null) {
                throw new PDFParseException("Unknown CryptFilter: " + string);
            }
        }
        return pDFDecrypter.decryptBuffer(null, string != null ? null : pDFObject, byteBuffer);
    }

    @Override
    public String decryptString(int n, int n2, String string) throws PDFParseException {
        return this.defaultStringDecrypter.decryptString(n, n2, string);
    }

    @Override
    public boolean isEncryptionPresent() {
        for (PDFDecrypter pDFDecrypter : this.decrypters.values()) {
            if (!pDFDecrypter.isEncryptionPresent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEncryptionPresent(String string) {
        PDFDecrypter pDFDecrypter = this.decrypters.get(string);
        return pDFDecrypter != null && pDFDecrypter.isEncryptionPresent(string);
    }

    @Override
    public boolean isOwnerAuthorised() {
        for (PDFDecrypter pDFDecrypter : this.decrypters.values()) {
            if (!pDFDecrypter.isOwnerAuthorised()) continue;
            return true;
        }
        return false;
    }
}

