/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFShapeCmd;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class PDFGlyph {
    private char src;
    private String name;
    private Point2D advance;
    private GeneralPath shape;
    private PDFPage page;

    public PDFGlyph(char c, String string, GeneralPath generalPath, Point2D.Float float_) {
        this.shape = generalPath;
        this.advance = float_;
        this.src = c;
        this.name = string;
    }

    public PDFGlyph(char c, String string, PDFPage pDFPage, Point2D point2D) {
        this.page = pDFPage;
        this.advance = point2D;
        this.src = c;
        this.name = string;
    }

    public char getChar() {
        return this.src;
    }

    public String getName() {
        return this.name;
    }

    public GeneralPath getShape() {
        return this.shape;
    }

    public PDFPage getPage() {
        return this.page;
    }

    public Point2D addCommands(PDFPage pDFPage, AffineTransform affineTransform, int n) {
        if (this.shape != null) {
            GeneralPath generalPath = (GeneralPath)this.shape.createTransformedShape(affineTransform);
            pDFPage.addCommand(new PDFShapeCmd(generalPath, n));
        } else if (this.page != null) {
            pDFPage.addCommands(this.page, affineTransform);
        }
        return this.advance;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }
}

