/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.CMap;
import java.nio.ByteBuffer;

public class CMapFormat0
extends CMap {
    private byte[] glyphIndex;

    protected CMapFormat0(short s) {
        super((short)0, s);
        byte[] byArray = new byte[256];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)i;
        }
        this.setMap(byArray);
    }

    @Override
    public short getLength() {
        return 262;
    }

    @Override
    public byte map(byte by) {
        int n = 0xFF & by;
        return this.glyphIndex[n];
    }

    @Override
    public char map(char c) {
        if (c < '\u0000' || c > '\u00ff') {
            return '\u0000';
        }
        return (char)(this.map((byte)c) & 0xFF);
    }

    @Override
    public char reverseMap(short s) {
        for (int i = 0; i < this.glyphIndex.length; ++i) {
            if ((this.glyphIndex[i] & 0xFF) != s) continue;
            return (char)i;
        }
        return '\u0000';
    }

    public void setMap(byte[] byArray) {
        if (byArray.length != 256) {
            throw new IllegalArgumentException("Glyph map must be size 256!");
        }
        this.glyphIndex = byArray;
    }

    public void setMap(byte by, byte by2) {
        int n = 0xFF & by;
        this.glyphIndex[n] = by2;
    }

    protected byte[] getMap() {
        return this.glyphIndex;
    }

    @Override
    public ByteBuffer getData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(262);
        byteBuffer.putShort(this.getFormat());
        byteBuffer.putShort(this.getLength());
        byteBuffer.putShort(this.getLanguage());
        byteBuffer.put(this.getMap());
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public void setData(int n, ByteBuffer byteBuffer) {
        if (n != 262) {
            throw new IllegalArgumentException("Bad length for CMap format 0");
        }
        if (byteBuffer.remaining() != 256) {
            throw new IllegalArgumentException("Wrong amount of data for CMap format 0");
        }
        byte[] byArray = new byte[256];
        byteBuffer.get(byArray);
        this.setMap(byArray);
    }
}

