/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.CMap;
import com.sun.pdfview.font.ttf.TrueTypeTable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;

public class CmapTable
extends TrueTypeTable {
    private short version;
    private SortedMap<CmapSubtable, CMap> subtables;

    protected CmapTable() {
        super(1668112752);
        this.setVersion((short)0);
        this.subtables = Collections.synchronizedSortedMap(new TreeMap());
    }

    public void addCMap(short s, short s2, CMap cMap) {
        CmapSubtable cmapSubtable = new CmapSubtable(s, s2);
        this.subtables.put(cmapSubtable, cMap);
    }

    public CMap getCMap(short s, short s2) {
        CmapSubtable cmapSubtable = new CmapSubtable(s, s2);
        return (CMap)this.subtables.get(cmapSubtable);
    }

    public CMap[] getCMaps() {
        Collection<CMap> collection = this.subtables.values();
        CMap[] cMapArray = new CMap[collection.size()];
        collection.toArray(cMapArray);
        return cMapArray;
    }

    public void removeCMap(short s, short s2) {
        CmapSubtable cmapSubtable = new CmapSubtable(s, s2);
        this.subtables.remove(cmapSubtable);
    }

    @Override
    public void setData(ByteBuffer byteBuffer) {
        this.setVersion(byteBuffer.getShort());
        int n = byteBuffer.getShort();
        for (int i = 0; i < n; ++i) {
            short s = byteBuffer.getShort();
            short s2 = byteBuffer.getShort();
            int n2 = byteBuffer.getInt();
            byteBuffer.mark();
            byteBuffer.position(n2);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer.reset();
            try {
                CMap cMap = CMap.getMap(byteBuffer2);
                if (cMap == null) continue;
                this.addCMap(s, s2, cMap);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error reading map.  PlatformID=" + s + ", PlatformSpecificID=" + s2);
                System.out.println("Reason: " + exception);
            }
        }
    }

    @Override
    public ByteBuffer getData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getLength());
        byteBuffer.putShort(this.getVersion());
        byteBuffer.putShort((short)this.subtables.size());
        int n = 4 + this.subtables.size() * 8;
        for (CmapSubtable object : this.subtables.keySet()) {
            CMap cMap = (CMap)this.subtables.get(object);
            byteBuffer.putShort(object.platformID);
            byteBuffer.putShort(object.platformSpecificID);
            byteBuffer.putInt(n);
            n += cMap.getLength();
        }
        for (CMap cMap : this.subtables.values()) {
            byteBuffer.put(cMap.getData());
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public int getLength() {
        int n = 4;
        n += this.subtables.size() * 8;
        for (CMap cMap : this.subtables.values()) {
            n += cMap.getLength();
        }
        return n;
    }

    public short getVersion() {
        return this.version;
    }

    public void setVersion(short s) {
        this.version = s;
    }

    public short getNumberSubtables() {
        return (short)this.subtables.size();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "    ";
        stringBuffer.append(string + "Version: " + this.getVersion() + "\n");
        stringBuffer.append(string + "NumMaps: " + this.getNumberSubtables() + "\n");
        for (CmapSubtable cmapSubtable : this.subtables.keySet()) {
            stringBuffer.append(string + "Map: platformID: " + cmapSubtable.platformID + " PlatformSpecificID: " + cmapSubtable.platformSpecificID + "\n");
            CMap cMap = (CMap)this.subtables.get(cmapSubtable);
            stringBuffer.append(cMap.toString());
        }
        return stringBuffer.toString();
    }

    class CmapSubtable
    implements Comparable {
        short platformID;
        short platformSpecificID;

        protected CmapSubtable(short s, short s2) {
            this.platformID = s;
            this.platformSpecificID = s2;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int compareTo(Object object) {
            if (!(object instanceof CmapSubtable)) {
                return -1;
            }
            CmapSubtable cmapSubtable = (CmapSubtable)object;
            if (this.platformID < cmapSubtable.platformID) {
                return -1;
            }
            if (this.platformID > cmapSubtable.platformID) {
                return 1;
            }
            if (this.platformSpecificID < cmapSubtable.platformSpecificID) {
                return -1;
            }
            if (this.platformSpecificID > cmapSubtable.platformSpecificID) {
                return 1;
            }
            return 0;
        }
    }
}

