/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.HheaTable;
import com.sun.pdfview.font.ttf.MaxpTable;
import com.sun.pdfview.font.ttf.TrueTypeFont;
import com.sun.pdfview.font.ttf.TrueTypeTable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class HmtxTable
extends TrueTypeTable {
    short[] advanceWidths;
    short[] leftSideBearings;

    protected HmtxTable(TrueTypeFont trueTypeFont) {
        super(1752003704);
        MaxpTable maxpTable = (MaxpTable)trueTypeFont.getTable("maxp");
        int n = maxpTable.getNumGlyphs();
        HheaTable hheaTable = (HheaTable)trueTypeFont.getTable("hhea");
        int n2 = hheaTable.getNumOfLongHorMetrics();
        this.advanceWidths = new short[n2];
        this.leftSideBearings = new short[n];
    }

    public short getAdvance(int n) {
        if (n < this.advanceWidths.length) {
            return this.advanceWidths[n];
        }
        return this.advanceWidths[this.advanceWidths.length - 1];
    }

    public short getLeftSideBearing(int n) {
        return this.leftSideBearings[n];
    }

    @Override
    public ByteBuffer getData() {
        int n = this.getLength();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        for (int i = 0; i < this.leftSideBearings.length; ++i) {
            if (i < this.advanceWidths.length) {
                byteBuffer.putShort(this.advanceWidths[i]);
            }
            byteBuffer.putShort(this.leftSideBearings[i]);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public void setData(ByteBuffer byteBuffer) {
        int n;
        for (n = 0; n < this.leftSideBearings.length && byteBuffer.hasRemaining(); ++n) {
            if (n < this.advanceWidths.length) {
                this.advanceWidths[n] = byteBuffer.getShort();
            }
            this.leftSideBearings[n] = byteBuffer.getShort();
        }
        if (n < this.advanceWidths.length) {
            Arrays.fill(this.advanceWidths, n, this.advanceWidths.length - 1, (short)0);
        }
        if (n < this.leftSideBearings.length) {
            Arrays.fill(this.leftSideBearings, n, this.leftSideBearings.length - 1, (short)0);
        }
    }

    @Override
    public int getLength() {
        return this.advanceWidths.length * 2 + this.leftSideBearings.length * 2;
    }
}

