/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.function;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.function.FunctionType0;
import com.sun.pdfview.function.FunctionType2;
import com.sun.pdfview.function.FunctionType3;
import com.sun.pdfview.function.FunctionType4;
import java.io.IOException;

public abstract class PDFFunction {
    public static final int TYPE_0 = 0;
    public static final int TYPE_2 = 2;
    public static final int TYPE_3 = 3;
    public static final int TYPE_4 = 4;
    private int type;
    private float[] domain;
    private float[] range;

    protected PDFFunction(int n) {
        this.type = n;
    }

    public static PDFFunction getFunction(PDFObject pDFObject) throws IOException {
        PDFFunction pDFFunction;
        float[] fArray = null;
        float[] fArray2 = null;
        PDFObject pDFObject2 = pDFObject.getDictRef("FunctionType");
        if (pDFObject2 == null) {
            throw new PDFParseException("No FunctionType specified in function!");
        }
        int n = pDFObject2.getIntValue();
        PDFObject pDFObject3 = pDFObject.getDictRef("Domain");
        if (pDFObject3 == null) {
            throw new PDFParseException("No Domain specified in function!");
        }
        PDFObject[] pDFObjectArray = pDFObject3.getArray();
        fArray = new float[pDFObjectArray.length];
        for (int i = 0; i < pDFObjectArray.length; ++i) {
            fArray[i] = pDFObjectArray[i].getFloatValue();
        }
        PDFObject pDFObject4 = pDFObject.getDictRef("Range");
        if (pDFObject4 != null) {
            PDFObject[] pDFObjectArray2 = pDFObject4.getArray();
            fArray2 = new float[pDFObjectArray2.length];
            for (int i = 0; i < pDFObjectArray2.length; ++i) {
                fArray2[i] = pDFObjectArray2[i].getFloatValue();
            }
        }
        switch (n) {
            case 0: {
                if (pDFObject4 == null) {
                    throw new PDFParseException("No Range specified in Type 0 Function!");
                }
                pDFFunction = new FunctionType0();
                break;
            }
            case 2: {
                pDFFunction = new FunctionType2();
                break;
            }
            case 3: {
                pDFFunction = new FunctionType3();
                break;
            }
            case 4: {
                if (pDFObject4 == null) {
                    throw new PDFParseException("No Range specified in Type 4 Function!");
                }
                pDFFunction = new FunctionType4();
                break;
            }
            default: {
                throw new PDFParseException("Unsupported function type: " + n);
            }
        }
        pDFFunction.setDomain(fArray);
        if (fArray2 != null) {
            pDFFunction.setRange(fArray2);
        }
        pDFFunction.parse(pDFObject);
        return pDFFunction;
    }

    public int getType() {
        return this.type;
    }

    public int getNumInputs() {
        return this.domain.length / 2;
    }

    public int getNumOutputs() {
        if (this.range == null) {
            return 0;
        }
        return this.range.length / 2;
    }

    protected float getDomain(int n) {
        return this.domain[n];
    }

    protected void setDomain(float[] fArray) {
        this.domain = fArray;
    }

    protected float getRange(int n) {
        if (this.range == null) {
            if (n % 2 == 0) {
                return Float.MIN_VALUE;
            }
            return Float.MAX_VALUE;
        }
        return this.range[n];
    }

    protected void setRange(float[] fArray) {
        this.range = fArray;
    }

    public float[] calculate(float[] fArray) {
        float[] fArray2 = new float[this.getNumOutputs()];
        this.calculate(fArray, 0, fArray2, 0);
        return fArray2;
    }

    public float[] calculate(float[] fArray, int n, float[] fArray2, int n2) {
        int n3;
        if (fArray.length - n < this.getNumInputs()) {
            throw new IllegalArgumentException("Wrong number of inputs to function!");
        }
        if (this.range != null && fArray2.length - n2 < this.getNumOutputs()) {
            throw new IllegalArgumentException("Wrong number of outputs for function!");
        }
        for (n3 = 0; n3 < fArray.length; ++n3) {
            fArray[n3] = Math.max(fArray[n3], this.getDomain(2 * n3));
            fArray[n3] = Math.min(fArray[n3], this.getDomain(2 * n3 + 1));
        }
        this.doFunction(fArray, n, fArray2, n2);
        for (n3 = 0; this.range != null && n3 < fArray2.length; ++n3) {
            fArray2[n3] = Math.max(fArray2[n3], this.getRange(2 * n3));
            fArray2[n3] = Math.min(fArray2[n3], this.getRange(2 * n3 + 1));
        }
        return fArray2;
    }

    protected abstract void doFunction(float[] var1, int var2, float[] var3, int var4);

    protected abstract void parse(PDFObject var1) throws IOException;
}

