/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.pattern;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFPaint;
import com.sun.pdfview.PDFParser;
import com.sun.pdfview.PDFRenderer;
import com.sun.pdfview.pattern.PDFPattern;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PatternType1
extends PDFPattern {
    public static final int PAINT_COLORED = 1;
    public static final int PAINT_UNCOLORED = 2;
    public static final int TILE_CONSTANT = 1;
    public static final int TILE_NODISTORT = 2;
    public static final int TILE_FASTER = 3;
    private HashMap<String, PDFObject> resources;
    private int paintType;
    private int tilingType;
    private Rectangle2D bbox;
    private int xStep;
    private int yStep;
    private byte[] data;

    public PatternType1() {
        super(1);
    }

    @Override
    protected void parse(PDFObject pDFObject, Map map) throws IOException {
        this.data = pDFObject.getStream();
        this.resources = pDFObject.getDictRef("Resources").getDictionary();
        this.paintType = pDFObject.getDictRef("PaintType").getIntValue();
        this.tilingType = pDFObject.getDictRef("TilingType").getIntValue();
        this.bbox = PDFFile.parseNormalisedRectangle(pDFObject.getDictRef("BBox"));
        this.xStep = pDFObject.getDictRef("XStep").getIntValue();
        this.yStep = pDFObject.getDictRef("YStep").getIntValue();
    }

    @Override
    public PDFPaint getPaint(PDFPaint pDFPaint) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.getBBox().getMinX(), this.getBBox().getMinY(), this.getXStep(), this.getYStep());
        final PDFPage pDFPage = new PDFPage(this.getBBox(), 0);
        if (pDFPaint != null) {
            pDFPage.addFillPaint(pDFPaint);
            pDFPage.addStrokePaint(pDFPaint);
        }
        PDFParser pDFParser = new PDFParser(pDFPage, this.data, this.getResources());
        pDFParser.go(true);
        int n = (int)this.getBBox().getWidth();
        int n2 = (int)this.getBBox().getHeight();
        Paint paint = new Paint(){

            @Override
            public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, true, false, 3, 0);
                Rectangle2D rectangle2D2 = affineTransform.createTransformedShape(PatternType1.this.getBBox()).getBounds2D();
                double[] dArray = new double[]{PatternType1.this.getXStep(), PatternType1.this.getYStep()};
                affineTransform.deltaTransform(dArray, 0, dArray, 0, 1);
                int n = (int)Math.ceil(rectangle2D2.getWidth());
                int n2 = (int)Math.ceil(rectangle2D2.getHeight());
                BufferedImage bufferedImage = (BufferedImage)pDFPage.getImage(n, n2, null, null, false, true);
                return new Type1PaintContext(componentColorModel, rectangle2D2, (float)dArray[0], (float)dArray[1], bufferedImage.getData());
            }

            @Override
            public int getTransparency() {
                return 3;
            }
        };
        return new TilingPatternPaint(paint, this);
    }

    public HashMap<String, PDFObject> getResources() {
        return this.resources;
    }

    public int getPaintType() {
        return this.paintType;
    }

    public int getTilingType() {
        return this.tilingType;
    }

    public Rectangle2D getBBox() {
        return this.bbox;
    }

    public int getXStep() {
        return this.xStep;
    }

    public int getYStep() {
        return this.yStep;
    }

    class Type1PaintContext
    implements PaintContext {
        private ColorModel colorModel;
        private Rectangle2D bbox;
        private float xstep;
        private float ystep;
        private Raster data;

        Type1PaintContext(ColorModel colorModel, Rectangle2D rectangle2D, float f, float f2, Raster raster) {
            this.colorModel = colorModel;
            this.bbox = rectangle2D;
            this.xstep = f;
            this.ystep = f2;
            this.data = raster;
        }

        @Override
        public void dispose() {
            this.colorModel = null;
            this.bbox = null;
            this.data = null;
        }

        @Override
        public ColorModel getColorModel() {
            return this.colorModel;
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            ColorSpace colorSpace = this.getColorModel().getColorSpace();
            int n5 = colorSpace.getNumComponents();
            int[] nArray = new int[n3 * n4 * (n5 + 1)];
            int n6 = (int)Math.ceil(Math.abs(this.xstep));
            int n7 = (int)Math.ceil(Math.abs(this.ystep));
            int[] nArray2 = new int[n5 + 1];
            int[] nArray3 = new int[n5 + 1];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n8 = n + j - (int)Math.ceil(this.bbox.getX());
                    int n9 = n2 + i - (int)Math.ceil(this.bbox.getY());
                    n9 %= n7;
                    if ((n8 %= n6) < 0) {
                        n8 = n6 + n8;
                    }
                    if (n9 < 0) {
                        n9 = n7 + n9;
                    }
                    int[] nArray4 = nArray2;
                    if (n8 < this.data.getWidth() && n9 < this.data.getHeight()) {
                        nArray4 = this.data.getPixel(n8, n9, nArray3);
                    }
                    int n10 = (i * n3 + j) * (n5 + 1);
                    for (int k = 0; k < nArray4.length; ++k) {
                        nArray[n10 + k] = nArray4[k];
                    }
                }
            }
            WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            writableRaster.setPixels(0, 0, n3, n4, nArray);
            Raster raster = writableRaster.createTranslatedChild(n, n2);
            return raster;
        }
    }

    class TilingPatternPaint
    extends PDFPaint {
        private PatternType1 pattern;

        public TilingPatternPaint(Paint paint, PatternType1 patternType12) {
            super(paint);
            this.pattern = patternType12;
        }

        @Override
        public Rectangle2D fill(PDFRenderer pDFRenderer, Graphics2D graphics2D, GeneralPath generalPath) {
            AffineTransform affineTransform = graphics2D.getTransform();
            Shape shape = generalPath.createTransformedShape(affineTransform);
            pDFRenderer.push();
            pDFRenderer.setTransform(pDFRenderer.getInitialTransform());
            pDFRenderer.transform(this.pattern.getTransform());
            try {
                affineTransform = pDFRenderer.getTransform().createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
            shape = affineTransform.createTransformedShape(shape);
            graphics2D.setComposite(AlphaComposite.getInstance(3));
            graphics2D.setPaint(this.getPaint());
            graphics2D.fill(shape);
            pDFRenderer.pop();
            return generalPath.createTransformedShape(graphics2D.getTransform()).getBounds2D();
        }
    }
}

