/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.security.KeyStore;
import java.util.SortedSet;
import java.util.logging.Level;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import net.sf.jsignpdf.BasicSignerOptions;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.JTextAreaHandler;
import net.sf.jsignpdf.SignResultListener;
import net.sf.jsignpdf.SignerFileChooser;
import net.sf.jsignpdf.SignerLogic;
import net.sf.jsignpdf.TsaDialog;
import net.sf.jsignpdf.VisibleSignatureDialog;
import net.sf.jsignpdf.types.CertificationLevel;
import net.sf.jsignpdf.types.HashAlgorithm;
import net.sf.jsignpdf.types.PDFEncryption;
import net.sf.jsignpdf.types.PrintRight;
import net.sf.jsignpdf.utils.GuiUtils;
import net.sf.jsignpdf.utils.KeyStoreUtils;
import net.sf.jsignpdf.utils.PKCS11Utils;
import net.sf.jsignpdf.utils.PropertyProvider;
import org.apache.commons.lang3.StringUtils;

public class SignPdfForm
extends JFrame
implements SignResultListener {
    private static final long serialVersionUID = 1L;
    private SignerFileChooser fc = new SignerFileChooser();
    protected final PropertyProvider props = PropertyProvider.getInstance();
    private boolean autoclose = false;
    private BasicSignerOptions options = new BasicSignerOptions();
    private SignerLogic signerLogic = new SignerLogic(this.options);
    private VisibleSignatureDialog vsDialog = new VisibleSignatureDialog((Frame)this, true, this.options, this.fc);
    private TsaDialog tsaDialog = new TsaDialog((Frame)this, true, this.options);
    private JButton btnEncCertFile;
    private JButton btnInPdfFile;
    private JButton btnInfoClose;
    private JButton btnKeystoreFile;
    private JButton btnLoadAliases;
    private JButton btnOutPdfFile;
    private JButton btnRights;
    private JButton btnRightsOK;
    private JButton btnSignIt;
    private JButton btnTsaOcsp;
    private JButton btnVisibleSigSettings;
    private JComboBox cbAlias;
    private JComboBox cbCertLevel;
    private JComboBox cbHashAlgorithm;
    private JComboBox cbKeystoreType;
    private JComboBox cbPdfEncryption;
    private JComboBox cbPrinting;
    private JCheckBox chkbAdvanced;
    private JCheckBox chkbAllowAssembly;
    private JCheckBox chkbAllowCopy;
    private JCheckBox chkbAllowFillIn;
    private JCheckBox chkbAllowModifyAnnotations;
    private JCheckBox chkbAllowModifyContent;
    private JCheckBox chkbAllowScreenReaders;
    private JCheckBox chkbAppendSignature;
    private JCheckBox chkbStorePwd;
    private JCheckBox chkbVisibleSig;
    private JFrame infoDialog;
    private JScrollPane infoScrollPane;
    private JTextArea infoTextArea;
    private JLabel lblAlias;
    private JLabel lblCertLevel;
    private JLabel lblContact;
    private JLabel lblEncCertFile;
    private JLabel lblHashAlgorithm;
    private JLabel lblInPdfFile;
    private JLabel lblKeyPwd;
    private JLabel lblKeystoreFile;
    private JLabel lblKeystorePwd;
    private JLabel lblKeystoreType;
    private JLabel lblLocation;
    private JLabel lblOutPdfFile;
    private JLabel lblPdfEncryption;
    private JLabel lblPdfOwnerPwd;
    private JLabel lblPdfUserPwd;
    private JLabel lblPrinting;
    private JLabel lblReason;
    private JLabel lblRights;
    private JPasswordField pfKeyPwd;
    private JPasswordField pfKeystorePwd;
    private JPasswordField pfPdfOwnerPwd;
    private JPasswordField pfPdfUserPwd;
    private JDialog rightsDialog;
    private JTextField tfContact;
    private JTextField tfEncCertFile;
    private JTextField tfInPdfFile;
    private JTextField tfKeystoreFile;
    private JTextField tfLocation;
    private JTextField tfOutPdfFile;
    private JTextField tfReason;

    public SignPdfForm(int aCloseOperation) {
        this.initComponents();
        this.options.loadOptions();
        this.translateLabels();
        this.setDefaultCloseOperation(aCloseOperation);
        this.getRootPane().setDefaultButton(this.btnSignIt);
        URL tmpImgUrl = this.getClass().getResource("/net/sf/jsignpdf/signedpdf32.png");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(tmpImgUrl));
        this.infoDialog.setIconImage(this.getIconImage());
        this.infoDialog.getRootPane().setDefaultButton(this.btnInfoClose);
        this.infoDialog.pack();
        GuiUtils.center(this.infoDialog);
        this.rightsDialog.getRootPane().setDefaultButton(this.btnRightsOK);
        this.rightsDialog.pack();
        GuiUtils.center(this.rightsDialog);
        this.tsaDialog.pack();
        GuiUtils.center(this.tsaDialog);
        this.vsDialog.pack();
        GuiUtils.center(this.vsDialog);
        this.options.setListener(this);
        SortedSet<String> tmpKsTypes = KeyStoreUtils.getKeyStores();
        this.cbKeystoreType.setModel(new DefaultComboBoxModel<String>(tmpKsTypes.toArray(new String[tmpKsTypes.size()])));
        if (tmpKsTypes.contains("WINDOWS-MY")) {
            this.cbKeystoreType.setSelectedItem("WINDOWS-MY");
        }
        this.cbPdfEncryption.setModel(new DefaultComboBoxModel<PDFEncryption>(PDFEncryption.values()));
        this.cbCertLevel.setModel(new DefaultComboBoxModel<CertificationLevel>(CertificationLevel.values()));
        this.cbHashAlgorithm.setModel(new DefaultComboBoxModel<HashAlgorithm>(HashAlgorithm.values()));
        this.cbPrinting.setModel(new DefaultComboBoxModel<PrintRight>(PrintRight.values()));
        JTextAreaHandler handler = new JTextAreaHandler(this.infoTextArea);
        handler.setLevel(Level.ALL);
        Constants.LOGGER.addHandler(handler);
        this.updateFromOptions();
    }

    private void translateLabels() {
        this.setTitle(Constants.RES.get("gui.title", Constants.VERSION));
        this.setLabelAndMnemonic(this.lblKeystoreType, "gui.keystoreType.label");
        this.setLabelAndMnemonic(this.chkbAdvanced, "gui.advancedView.checkbox");
        this.setLabelAndMnemonic(this.lblKeystoreFile, "gui.keystoreFile.label");
        this.setLabelAndMnemonic(this.lblKeystorePwd, "gui.keystorePassword.label");
        this.setLabelAndMnemonic(this.chkbStorePwd, "gui.storePasswords.checkbox");
        this.setLabelAndMnemonic(this.lblAlias, "gui.alias.label");
        this.setLabelAndMnemonic(this.btnLoadAliases, "gui.loadAliases.button");
        this.setLabelAndMnemonic(this.lblKeyPwd, "gui.keyPassword.label");
        this.setLabelAndMnemonic(this.lblInPdfFile, "gui.inPdfFile.label");
        this.setLabelAndMnemonic(this.btnRights, "gui.rights.button");
        this.setLabelAndMnemonic(this.lblPdfEncryption, "gui.pdfEncryption.label");
        this.setLabelAndMnemonic(this.lblPdfOwnerPwd, "gui.pdfOwnerPwd.label");
        this.setLabelAndMnemonic(this.lblPdfUserPwd, "gui.pdfUserPwd.label");
        this.setLabelAndMnemonic(this.lblEncCertFile, "gui.encryptionCertFile.label");
        this.setLabelAndMnemonic(this.lblOutPdfFile, "gui.outPdfFile.label");
        this.setLabelAndMnemonic(this.lblReason, "gui.reason.label");
        this.setLabelAndMnemonic(this.lblLocation, "gui.location.label");
        this.setLabelAndMnemonic(this.lblContact, "gui.contact.label");
        this.setLabelAndMnemonic(this.lblCertLevel, "gui.certLevel.label");
        this.setLabelAndMnemonic(this.chkbAppendSignature, "gui.appendSignature.checkbox");
        this.setLabelAndMnemonic(this.lblHashAlgorithm, "gui.hashAlgorithm.label");
        this.btnKeystoreFile.setText(Constants.RES.get("gui.browse.button"));
        this.btnEncCertFile.setText(Constants.RES.get("gui.browse.button"));
        this.btnInPdfFile.setText(Constants.RES.get("gui.browse.button"));
        this.btnOutPdfFile.setText(Constants.RES.get("gui.browse.button"));
        this.setLabelAndMnemonic(this.btnSignIt, "gui.signIt.button");
        this.infoDialog.setTitle(Constants.RES.get("gui.info.title"));
        this.btnInfoClose.setText(Constants.RES.get("gui.info.close.button"));
        this.rightsDialog.setTitle(Constants.RES.get("gui.rights.title"));
        this.setLabelAndMnemonic(this.lblPrinting, "gui.rights.printing.label");
        this.setLabelAndMnemonic(this.lblRights, "gui.rights.rights.label");
        this.setLabelAndMnemonic(this.chkbAllowCopy, "gui.rights.copy.checkbox");
        this.setLabelAndMnemonic(this.chkbAllowAssembly, "gui.rights.assembly.checkbox");
        this.setLabelAndMnemonic(this.chkbAllowFillIn, "gui.rights.fillIn.checkbox");
        this.setLabelAndMnemonic(this.chkbAllowScreenReaders, "gui.rights.screenReaders.checkbox");
        this.setLabelAndMnemonic(this.chkbAllowModifyAnnotations, "gui.rights.modifyAnnotations.checkbox");
        this.setLabelAndMnemonic(this.chkbAllowModifyContent, "gui.rights.modifyContents.checkbox");
        this.setLabelAndMnemonic(this.chkbVisibleSig, "gui.visibleSignature.checkbox");
        this.setLabelAndMnemonic(this.btnVisibleSigSettings, "gui.visibleSignatureSettings.button");
        this.setLabelAndMnemonic(this.btnTsaOcsp, "gui.tsaOcsp.button");
    }

    private void setLabelAndMnemonic(JComponent aComponent, String aKey) {
        Constants.RES.setLabelAndMnemonic(aComponent, aKey);
    }

    private void updateFromOptions() {
        if (StringUtils.isNotEmpty(this.options.getKsType())) {
            this.cbKeystoreType.setSelectedItem(this.options.getKsType());
        } else if (this.cbKeystoreType.getSelectedItem() == null) {
            this.cbKeystoreType.setSelectedItem(KeyStore.getDefaultType());
        }
        this.chkbAdvanced.setSelected(this.options.isAdvanced());
        this.tfKeystoreFile.setText(this.options.getKsFile());
        this.pfKeystorePwd.setText(this.options.getKsPasswdStr());
        this.chkbStorePwd.setSelected(this.options.isStorePasswords());
        this.cbAlias.setSelectedItem(this.options.getKeyAlias());
        this.pfKeyPwd.setText(this.options.getKeyPasswdStr());
        this.tfInPdfFile.setText(this.options.getInFile());
        this.cbPdfEncryption.setSelectedItem((Object)this.options.getPdfEncryption());
        this.pfPdfOwnerPwd.setText(this.options.getPdfOwnerPwdStr());
        this.pfPdfUserPwd.setText(this.options.getPdfUserPwdStr());
        this.tfEncCertFile.setText(this.options.getPdfEncryptionCertFile());
        this.tfOutPdfFile.setText(this.options.getOutFile());
        this.tfReason.setText(this.options.getReason());
        this.tfLocation.setText(this.options.getLocation());
        this.tfContact.setText(this.options.getContact());
        this.cbCertLevel.setSelectedItem((Object)this.options.getCertLevel());
        this.cbHashAlgorithm.setSelectedItem((Object)this.options.getHashAlgorithm());
        this.chkbAppendSignature.setSelected(this.options.isAppend());
        this.cbPrinting.setSelectedItem((Object)this.options.getRightPrinting());
        this.chkbAllowCopy.setSelected(this.options.isRightCopy());
        this.chkbAllowAssembly.setSelected(this.options.isRightAssembly());
        this.chkbAllowFillIn.setSelected(this.options.isRightFillIn());
        this.chkbAllowScreenReaders.setSelected(this.options.isRightScreanReaders());
        this.chkbAllowModifyAnnotations.setSelected(this.options.isRightModifyAnnotations());
        this.chkbAllowModifyContent.setSelected(this.options.isRightModifyContents());
        this.chkbVisibleSig.setSelected(this.options.isVisible());
        this.refreshView();
        this.pack();
    }

    private void storeToOptions() {
        this.options.setKsType((String)this.cbKeystoreType.getSelectedItem());
        this.options.setAdvanced(this.chkbAdvanced.isSelected());
        this.options.setKsFile(this.tfKeystoreFile.getText());
        this.options.setKsPasswd(this.pfKeystorePwd.getPassword());
        this.options.setStorePasswords(this.chkbStorePwd.isSelected());
        if (this.cbAlias.getSelectedItem() != this.options.getKeyAlias() || this.cbAlias.getSelectedIndex() > -1) {
            this.options.setKeyAlias((String)this.cbAlias.getSelectedItem());
            this.options.setKeyIndex(this.cbAlias.getSelectedIndex());
        }
        this.options.setKeyPasswd(this.pfKeyPwd.getPassword());
        this.options.setInFile(this.tfInPdfFile.getText());
        this.options.setPdfEncryption((PDFEncryption)((Object)this.cbPdfEncryption.getSelectedItem()));
        this.options.setPdfOwnerPwd(this.pfPdfOwnerPwd.getPassword());
        this.options.setPdfUserPwd(this.pfPdfUserPwd.getPassword());
        this.options.setPdfEncryptionCertFile(this.tfEncCertFile.getText());
        this.options.setOutFile(this.tfOutPdfFile.getText());
        this.options.setReason(this.tfReason.getText());
        this.options.setLocation(this.tfLocation.getText());
        this.options.setContact(this.tfContact.getText());
        this.options.setCertLevel((CertificationLevel)((Object)this.cbCertLevel.getSelectedItem()));
        this.options.setHashAlgorithm((HashAlgorithm)((Object)this.cbHashAlgorithm.getSelectedItem()));
        this.options.setAppend(this.chkbAppendSignature.isSelected());
        this.options.setRightPrinting((PrintRight)((Object)this.cbPrinting.getSelectedItem()));
        this.options.setRightCopy(this.chkbAllowCopy.isSelected());
        this.options.setRightAssembly(this.chkbAllowAssembly.isSelected());
        this.options.setRightFillIn(this.chkbAllowFillIn.isSelected());
        this.options.setRightScreanReaders(this.chkbAllowScreenReaders.isSelected());
        this.options.setRightModifyAnnotations(this.chkbAllowModifyAnnotations.isSelected());
        this.options.setRightModifyContents(this.chkbAllowModifyContent.isSelected());
        this.options.setVisible(this.chkbVisibleSig.isSelected());
    }

    private void refreshView() {
        boolean advanced = this.chkbAdvanced.isSelected();
        boolean visibleSignature = this.chkbVisibleSig.isSelected();
        boolean keystoreFileVisible = true;
        boolean keystorePwdVisible = true;
        boolean keyPwdVisible = advanced;
        boolean storePwdVisible = true;
        boolean encryptionEnabled = this.chkbAdvanced.isSelected() && this.cbPdfEncryption.getSelectedItem() != PDFEncryption.NONE;
        boolean passwordEncryptionVisible = encryptionEnabled && this.cbPdfEncryption.getSelectedItem() == PDFEncryption.PASSWORD;
        boolean certEncryptionVisible = encryptionEnabled && this.cbPdfEncryption.getSelectedItem() == PDFEncryption.CERTIFICATE;
        String selectedType = (String)this.cbKeystoreType.getSelectedItem();
        if (StringUtils.equals("WINDOWS-MY", selectedType)) {
            keystoreFileVisible = false;
            keystorePwdVisible = false;
            keyPwdVisible = false;
            storePwdVisible = advanced;
        }
        this.btnLoadAliases.setVisible(advanced);
        this.lblAlias.setVisible(advanced);
        this.cbAlias.setVisible(advanced);
        this.lblPdfEncryption.setVisible(advanced);
        this.cbPdfEncryption.setVisible(advanced);
        this.lblCertLevel.setVisible(advanced);
        this.cbCertLevel.setVisible(advanced);
        this.lblHashAlgorithm.setVisible(advanced);
        this.cbHashAlgorithm.setVisible(advanced);
        this.chkbAppendSignature.setEnabled(!encryptionEnabled);
        this.chkbAppendSignature.setVisible(advanced);
        if (encryptionEnabled) {
            this.chkbAppendSignature.setSelected(false);
        }
        this.btnTsaOcsp.setVisible(advanced);
        this.lblKeystoreFile.setVisible(keystoreFileVisible);
        this.tfKeystoreFile.setVisible(keystoreFileVisible);
        this.btnKeystoreFile.setVisible(keystoreFileVisible);
        this.lblKeystorePwd.setVisible(keystorePwdVisible);
        this.pfKeystorePwd.setVisible(keystorePwdVisible);
        this.lblKeyPwd.setVisible(keyPwdVisible);
        this.pfKeyPwd.setVisible(keyPwdVisible);
        this.lblPdfOwnerPwd.setVisible(passwordEncryptionVisible);
        this.pfPdfOwnerPwd.setVisible(passwordEncryptionVisible);
        this.lblPdfUserPwd.setVisible(passwordEncryptionVisible);
        this.pfPdfUserPwd.setVisible(passwordEncryptionVisible);
        this.lblEncCertFile.setVisible(certEncryptionVisible);
        this.tfEncCertFile.setVisible(certEncryptionVisible);
        this.btnEncCertFile.setVisible(certEncryptionVisible);
        this.btnRights.setVisible(encryptionEnabled);
        this.chkbStorePwd.setVisible(storePwdVisible);
        this.btnVisibleSigSettings.setEnabled(visibleSignature);
    }

    void showFileChooser(JTextField aFileField, FileFilter aFilter, int aType) {
        this.fc.showFileChooser(aFileField, aFilter, aType);
    }

    private void initComponents() {
        this.infoDialog = new JFrame();
        this.infoScrollPane = new JScrollPane();
        this.infoTextArea = new JTextArea();
        this.btnInfoClose = new JButton();
        this.rightsDialog = new JDialog();
        this.lblPrinting = new JLabel();
        this.cbPrinting = new JComboBox();
        this.lblRights = new JLabel();
        this.chkbAllowCopy = new JCheckBox();
        this.chkbAllowAssembly = new JCheckBox();
        this.chkbAllowFillIn = new JCheckBox();
        this.chkbAllowScreenReaders = new JCheckBox();
        this.chkbAllowModifyAnnotations = new JCheckBox();
        this.chkbAllowModifyContent = new JCheckBox();
        this.btnRightsOK = new JButton();
        this.lblKeystoreType = new JLabel();
        this.cbKeystoreType = new JComboBox();
        this.lblKeystoreFile = new JLabel();
        this.btnVisibleSigSettings = new JButton();
        this.tfKeystoreFile = new JTextField();
        this.btnKeystoreFile = new JButton();
        this.lblKeystorePwd = new JLabel();
        this.pfKeystorePwd = new JPasswordField();
        this.chkbStorePwd = new JCheckBox();
        this.lblAlias = new JLabel();
        this.cbAlias = new JComboBox();
        this.btnLoadAliases = new JButton();
        this.lblKeyPwd = new JLabel();
        this.pfKeyPwd = new JPasswordField();
        this.lblInPdfFile = new JLabel();
        this.tfInPdfFile = new JTextField();
        this.btnInPdfFile = new JButton();
        this.lblPdfOwnerPwd = new JLabel();
        this.pfPdfOwnerPwd = new JPasswordField();
        this.lblPdfUserPwd = new JLabel();
        this.pfPdfUserPwd = new JPasswordField();
        this.lblOutPdfFile = new JLabel();
        this.tfOutPdfFile = new JTextField();
        this.btnOutPdfFile = new JButton();
        this.lblReason = new JLabel();
        this.tfReason = new JTextField();
        this.lblLocation = new JLabel();
        this.tfLocation = new JTextField();
        this.lblCertLevel = new JLabel();
        this.cbCertLevel = new JComboBox();
        this.chkbAppendSignature = new JCheckBox();
        this.btnSignIt = new JButton();
        this.chkbAdvanced = new JCheckBox();
        this.btnRights = new JButton();
        this.chkbVisibleSig = new JCheckBox();
        this.lblContact = new JLabel();
        this.tfContact = new JTextField();
        this.btnTsaOcsp = new JButton();
        this.cbHashAlgorithm = new JComboBox();
        this.lblHashAlgorithm = new JLabel();
        this.lblPdfEncryption = new JLabel();
        this.cbPdfEncryption = new JComboBox();
        this.lblEncCertFile = new JLabel();
        this.tfEncCertFile = new JTextField();
        this.btnEncCertFile = new JButton();
        this.infoDialog.setTitle("PDF Signer Output");
        this.infoDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SignPdfForm.this.infoDialogWindowClosing(evt);
            }
        });
        this.infoTextArea.setColumns(80);
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setFont(new Font("Courier New", 1, 10));
        this.infoTextArea.setRows(25);
        this.infoTextArea.setMinimumSize(new Dimension(200, 180));
        this.infoScrollPane.setViewportView(this.infoTextArea);
        this.infoDialog.getContentPane().add((Component)this.infoScrollPane, "Center");
        this.btnInfoClose.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/back16.png")));
        this.btnInfoClose.setText("Close");
        this.btnInfoClose.setMinimumSize(new Dimension(50, 20));
        this.btnInfoClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.btnInfoCloseActionPerformed(evt);
            }
        });
        this.infoDialog.getContentPane().add((Component)this.btnInfoClose, "South");
        this.rightsDialog.setModal(true);
        this.rightsDialog.getContentPane().setLayout(new GridBagLayout());
        this.lblPrinting.setText("Printing");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.rightsDialog.getContentPane().add((Component)this.lblPrinting, gridBagConstraints);
        this.cbPrinting.setModel(new DefaultComboBoxModel<String>(new String[]{"Allow", "Allow Degraded", "Disallow"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.rightsDialog.getContentPane().add((Component)this.cbPrinting, gridBagConstraints);
        this.lblRights.setText("Rights");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.rightsDialog.getContentPane().add((Component)this.lblRights, gridBagConstraints);
        this.chkbAllowCopy.setText("Copy");
        this.chkbAllowCopy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.rightsDialog.getContentPane().add((Component)this.chkbAllowCopy, gridBagConstraints);
        this.chkbAllowAssembly.setText("Assembly");
        this.chkbAllowAssembly.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.rightsDialog.getContentPane().add((Component)this.chkbAllowAssembly, gridBagConstraints);
        this.chkbAllowFillIn.setText("Fill In");
        this.chkbAllowFillIn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.rightsDialog.getContentPane().add((Component)this.chkbAllowFillIn, gridBagConstraints);
        this.chkbAllowScreenReaders.setText("Screen readers");
        this.chkbAllowScreenReaders.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.rightsDialog.getContentPane().add((Component)this.chkbAllowScreenReaders, gridBagConstraints);
        this.chkbAllowModifyAnnotations.setText("Modify annotations");
        this.chkbAllowModifyAnnotations.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.rightsDialog.getContentPane().add((Component)this.chkbAllowModifyAnnotations, gridBagConstraints);
        this.chkbAllowModifyContent.setText("Modify contents");
        this.chkbAllowModifyContent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.rightsDialog.getContentPane().add((Component)this.chkbAllowModifyContent, gridBagConstraints);
        this.btnRightsOK.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/back16.png")));
        this.btnRightsOK.setText("OK");
        this.btnRightsOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.btnRightsOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 5, 2, 5);
        this.rightsDialog.getContentPane().add((Component)this.btnRightsOK, gridBagConstraints);
        this.setTitle("SignPdf");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SignPdfForm.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblKeystoreType.setLabelFor(this.cbKeystoreType);
        this.lblKeystoreType.setText("Keystore type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblKeystoreType, gridBagConstraints);
        this.cbKeystoreType.setModel(new DefaultComboBoxModel<String>(new String[]{"PKCS#12", "JKS"}));
        this.cbKeystoreType.setMinimumSize(new Dimension(150, 20));
        this.cbKeystoreType.setPreferredSize(new Dimension(150, 20));
        this.cbKeystoreType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.cbKeystoreTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.cbKeystoreType, gridBagConstraints);
        this.lblKeystoreFile.setLabelFor(this.tfKeystoreFile);
        this.lblKeystoreFile.setText("Keystore file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblKeystoreFile, gridBagConstraints);
        this.btnVisibleSigSettings.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/options16.png")));
        this.btnVisibleSigSettings.setText("Settings");
        this.btnVisibleSigSettings.setHorizontalAlignment(10);
        this.btnVisibleSigSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.btnVisibleSigSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.getContentPane().add((Component)this.btnVisibleSigSettings, gridBagConstraints);
        this.tfKeystoreFile.setMinimumSize(new Dimension(250, 20));
        this.tfKeystoreFile.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.tfKeystoreFile, gridBagConstraints);
        this.btnKeystoreFile.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/fileopen16.png")));
        this.btnKeystoreFile.setText("Browse...");
        this.btnKeystoreFile.setHorizontalAlignment(10);
        this.btnKeystoreFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.btnKeystoreFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.getContentPane().add((Component)this.btnKeystoreFile, gridBagConstraints);
        this.lblKeystorePwd.setLabelFor(this.pfKeystorePwd);
        this.lblKeystorePwd.setText("Keystore password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblKeystorePwd, gridBagConstraints);
        this.pfKeystorePwd.setMinimumSize(new Dimension(150, 20));
        this.pfKeystorePwd.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.pfKeystorePwd, gridBagConstraints);
        this.chkbStorePwd.setText("Store passwords");
        this.chkbStorePwd.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.getContentPane().add((Component)this.chkbStorePwd, gridBagConstraints);
        this.lblAlias.setLabelFor(this.cbAlias);
        this.lblAlias.setText("Key alias");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblAlias, gridBagConstraints);
        this.cbAlias.setEditable(true);
        this.cbAlias.setMinimumSize(new Dimension(150, 20));
        this.cbAlias.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.cbAlias, gridBagConstraints);
        this.btnLoadAliases.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/refresh16.png")));
        this.btnLoadAliases.setText("Load keys");
        this.btnLoadAliases.setHorizontalAlignment(10);
        this.btnLoadAliases.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.btnLoadAliasesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.getContentPane().add((Component)this.btnLoadAliases, gridBagConstraints);
        this.lblKeyPwd.setLabelFor(this.pfKeyPwd);
        this.lblKeyPwd.setText("Key password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblKeyPwd, gridBagConstraints);
        this.pfKeyPwd.setMinimumSize(new Dimension(150, 20));
        this.pfKeyPwd.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.pfKeyPwd, gridBagConstraints);
        this.lblInPdfFile.setLabelFor(this.tfInPdfFile);
        this.lblInPdfFile.setText("Input PDF file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblInPdfFile, gridBagConstraints);
        this.tfInPdfFile.setMinimumSize(new Dimension(150, 20));
        this.tfInPdfFile.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.tfInPdfFile, gridBagConstraints);
        this.btnInPdfFile.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/fileopen16.png")));
        this.btnInPdfFile.setText("Browse...");
        this.btnInPdfFile.setHorizontalAlignment(10);
        this.btnInPdfFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.btnInPdfFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.getContentPane().add((Component)this.btnInPdfFile, gridBagConstraints);
        this.lblPdfOwnerPwd.setLabelFor(this.pfPdfOwnerPwd);
        this.lblPdfOwnerPwd.setText("Owner password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblPdfOwnerPwd, gridBagConstraints);
        this.pfPdfOwnerPwd.setMinimumSize(new Dimension(150, 20));
        this.pfPdfOwnerPwd.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.pfPdfOwnerPwd, gridBagConstraints);
        this.lblPdfUserPwd.setLabelFor(this.pfPdfUserPwd);
        this.lblPdfUserPwd.setText("User password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblPdfUserPwd, gridBagConstraints);
        this.pfPdfUserPwd.setMinimumSize(new Dimension(150, 20));
        this.pfPdfUserPwd.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.pfPdfUserPwd, gridBagConstraints);
        this.lblOutPdfFile.setLabelFor(this.tfOutPdfFile);
        this.lblOutPdfFile.setText("Output PDF file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblOutPdfFile, gridBagConstraints);
        this.tfOutPdfFile.setMinimumSize(new Dimension(150, 20));
        this.tfOutPdfFile.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.tfOutPdfFile, gridBagConstraints);
        this.btnOutPdfFile.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/fileopen16.png")));
        this.btnOutPdfFile.setText("Browse...");
        this.btnOutPdfFile.setHorizontalAlignment(10);
        this.btnOutPdfFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.btnOutPdfFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.getContentPane().add((Component)this.btnOutPdfFile, gridBagConstraints);
        this.lblReason.setLabelFor(this.tfReason);
        this.lblReason.setText("Reason");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblReason, gridBagConstraints);
        this.tfReason.setMinimumSize(new Dimension(150, 20));
        this.tfReason.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.tfReason, gridBagConstraints);
        this.lblLocation.setLabelFor(this.tfLocation);
        this.lblLocation.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblLocation, gridBagConstraints);
        this.tfLocation.setMinimumSize(new Dimension(150, 20));
        this.tfLocation.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.tfLocation, gridBagConstraints);
        this.lblCertLevel.setLabelFor(this.cbCertLevel);
        this.lblCertLevel.setText("Certification level");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblCertLevel, gridBagConstraints);
        this.cbCertLevel.setMinimumSize(new Dimension(150, 20));
        this.cbCertLevel.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.cbCertLevel, gridBagConstraints);
        this.chkbAppendSignature.setText("Append signature");
        this.chkbAppendSignature.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.chkbAppendSignature, gridBagConstraints);
        this.btnSignIt.setFont(new Font("Tahoma", 1, 12));
        this.btnSignIt.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/signedpdf26.png")));
        this.btnSignIt.setText("Sign It");
        this.btnSignIt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.btnSignItActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnSignIt, gridBagConstraints);
        this.chkbAdvanced.setText("Advanced view");
        this.chkbAdvanced.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkbAdvanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.chkbAdvancedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.getContentPane().add((Component)this.chkbAdvanced, gridBagConstraints);
        this.btnRights.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/security16.png")));
        this.btnRights.setText("Rights");
        this.btnRights.setHorizontalAlignment(10);
        this.btnRights.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.btnRightsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.getContentPane().add((Component)this.btnRights, gridBagConstraints);
        this.chkbVisibleSig.setText("Visible signature");
        this.chkbVisibleSig.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkbVisibleSig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.chkbVisibleSigActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.chkbVisibleSig, gridBagConstraints);
        this.lblContact.setLabelFor(this.tfContact);
        this.lblContact.setText("Contact");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblContact, gridBagConstraints);
        this.tfContact.setMinimumSize(new Dimension(150, 20));
        this.tfContact.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.tfContact, gridBagConstraints);
        this.btnTsaOcsp.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/clock16.png")));
        this.btnTsaOcsp.setText("TSA & OCSP");
        this.btnTsaOcsp.setHorizontalAlignment(10);
        this.btnTsaOcsp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.btnTsaOcspActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.getContentPane().add((Component)this.btnTsaOcsp, gridBagConstraints);
        this.cbHashAlgorithm.setMinimumSize(new Dimension(150, 20));
        this.cbHashAlgorithm.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.cbHashAlgorithm, gridBagConstraints);
        this.lblHashAlgorithm.setLabelFor(this.cbHashAlgorithm);
        this.lblHashAlgorithm.setText("Hash algorithm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblHashAlgorithm, gridBagConstraints);
        this.lblPdfEncryption.setLabelFor(this.cbPdfEncryption);
        this.lblPdfEncryption.setText("PDF Encryption");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblPdfEncryption, gridBagConstraints);
        this.cbPdfEncryption.setMinimumSize(new Dimension(150, 20));
        this.cbPdfEncryption.setPreferredSize(new Dimension(150, 20));
        this.cbPdfEncryption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.cbPdfEncryptionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.cbPdfEncryption, gridBagConstraints);
        this.lblEncCertFile.setLabelFor(this.tfEncCertFile);
        this.lblEncCertFile.setText("Certificate file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.getContentPane().add((Component)this.lblEncCertFile, gridBagConstraints);
        this.tfEncCertFile.setMinimumSize(new Dimension(150, 20));
        this.tfEncCertFile.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.getContentPane().add((Component)this.tfEncCertFile, gridBagConstraints);
        this.btnEncCertFile.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/fileopen16.png")));
        this.btnEncCertFile.setText("Browse...");
        this.btnEncCertFile.setHorizontalAlignment(10);
        this.btnEncCertFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignPdfForm.this.btnEncCertFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        this.getContentPane().add((Component)this.btnEncCertFile, gridBagConstraints);
        this.pack();
    }

    private void btnEncCertFileActionPerformed(ActionEvent evt) {
        this.showFileChooser(this.tfEncCertFile, null, 0);
    }

    private void cbPdfEncryptionActionPerformed(ActionEvent evt) {
        this.refreshView();
        this.pack();
    }

    private void btnVisibleSigSettingsActionPerformed(ActionEvent evt) {
        this.storeToOptions();
        this.vsDialog.setVisible(true);
    }

    private void chkbVisibleSigActionPerformed(ActionEvent evt) {
        this.refreshView();
    }

    private void btnRightsOKActionPerformed(ActionEvent evt) {
        this.rightsDialog.setVisible(false);
    }

    private void btnRightsActionPerformed(ActionEvent evt) {
        this.rightsDialog.setVisible(true);
    }

    private void btnLoadAliasesActionPerformed(ActionEvent evt) {
        this.storeToOptions();
        try {
            this.cbAlias.setModel(new DefaultComboBoxModel<String>(KeyStoreUtils.getKeyAliases(this.options)));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error", 0);
        }
    }

    private void chkbAdvancedActionPerformed(ActionEvent evt) {
        this.refreshView();
        this.pack();
    }

    private void infoDialogWindowClosing(WindowEvent evt) {
        if (this.btnInfoClose.isEnabled()) {
            this.setVisible(true);
        }
    }

    @Override
    public synchronized void signerFinishedEvent(Throwable e) {
        if (e instanceof SSLHandshakeException) {
            JOptionPane.showMessageDialog(this, Constants.RES.get("error.sslHandshakeException"), "Error", 2);
        }
        this.btnInfoClose.setEnabled(true);
        this.infoDialog.setDefaultCloseOperation(1);
        if (!this.btnInfoClose.hasFocus()) {
            this.btnInfoClose.requestFocus();
        }
        if (this.autoclose) {
            this.btnInfoCloseActionPerformed(null);
        }
    }

    private void btnInfoCloseActionPerformed(ActionEvent evt) {
        this.infoDialog.setVisible(false);
        this.setVisible(true);
    }

    private boolean checkFileExists(JTextField aTF, String aFileDescKey) {
        String tmpFileName = aTF.getText();
        try {
            File tmpFile;
            if (tmpFileName != null && (tmpFile = new File(tmpFileName)).canRead() && !tmpFile.isDirectory()) {
                return true;
            }
        }
        catch (Exception tmpFile) {
            // empty catch block
        }
        String tmpMsg = Constants.RES.get("gui.fileNotExists.error", Constants.RES.get(aFileDescKey));
        JOptionPane.showMessageDialog(this, tmpMsg, Constants.RES.get("gui.check.error.title"), 0);
        return false;
    }

    private boolean checkInOutDiffers() {
        String tmpInName = this.tfInPdfFile.getText();
        String tmpOutName = this.tfOutPdfFile.getText();
        boolean tmpResult = true;
        if (tmpInName != null && StringUtils.isNotEmpty(tmpOutName)) {
            try {
                File tmpInFile = new File(tmpInName).getAbsoluteFile();
                File tmpOutFile = new File(tmpOutName).getAbsoluteFile();
                if (tmpInFile.equals(tmpOutFile)) {
                    tmpResult = false;
                    JOptionPane.showMessageDialog(this, Constants.RES.get("gui.filesEqual.error"), Constants.RES.get("gui.check.error.title"), 0);
                }
            }
            catch (Exception e) {
                tmpResult = false;
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            }
        }
        return tmpResult;
    }

    private boolean checkCertEncryption() {
        boolean tmpResult = true;
        if (this.chkbAdvanced.isSelected() && this.cbPdfEncryption.getSelectedItem() == PDFEncryption.CERTIFICATE && (tmpResult = this.checkFileExists(this.tfEncCertFile, "gui.encryptionCertFile.label")) && !KeyStoreUtils.isEncryptionSupported(KeyStoreUtils.loadCertificate(this.tfEncCertFile.getText()))) {
            tmpResult = false;
            JOptionPane.showMessageDialog(this, Constants.RES.get("gui.certificateNotForEncryption.error", this.tfEncCertFile.getText()), Constants.RES.get("gui.check.error.title"), 0);
        }
        return tmpResult;
    }

    private void btnSignItActionPerformed(ActionEvent evt) {
        String tmpOut = this.tfOutPdfFile.getText();
        if (StringUtils.isNotEmpty(tmpOut)) {
            File tmpOutFile = new File(tmpOut);
            if (!tmpOut.toLowerCase().endsWith(".pdf") && !tmpOutFile.isFile()) {
                this.tfOutPdfFile.setText(tmpOut + ".pdf");
            }
        }
        this.storeToOptions();
        if (this.checkFileExists(this.tfInPdfFile, "gui.inPdfFile.label") && this.checkInOutDiffers() && this.checkCertEncryption()) {
            this.infoTextArea.setText(null);
            this.btnInfoClose.setEnabled(false);
            this.infoDialog.setVisible(true);
            this.setVisible(false);
            this.infoDialog.setDefaultCloseOperation(0);
            Constants.LOGGER.info(Constants.RES.get("console.starting"));
            Thread tmpST = new Thread(this.signerLogic);
            tmpST.start();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        try {
            this.storeToOptions();
            this.options.storeOptions();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PKCS11Utils.unregisterProviders();
    }

    private void btnOutPdfFileActionPerformed(ActionEvent evt) {
        this.showFileChooser(this.tfOutPdfFile, SignerFileChooser.FILEFILTER_PDF, 1);
    }

    private void cbKeystoreTypeActionPerformed(ActionEvent evt) {
        this.refreshView();
        this.pack();
    }

    private void btnInPdfFileActionPerformed(ActionEvent evt) {
        this.showFileChooser(this.tfInPdfFile, SignerFileChooser.FILEFILTER_PDF, 0);
    }

    private void btnKeystoreFileActionPerformed(ActionEvent evt) {
        this.showFileChooser(this.tfKeystoreFile, null, 0);
    }

    private void btnTsaOcspActionPerformed(ActionEvent evt) {
        this.tsaDialog.setVisible(true);
    }
}

