/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.crl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import net.sf.jsignpdf.BasicSignerOptions;
import net.sf.jsignpdf.Constants;
import org.apache.commons.io.input.CountingInputStream;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class CRLInfo {
    private CRL[] crls;
    private long byteCount = 0L;
    private BasicSignerOptions options;
    private Certificate[] certChain;

    public CRLInfo(BasicSignerOptions anOptions, Certificate[] aChain) {
        if (anOptions == null || aChain == null) {
            throw new NullPointerException();
        }
        this.options = anOptions;
        this.certChain = aChain;
    }

    public CRL[] getCrls() {
        this.initCrls();
        return this.crls;
    }

    public long getByteCount() {
        this.initCrls();
        return this.byteCount;
    }

    private void initCrls() {
        if (!this.options.isCrlEnabledX() || this.crls != null) {
            return;
        }
        Constants.LOGGER.info(Constants.RES.get("console.readingCRLs"));
        HashSet<String> urls = new HashSet<String>();
        for (Certificate cert : this.certChain) {
            if (!(cert instanceof X509Certificate)) continue;
            urls.addAll(this.getCrlUrls((X509Certificate)cert));
        }
        HashSet<CRL> crlSet = new HashSet<CRL>();
        for (String urlStr : urls) {
            try {
                Constants.LOGGER.info(Constants.RES.get("console.crlinfo.loadCrl", urlStr));
                URL tmpUrl = new URL(urlStr);
                CountingInputStream inStream = new CountingInputStream(tmpUrl.openConnection(this.options.createProxy()).getInputStream());
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                CRL crl = cf.generateCRL(inStream);
                long tmpBytesRead = inStream.getByteCount();
                Constants.LOGGER.info(Constants.RES.get("console.crlinfo.crlSize", String.valueOf(tmpBytesRead)));
                if (!crlSet.contains(crl)) {
                    this.byteCount += tmpBytesRead;
                    crlSet.add(crl);
                } else {
                    Constants.LOGGER.info(Constants.RES.get("console.crlinfo.alreadyLoaded"));
                }
                inStream.close();
            }
            catch (MalformedURLException e) {
                Constants.LOGGER.log(Level.WARNING, "", e);
            }
            catch (IOException e) {
                Constants.LOGGER.log(Level.WARNING, "", e);
            }
            catch (CertificateException e) {
                Constants.LOGGER.log(Level.WARNING, "", e);
            }
            catch (CRLException e) {
                Constants.LOGGER.log(Level.WARNING, "", e);
            }
        }
        this.crls = crlSet.toArray(new CRL[crlSet.size()]);
    }

    private Set<String> getCrlUrls(X509Certificate aCert) {
        HashSet<String> tmpResult = new HashSet<String>();
        Constants.LOGGER.info(Constants.RES.get("console.crlinfo.retrieveCrlUrl", aCert.getSubjectX500Principal().getName()));
        byte[] crlDPExtension = aCert.getExtensionValue(X509Extension.cRLDistributionPoints.getId());
        if (crlDPExtension != null) {
            CRLDistPoint crlDistPoints = null;
            try {
                crlDistPoints = CRLDistPoint.getInstance(X509ExtensionUtil.fromExtensionValue(crlDPExtension));
            }
            catch (IOException e) {
                Constants.LOGGER.log(Level.WARNING, "", e);
            }
            if (crlDistPoints != null) {
                DistributionPoint[] distPoints;
                block2: for (DistributionPoint dp : distPoints = crlDistPoints.getDistributionPoints()) {
                    DistributionPointName dpName = dp.getDistributionPoint();
                    GeneralNames generalNames = (GeneralNames)dpName.getName();
                    if (generalNames == null) continue;
                    GeneralName[] generalNameArr = generalNames.getNames();
                    if (generalNameArr != null) {
                        for (GeneralName generalName : generalNameArr) {
                            ASN1String derString;
                            String uri;
                            if (generalName.getTagNo() != 6 || (uri = (derString = (ASN1String)((Object)generalName.getName())).getString()) == null || !uri.startsWith("http")) continue;
                            Constants.LOGGER.info(Constants.RES.get("console.crlinfo.foundCrlUri", uri));
                            tmpResult.add(uri);
                            continue block2;
                        }
                    }
                    Constants.LOGGER.info(Constants.RES.get("console.crlinfo.noUrlInDistPoint"));
                }
            }
        } else {
            Constants.LOGGER.info(Constants.RES.get("console.crlinfo.distPointNotSupported"));
        }
        return tmpResult;
    }
}

