/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.utils;

public class ConvertUtils {
    public static String toString(Object anObj) {
        return anObj == null ? null : anObj.toString();
    }

    public static String toString(int aValue) {
        return String.valueOf(aValue);
    }

    public static String toString(long aValue) {
        return String.valueOf(aValue);
    }

    public static String toString(float aValue) {
        return String.valueOf(aValue);
    }

    public static String toString(double aValue) {
        return String.valueOf(aValue);
    }

    public static String toString(boolean aValue) {
        return String.valueOf(aValue);
    }

    public static Integer toInteger(Object anObj) {
        if (anObj == null) {
            return null;
        }
        Integer tmpResult = null;
        if (anObj instanceof Integer) {
            tmpResult = (Integer)anObj;
        } else if (anObj instanceof Number) {
            tmpResult = new Integer(((Number)anObj).intValue());
        } else {
            try {
                tmpResult = new Integer(ConvertUtils.toString(anObj));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return tmpResult;
    }

    public static int toInt(Object anObj, int aDefault) {
        Integer tmpInteger = ConvertUtils.toInteger(anObj);
        return tmpInteger == null ? aDefault : tmpInteger;
    }

    public static Float toFloat(Object anObj) {
        if (anObj == null) {
            return null;
        }
        Float tmpResult = null;
        if (anObj instanceof Float) {
            tmpResult = (Float)anObj;
        } else if (anObj instanceof Number) {
            tmpResult = new Float(((Number)anObj).floatValue());
        } else {
            try {
                tmpResult = new Float(ConvertUtils.toString(anObj));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return tmpResult;
    }

    public static float toFloat(Object anObj, float aDefault) {
        Float tmpVal = ConvertUtils.toFloat(anObj);
        return tmpVal == null ? aDefault : tmpVal.floatValue();
    }

    public static Boolean toBoolean(Object anObj) {
        Boolean tmpResult = null;
        if (anObj != null) {
            if (anObj instanceof Boolean) {
                tmpResult = (Boolean)anObj;
            } else {
                String tmpStr = ConvertUtils.toString(anObj);
                if ("true".equalsIgnoreCase(tmpStr) || "yes".equalsIgnoreCase(tmpStr) || "on".equalsIgnoreCase(tmpStr)) {
                    tmpResult = Boolean.TRUE;
                } else if ("false".equalsIgnoreCase(tmpStr) || "no".equalsIgnoreCase(tmpStr) || "off".equalsIgnoreCase(tmpStr)) {
                    tmpResult = Boolean.FALSE;
                }
            }
        }
        return tmpResult;
    }

    public static boolean toBoolean(Object anObj, boolean aDefault) {
        Boolean tmpBool = ConvertUtils.toBoolean(anObj);
        return tmpBool == null ? aDefault : tmpBool;
    }
}

