/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.utils;

import com.lowagie.text.pdf.BaseFont;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jsignpdf.utils.ConfigProvider;
import org.apache.commons.io.IOUtils;

public class FontUtils {
    public static BaseFont l2baseFont;

    public static synchronized BaseFont getL2BaseFont() {
        if (l2baseFont == null) {
            ConfigProvider conf = ConfigProvider.getInstance();
            try {
                InputStream tmpIs;
                String fontEncoding;
                String fontName;
                ByteArrayOutputStream tmpBaos = new ByteArrayOutputStream();
                String fontPath = conf.getNotEmptyProperty("font.path", null);
                if (fontPath != null) {
                    fontName = conf.getNotEmptyProperty("font.name", null);
                    if (fontName == null) {
                        fontName = new File(fontPath).getName();
                    }
                    if ((fontEncoding = conf.getNotEmptyProperty("font.encoding", null)) == null) {
                        fontEncoding = "Cp1252";
                    }
                    tmpIs = new FileInputStream(fontPath);
                } else {
                    fontName = "DejaVuSans.ttf";
                    fontEncoding = "Identity-H";
                    tmpIs = FontUtils.class.getResourceAsStream("/net/sf/jsignpdf/fonts/DejaVuSans.ttf");
                }
                IOUtils.copy(tmpIs, (OutputStream)tmpBaos);
                tmpIs.close();
                tmpBaos.close();
                l2baseFont = BaseFont.createFont(fontName, fontEncoding, true, true, tmpBaos.toByteArray(), null);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    l2baseFont = BaseFont.createFont("Helvetica", "Cp1252", true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return l2baseFont;
    }
}

