/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.utils;

import java.io.File;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Level;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class PKCS11Utils {
    public static volatile Provider SUN_PROVIDER;
    public static volatile Provider JSIGN_PROVIDER;

    public static void registerProviders(String configPath) {
        if (StringUtils.isEmpty(configPath)) {
            return;
        }
        Constants.LOGGER.fine("Registering SunPKCS11 provider from configuration in " + configPath);
        File cfgFile = IOUtils.findFile(configPath);
        String absolutePath = cfgFile.getAbsolutePath();
        if (cfgFile.isFile()) {
            SUN_PROVIDER = PKCS11Utils.initPkcs11Provider(absolutePath, "sun.security.pkcs11.SunPKCS11");
            JSIGN_PROVIDER = PKCS11Utils.initPkcs11Provider(absolutePath, "com.github.kwart.jsign.pkcs11.JSignPKCS11");
        } else {
            System.err.println("The PKCS#11 provider is not registered. Configuration file doesn't exist: " + absolutePath);
        }
    }

    public static void unregisterProviders() {
        SUN_PROVIDER = PKCS11Utils.unregisterProvider(SUN_PROVIDER);
        JSIGN_PROVIDER = PKCS11Utils.unregisterProvider(JSIGN_PROVIDER);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String getProviderNameForKeystoreType(String type) {
        if (type == null) {
            return null;
        }
        String name = PKCS11Utils.getProviderNameImpl(type, SUN_PROVIDER);
        if (name == null) {
            name = PKCS11Utils.getProviderNameImpl(type, JSIGN_PROVIDER);
        }
        return name;
    }

    private static Provider initPkcs11Provider(String configPath, String className) {
        Provider pkcs11Provider = null;
        try {
            Class<?> sunPkcs11Cls = Class.forName(className);
            try {
                pkcs11Provider = (Provider)sunPkcs11Cls.getConstructor(String.class).newInstance(configPath);
            }
            catch (NoSuchMethodException e) {
                pkcs11Provider = (Provider)sunPkcs11Cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                Class<Provider> provCls = Provider.class;
                pkcs11Provider = (Provider)provCls.getMethod("configure", String.class).invoke((Object)pkcs11Provider, configPath);
            }
            Security.addProvider(pkcs11Provider);
            String name = pkcs11Provider.getName();
            Constants.LOGGER.fine("PKCS11 provider registered with name " + name);
        }
        catch (Throwable e) {
            Constants.LOGGER.log(Level.SEVERE, "Unable to register SunPKCS11 security provider.", e);
        }
        return pkcs11Provider;
    }

    private static Provider unregisterProvider(Provider provider) {
        if (provider == null) {
            return null;
        }
        String providerName = provider.getName();
        Constants.LOGGER.fine("Removing security provider with name " + providerName);
        try {
            Security.removeProvider(providerName);
        }
        catch (Exception e) {
            Constants.LOGGER.log(Level.SEVERE, "Removing provider failed", e);
        }
        return null;
    }

    private static String getProviderNameImpl(String type, Provider provider) {
        if (provider == null || type == null) {
            return null;
        }
        String providerName = provider.getName();
        try {
            KeyStore.getInstance(type, provider);
            Constants.LOGGER.fine("KeyStore type " + type + " is supported by the provider " + providerName);
            return provider.getName();
        }
        catch (Exception e) {
            Constants.LOGGER.fine("KeyStore type " + type + " is not supported by the provider " + providerName);
            return null;
        }
    }
}

